"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withDiagnoseButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553831493318382/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_map/popover/with_diagnose_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// This HOC wraps a component and adds a diagnose button at the bottom if showDiagnoseButton is true.
const withDiagnoseButton = WrappedComponent => {
  function ComponentWithDiagnoseButton(props) {
    const {
      showDiagnoseButton,
      onDiagnoseClick,
      ...rest
    } = props;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(WrappedComponent, (0, _extends2.default)({}, rest, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 31,
        columnNumber: 9
      }
    })), showDiagnoseButton && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      color: "subdued",
      hasBorder: false,
      paddingSize: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      responsive: false,
      direction: "column",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "crossInCircle",
      color: "warning",
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 21
      }
    }), ' ', /*#__PURE__*/_react.default.createElement("strong", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 21
      }
    }, _i18n.i18n.translate('xpack.apm.serviceMap.diagnosisTitle', {
      defaultMessage: 'Missing connection?'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "aria-label": _i18n.i18n.translate('xpack.apm.componentWithDiagnoseButton.diagnosethisconnectionButton.ariaLabel', {
        defaultMessage: 'Diagnose this connection'
      }),
      "data-test-subj": "diagnose-connection-button",
      onClick: onDiagnoseClick,
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 21
      }
    }, _i18n.i18n.translate('xpack.apm.serviceMap.diagnoseConnectionButtonText', {
      defaultMessage: 'Open diagnostic tool'
    }))))))));
  }
  return ComponentWithDiagnoseButton;
};
exports.withDiagnoseButton = withDiagnoseButton;