"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentConfigInstructions = AgentConfigInstructions;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _get_apm_agent_commands = require("./commands/get_apm_agent_commands");
var _agent_config_table = require("./agent_config_table");
var _commands_instructions_codeblock = require("../../../tutorial/config_agent/commands_instructions_codeblock");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553831493318382/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/onboarding/agent_config_instructions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const API_KEY_COMMAND_PLACEHOLDER = '<API_KEY>';
const SECRET_TOKEN_COMMAND_PLACEHOLDER = '<SECRET_TOKEN>';
function AgentConfigInstructions({
  variantId,
  apmServerUrl,
  secretToken,
  apiKey,
  createApiKey,
  createApiKeyLoading
}) {
  const commands = (0, _get_apm_agent_commands.getApmAgentCommands)({
    variantId,
    apmServerUrl,
    secretToken: `${SECRET_TOKEN_COMMAND_PLACEHOLDER}`,
    apiKey: ` ${API_KEY_COMMAND_PLACEHOLDER}`
  });
  const commandsWithSecrets = (0, _get_apm_agent_commands.getApmAgentCommands)({
    variantId,
    apmServerUrl,
    secretToken,
    apiKey
  });
  const variables = (0, _get_apm_agent_commands.getApmAgentVariables)(variantId, secretToken);
  const lineNumbers = (0, _get_apm_agent_commands.getApmAgentLineNumbers)(variantId, apiKey);
  const highlightLang = (0, _get_apm_agent_commands.getApmAgentHighlightLang)(variantId);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_agent_config_table.AgentConfigurationTable, {
    variables: variables,
    data: {
      apmServerUrl,
      secretToken,
      apiKey
    },
    createApiKey: createApiKey,
    createApiKeyLoading: createApiKeyLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_commands_instructions_codeblock.CommandsInstructionsCodeblock, {
    variantId: variantId,
    lineNumbers: lineNumbers,
    highlightLang: highlightLang,
    commands: commands,
    commandsWithSecrets: commandsWithSecrets,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }));
}