"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLastRun = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _plugin = require("../../plugin");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLastRun = async (context, req) => {
  const esClient = await context.elasticsearchClientPromise;
  const spacesService = await context.spacesService;
  const currentSpaceId = spacesService ? spacesService.getSpaceId(req) : 'default';
  try {
    const searchResponse = await esClient.search({
      index: '.kibana-event-log*',
      query: {
        bool: {
          filter: [{
            term: {
              'event.action': _plugin.EVENT_LOG_ACTIONS.deleteAlerts
            }
          }, {
            term: {
              'event.provider': _plugin.EVENT_LOG_PROVIDER
            }
          }, {
            term: {
              'kibana.space_ids': currentSpaceId
            }
          }]
        }
      },
      size: 1,
      sort: [{
        [_ruleDataUtils.TIMESTAMP]: 'desc'
      }]
    });
    if (searchResponse.hits.hits.length > 0) {
      var _searchResponse$hits$;
      return (_searchResponse$hits$ = searchResponse.hits.hits[0]._source) === null || _searchResponse$hits$ === void 0 ? void 0 : _searchResponse$hits$['@timestamp'];
    }
  } catch (err) {
    context.logger.error(`Error getting last run date: ${err.message}`);
  }
};
exports.getLastRun = getLastRun;