"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogCategorizationFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlUrlState = require("@kbn/ml-url-state");
var _constants = require("@kbn/aiops-common/constants");
var _use_table_state = require("@kbn/ml-in-memory-table/hooks/use_table_state");
var _esQuery = require("@kbn/es-query");
var _dataService = require("@kbn/data-service");
var _log_pattern_analysis = require("../../application/url_state/log_pattern_analysis");
var _use_data = require("../../hooks/use_data");
var _use_search = require("../../hooks/use_search");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _use_categorize_request = require("./use_categorize_request");
var _category_table = require("./category_table");
var _information_text = require("./information_text");
var _sampling_menu = require("./sampling_menu");
var _loading_categorization = require("./loading_categorization");
var _use_validate_category_field = require("./use_validate_category_field");
var _category_validation_callout = require("./category_validation_callout");
var _create_categorization_job = require("./create_categorization_job");
var _table_header = require("./category_table/table_header");
var _use_actions = require("./category_table/use_actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553831493318382/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/components/log_categorization/log_categorization_for_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var SELECTED_TAB = /*#__PURE__*/function (SELECTED_TAB) {
  SELECTED_TAB[SELECTED_TAB["BUCKET"] = 0] = "BUCKET";
  SELECTED_TAB[SELECTED_TAB["FULL_TIME_RANGE"] = 1] = "FULL_TIME_RANGE";
  return SELECTED_TAB;
}(SELECTED_TAB || {});
const BAR_TARGET = 20;
const LogCategorizationFlyout = ({
  dataView,
  savedSearch,
  selectedField,
  onClose,
  additionalFilter
}) => {
  var _data$categories$leng, _data$categories;
  const {
    notifications: {
      toasts
    },
    data: {
      query: {
        getState
      }
    },
    uiSettings,
    embeddingOrigin
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const {
    runValidateFieldRequest,
    cancelRequest: cancelValidationRequest
  } = (0, _use_validate_category_field.useValidateFieldRequest)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    filters,
    query
  } = (0, _react.useMemo)(() => getState(), [getState]);
  const mounted = (0, _react.useRef)(false);
  const randomSamplerStorage = (0, _sampling_menu.useRandomSamplerStorage)();
  const {
    runCategorizeRequest,
    cancelRequest: cancelCategorizationRequest,
    randomSampler
  } = (0, _use_categorize_request.useCategorizeRequest)(randomSamplerStorage);
  const [stateFromUrl] = (0, _mlUrlState.usePageUrlState)('logCategorization', (0, _log_pattern_analysis.getDefaultLogCategorizationAppState)({
    searchQuery: (0, _esQuery.buildEsQuery)(dataView, query !== null && query !== void 0 ? query : [], filters !== null && filters !== void 0 ? filters : [], uiSettings ? (0, _dataService.getEsQueryConfig)(uiSettings) : undefined)
  }));
  const [selectedCategories, setSelectedCategories] = (0, _react.useState)([]);
  const [loading, setLoading] = (0, _react.useState)(true);
  const [eventRate, setEventRate] = (0, _react.useState)([]);
  const [data, setData] = (0, _react.useState)(null);
  const [fieldValidationResult, setFieldValidationResult] = (0, _react.useState)(null);
  const [showTabs, setShowTabs] = (0, _react.useState)(false);
  const [selectedTab, setSelectedTab] = (0, _react.useState)(SELECTED_TAB.FULL_TIME_RANGE);
  const tableState = (0, _use_table_state.useTableState)([], 'key');
  const cancelRequest = (0, _react.useCallback)(() => {
    cancelValidationRequest();
    cancelCategorizationRequest();
  }, [cancelCategorizationRequest, cancelValidationRequest]);
  (0, _react.useEffect)(function cancelRequestOnLeave() {
    mounted.current = true;
    return () => {
      mounted.current = false;
      cancelRequest();
    };
  }, [cancelRequest, mounted]);
  const {
    searchQueryLanguage,
    searchString,
    searchQuery
  } = (0, _use_search.useSearch)({
    dataView,
    savedSearch
  }, stateFromUrl, true);
  const {
    documentStats,
    timefilter,
    earliest,
    latest,
    intervalMs,
    forceRefresh
  } = (0, _use_data.useData)(dataView, 'log_categorization', searchQuery, undefined, undefined, undefined, BAR_TARGET);
  const {
    getActions,
    openInDiscover
  } = (0, _use_actions.useActions)(dataView.id, selectedField, selectedCategories, stateFromUrl, timefilter, undefined, undefined);
  const loadCategories = (0, _react.useCallback)(async () => {
    const {
      getIndexPattern,
      timeFieldName: timeField
    } = dataView;
    const index = getIndexPattern();
    if (selectedField === undefined || timeField === undefined || earliest === undefined || latest === undefined) {
      return;
    }
    cancelRequest();
    setLoading(true);
    setData(null);
    setFieldValidationResult(null);
    const timeRange = {
      from: earliest,
      to: latest
    };
    const runtimeMappings = dataView.getRuntimeMappings();
    try {
      const [validationResult, categorizationResult] = await Promise.all([runValidateFieldRequest(index, selectedField.name, timeField, timeRange, searchQuery, runtimeMappings, {
        [_constants.AIOPS_ANALYSIS_RUN_ORIGIN]: embeddingOrigin
      }), runCategorizeRequest(index, selectedField.name, timeField, timeRange, searchQuery, runtimeMappings, intervalMs, additionalFilter)]);
      if (mounted.current === true) {
        setFieldValidationResult(validationResult);
        const {
          categories,
          hasExamples
        } = categorizationResult;
        const hasBucketCategories = categories.some(c => c.subTimeRangeCount !== undefined);
        let categoriesInBucket = null;
        if (additionalFilter !== undefined) {
          categoriesInBucket = categorizationResult.categories.map(category => {
            var _category$subFieldCou;
            return {
              ...category,
              count: (_category$subFieldCou = category.subFieldCount) !== null && _category$subFieldCou !== void 0 ? _category$subFieldCou : category.subTimeRangeCount,
              examples: category.subFieldExamples,
              sparkline: undefined
            };
          }).filter(category => category.count > 0).sort((a, b) => b.count - a.count);
        }
        setData({
          categories,
          categoriesInBucket,
          displayExamples: hasExamples
        });
        setShowTabs(hasBucketCategories);
        setSelectedTab(SELECTED_TAB.BUCKET);
      }
    } catch (error) {
      toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.aiops.logCategorization.errorLoadingCategories', {
          defaultMessage: 'Error loading categories'
        })
      });
    }
    if (mounted.current === true) {
      setLoading(false);
    }
  }, [dataView, selectedField, earliest, latest, cancelRequest, runValidateFieldRequest, searchQuery, embeddingOrigin, runCategorizeRequest, intervalMs, additionalFilter, toasts]);
  (0, _react.useEffect)(() => {
    var _documentStats$docume;
    if ((_documentStats$docume = documentStats.documentCountStats) !== null && _documentStats$docume !== void 0 && _documentStats$docume.buckets) {
      randomSampler.setDocCount(documentStats.totalCount);
      setEventRate(Object.entries(documentStats.documentCountStats.buckets).map(([key, docCount]) => ({
        key: +key,
        docCount
      })));
      setData(null);
      loadCategories();
    }
  }, [documentStats, earliest, latest, searchQueryLanguage, searchString, searchQuery, loadCategories, randomSampler]);
  const actions = getActions(true);
  const infoIconCss = {
    marginTop: euiTheme.size.m,
    marginLeft: euiTheme.size.xxs
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 302,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 303,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "flyoutTitle",
    "data-test-subj": "mlJobSelectorFlyoutTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.categorizeFlyout.title",
    defaultMessage: "Pattern analysis of {name}",
    values: {
      name: selectedField.name
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 315,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_sampling_menu.SamplingMenu, {
    randomSampler: randomSampler,
    reload: () => forceRefresh(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 316,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    "data-test-subj": "mlJobSelectorFlyoutBody",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 320,
      columnNumber: 7
    }
  }, showTabs === false && loading === false ? /*#__PURE__*/_react.default.createElement(_create_categorization_job.CreateCategorizationJobButton, {
    dataView: dataView,
    field: selectedField,
    query: searchQuery,
    earliest: earliest,
    latest: latest,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 322,
      columnNumber: 11
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_category_validation_callout.FieldValidationCallout, {
    validationResults: fieldValidationResult,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 330,
      columnNumber: 9
    }
  }), loading === true ? /*#__PURE__*/_react.default.createElement(_loading_categorization.LoadingCategorization, {
    onCancel: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 29
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_information_text.InformationText, {
    loading: loading,
    categoriesLength: (_data$categories$leng = data === null || data === void 0 ? void 0 : (_data$categories = data.categories) === null || _data$categories === void 0 ? void 0 : _data$categories.length) !== null && _data$categories$leng !== void 0 ? _data$categories$leng : null,
    eventRateLength: eventRate.length,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 332,
      columnNumber: 9
    }
  }), loading === false && data !== null && data.categories.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showTabs ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 341,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: selectedTab === SELECTED_TAB.BUCKET,
    onClick: () => setSelectedTab(SELECTED_TAB.BUCKET),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 342,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.aiops.logCategorization.tabs.bucket.tooltip', {
      defaultMessage: 'Patterns that occur in the anomalous bucket.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 346,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 351,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 352,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.logCategorization.tabs.bucket",
    defaultMessage: "Bucket",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 353,
      columnNumber: 27
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: infoIconCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 358,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "s",
    color: "subdued",
    type: "question",
    className: "eui-alignTop",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 359,
      columnNumber: 27
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: selectedTab === SELECTED_TAB.FULL_TIME_RANGE,
    onClick: () => setSelectedTab(SELECTED_TAB.FULL_TIME_RANGE),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 370,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.aiops.logCategorization.tabs.fullTimeRange.tooltip', {
      defaultMessage: 'Patterns that occur in the time range selected for the page.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 374,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 383,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 384,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.logCategorization.tabs.fullTimeRange",
    defaultMessage: "Full time range",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 385,
      columnNumber: 27
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: infoIconCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 390,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "s",
    color: "subdued",
    type: "question",
    className: "eui-alignTop",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 391,
      columnNumber: 27
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 402,
      columnNumber: 17
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_table_header.TableHeader, {
    categoriesCount: data.categories.length,
    selectedCategoriesCount: selectedCategories.length,
    openInDiscover: openInDiscover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 406,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 412,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 413,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_category_table.CategoryTable, {
    categories: selectedTab === SELECTED_TAB.BUCKET && data.categoriesInBucket !== null ? data.categoriesInBucket : data.categories,
    eventRate: eventRate,
    enableRowActions: false,
    displayExamples: data.displayExamples,
    setSelectedCategories: setSelectedCategories,
    tableState: tableState,
    actions: actions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 415,
      columnNumber: 13
    }
  })) : null));
};
exports.LogCategorizationFlyout = LogCategorizationFlyout;