"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiDataGridHeaderCellStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../../global_styling");
var _data_grid_cell = require("../cell/data_grid_cell.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Styles only applied to data header cell content, not control header cells
 */
var euiDataGridHeaderCellStyles = exports.euiDataGridHeaderCellStyles = function euiDataGridHeaderCellStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiDataGridCellOutli = (0, _data_grid_cell.euiDataGridCellOutlineSelectors)('.euiDataGridHeaderCell'),
    header = _euiDataGridCellOutli.header;
  var hideAnimation = function hideAnimation(margin, translateX) {
    return "\n    ".concat(header.hideActions, " & {\n      ").concat((0, _global_styling.logicalCSS)('margin-left', margin), "\n      transform: translateX(").concat(translateX, ") scale(0.01);\n      opacity: 0;\n    }\n  ");
  };
  return {
    euiDataGridHeaderCell__content: /*#__PURE__*/(0, _react.css)("flex-grow:1;", (0, _global_styling.euiTextTruncate)(), ";;label:euiDataGridHeaderCell__content;"),
    // Numeric and currency schemas are aligned to the right
    right: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalTextAlignCSS)('right'), ";;label:right;"),
    euiDataGridHeaderCell__popover: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-left', 'auto'), "line-height:0;;label:euiDataGridHeaderCell__popover;"),
    euiDataGridHeaderCell__actions: {
      action: /*#__PURE__*/(0, _react.css)("overflow:hidden;display:flex;max-inline-size:24px;", _global_styling.euiCanAnimate, "{transition:transform ", euiTheme.animation.fast, " ease-in,opacity ", euiTheme.animation.slow, " ease-in,margin-left ", euiTheme.animation.fast, " ease-in;animation:none!important;};label:action;"),
      start: /*#__PURE__*/(0, _react.css)(hideAnimation("-".concat(euiTheme.size.m), '0%'), ";;label:start;"),
      end: /*#__PURE__*/(0, _react.css)(hideAnimation("-".concat(euiTheme.size.l), '50%'), ";;label:end;")
    }
  };
};