"use strict";
/*
 * ELASTICSEARCH CONFIDENTIAL
 * __________________
 *
 *  Copyright Elasticsearch B.V. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Elasticsearch B.V. and its suppliers, if any.
 * The intellectual and technical concepts contained herein
 * are proprietary to Elasticsearch B.V. and its suppliers and
 * may be covered by U.S. and Foreign Patents, patents in
 * process, and are protected by trade secret or copyright
 * law.  Dissemination of this information or reproduction of
 * this material is strictly forbidden unless prior written
 * permission is obtained from Elasticsearch B.V.
 */
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TileService = exports.TileServiceStatus = void 0;
var mbtiles_1 = __importDefault(require("@mapbox/mbtiles"));
var TileServiceStatus;
(function (TileServiceStatus) {
    TileServiceStatus["OK"] = "OK";
    TileServiceStatus["INVALID"] = "INVALID";
    TileServiceStatus["NOT_FOUND"] = "NOT_FOUND";
    TileServiceStatus["CHECKING"] = "CHECKING";
})(TileServiceStatus || (exports.TileServiceStatus = TileServiceStatus = {}));
var TileService = /** @class */ (function () {
    function TileService(dbPath, logger) {
        this.dbPath = dbPath;
        this.logger = logger;
        this.tileDbConnection = undefined;
        this.isValid = TileServiceStatus.CHECKING;
        this.error = undefined;
        this.metadata = undefined;
    }
    TileService.prototype.init = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _a, error_1;
            var _this = this;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        if (this.tileDbConnection)
                            throw new Error('Tile service already initialized.');
                        _b.label = 1;
                    case 1:
                        _b.trys.push([1, 3, , 4]);
                        _a = this;
                        return [4 /*yield*/, new Promise(function (resolve, reject) {
                                new mbtiles_1.default(_this.dbPath + '?mode=ro', function (error, mbtiles) {
                                    if (error)
                                        reject(error);
                                    else
                                        resolve(mbtiles);
                                });
                            })];
                    case 2:
                        _a.tileDbConnection = _b.sent();
                        return [3 /*break*/, 4];
                    case 3:
                        error_1 = _b.sent();
                        this.isValid = TileServiceStatus.NOT_FOUND;
                        this.error = new Error("Unable to connect to the tile service database at ".concat(this.dbPath, "."));
                        this.logger.error({
                            message: error_1.message,
                        });
                        return [3 /*break*/, 4];
                    case 4: return [4 /*yield*/, this.check()];
                    case 5:
                        _b.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    TileService.prototype.check = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _a, error_2;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        if (!this.tileDbConnection) return [3 /*break*/, 4];
                        this.isValid = TileServiceStatus.CHECKING;
                        _b.label = 1;
                    case 1:
                        _b.trys.push([1, 3, , 4]);
                        _a = this;
                        return [4 /*yield*/, this._getMBTilesMetadata()];
                    case 2:
                        _a.metadata = _b.sent();
                        this.isValid = TileServiceStatus.OK;
                        delete this.error;
                        this.logger.debug({
                            message: "Connected to tile service database at ".concat(this.dbPath, "."),
                        });
                        return [3 /*break*/, 4];
                    case 3:
                        error_2 = _b.sent();
                        this.isValid = TileServiceStatus.INVALID;
                        this.error = new Error("The tile service database at ".concat(this.dbPath, " is invalid."));
                        this.logger.error({
                            message: this.error.message,
                        });
                        return [3 /*break*/, 4];
                    case 4: return [2 /*return*/];
                }
            });
        });
    };
    TileService.prototype.close = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                if (this.tileDbConnection) {
                    this.tileDbConnection.close(function (error) {
                        if (error)
                            _this.logger.error({ message: error.message });
                        else
                            _this.logger.debug("Closed connection to tile service database at ".concat(_this.dbPath, "."));
                    });
                }
                return [2 /*return*/];
            });
        });
    };
    TileService.prototype.getTile = function (z, x, y) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2 /*return*/, new Promise(function (resolve, reject) {
                        var _a;
                        (_a = _this.tileDbConnection) === null || _a === void 0 ? void 0 : _a.getTile(z, x, y, function (error, data, headers) {
                            if (error)
                                reject(error);
                            else
                                resolve({ data: data, headers: headers });
                        });
                    })];
            });
        });
    };
    TileService.prototype.healthCheck = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _a, z, x, y;
            return __generator(this, function (_b) {
                _a = __read(TileService.HEALTHCHECK_TILE, 3), z = _a[0], x = _a[1], y = _a[2];
                return [2 /*return*/, this.getTile(z, x, y)];
            });
        });
    };
    TileService.prototype._getMBTilesMetadata = function () {
        var _this = this;
        return new Promise(function (resolve, reject) {
            var _a;
            (_a = _this.tileDbConnection) === null || _a === void 0 ? void 0 : _a.getInfo(function (error, info) {
                var e_1, _a;
                if (error)
                    reject(error);
                else if (typeof info === 'object' && 'vector_layers' in info) {
                    // Align vector layers zoom with the tileset value
                    var maxzoom = info['maxzoom'];
                    try {
                        for (var _b = __values(info['vector_layers']), _c = _b.next(); !_c.done; _c = _b.next()) {
                            var layer = _c.value;
                            layer['maxzoom'] =
                                layer['maxzoom'] > maxzoom ? maxzoom : layer['maxzoom'];
                        }
                    }
                    catch (e_1_1) { e_1 = { error: e_1_1 }; }
                    finally {
                        try {
                            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                        }
                        finally { if (e_1) throw e_1.error; }
                    }
                    resolve(__assign(__assign({}, info), TileService.MBTILES_METADATA));
                }
                else
                    reject({
                        message: 'Error retrieving mbtiles metadata',
                    });
            });
        });
    };
    TileService.MBTILES_METADATA = {
        name: 'Elastic Maps Server',
        description: 'Elastic Maps Server vector tiles basemaps',
        attribution: '© <a rel="noreferrer noopener" href="https://www.openstreetmap.org/copyright">OpenStreetMap contributors</a> | <a rel="noreferrer noopener" href="https://openmaptiles.org">OpenMapTiles</a> | <a rel="noreferrer noopener" href="https://www.elastic.co/elastic-maps-service">Elastic Maps Service</a>',
        tilejson: '2.0.0',
        tiles: ['./data/v3/{z}/{x}/{y}.pbf'],
    };
    TileService.HEALTHCHECK_TILE = [4, 9, 10];
    return TileService;
}());
exports.TileService = TileService;
//# sourceMappingURL=tileservice.js.map