/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.ThreadContext;

public final class ResponseHeadersCollector {
    private final ThreadContext threadContext;
    private final Queue<Map<String, List<String>>> collected = ConcurrentCollections.newQueue();

    public ResponseHeadersCollector(ThreadContext threadContext) {
        this.threadContext = threadContext;
    }

    public void collect() {
        Map responseHeaders = this.threadContext.getResponseHeaders();
        if (!responseHeaders.isEmpty()) {
            this.collected.add(responseHeaders);
        }
    }

    public void finish() {
        Map<String, List<String>> resp;
        HashMap<String, Set> merged = new HashMap<String, Set>();
        while ((resp = this.collected.poll()) != null) {
            for (Map.Entry<String, List<String>> entry : resp.entrySet()) {
                merged.computeIfAbsent(entry.getKey(), k -> new LinkedHashSet(((List)e.getValue()).size())).addAll((Collection)entry.getValue());
            }
        }
        for (Map.Entry<String, List<String>> entry : merged.entrySet()) {
            for (String v : (Set)((Object)entry.getValue())) {
                this.threadContext.addResponseHeader(entry.getKey(), v);
            }
        }
    }
}

