/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.time.Duration;
import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.WindowGroupingAggregatorFunction;
import org.elasticsearch.compute.operator.DriverContext;

public record WindowAggregatorFunctionSupplier(AggregatorFunctionSupplier supplier, Duration window) implements AggregatorFunctionSupplier
{
    @Override
    public List<IntermediateStateDesc> nonGroupingIntermediateStateDesc() {
        return this.supplier.nonGroupingIntermediateStateDesc();
    }

    @Override
    public List<IntermediateStateDesc> groupingIntermediateStateDesc() {
        return this.supplier.groupingIntermediateStateDesc();
    }

    @Override
    public AggregatorFunction aggregator(DriverContext driverContext, List<Integer> channels) {
        return this.supplier.aggregator(driverContext, channels);
    }

    @Override
    public GroupingAggregatorFunction groupingAggregator(DriverContext driverContext, List<Integer> channels) {
        GroupingAggregatorFunction fn = this.supplier.groupingAggregator(driverContext, channels);
        return new WindowGroupingAggregatorFunction(fn, this.supplier, this.window);
    }

    @Override
    public String describe() {
        return "Window[agg=" + this.supplier.describe() + ", window=" + String.valueOf(this.window) + "]";
    }
}

