/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.NodeUtils;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.EsField;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.LeafPlan;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;

public class EsRelation
extends LeafPlan {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(LogicalPlan.class, "EsRelation", EsRelation::readFrom);
    private final String indexPattern;
    private final IndexMode indexMode;
    private final Map<String, IndexMode> indexNameWithModes;
    private final List<Attribute> attrs;

    public EsRelation(Source source, String indexPattern, IndexMode indexMode, Map<String, IndexMode> indexNameWithModes, List<Attribute> attributes) {
        super(source);
        this.indexPattern = indexPattern;
        this.indexMode = indexMode;
        this.indexNameWithModes = indexNameWithModes;
        this.attrs = attributes;
    }

    private static EsRelation readFrom(StreamInput in) throws IOException {
        Source source = Source.readFrom((StreamInput)((PlanStreamInput)in));
        String indexPattern = in.readString();
        if (!in.getTransportVersion().supports(TransportVersions.V_8_18_0)) {
            in.readImmutableMap(StreamInput::readString, EsField::readFrom);
        }
        Map indexNameWithModes = in.readMap(IndexMode::readFrom);
        List attributes = in.readNamedWriteableCollectionAsList(Attribute.class);
        IndexMode indexMode = IndexMode.fromString((String)in.readString());
        if (!in.getTransportVersion().supports(TransportVersions.V_8_18_0)) {
            in.readBoolean();
        }
        return new EsRelation(source, indexPattern, indexMode, indexNameWithModes, attributes);
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeString(this.indexPattern);
        if (!out.getTransportVersion().supports(TransportVersions.V_8_18_0)) {
            out.writeMap(Map.of(), (o, x) -> x.writeTo(out));
        }
        out.writeMap(this.indexNameWithModes, (o, v) -> IndexMode.writeTo((IndexMode)v, (StreamOutput)out));
        out.writeNamedWriteableCollection(this.attrs);
        out.writeString(this.indexMode.getName());
        if (!out.getTransportVersion().supports(TransportVersions.V_8_18_0)) {
            out.writeBoolean(false);
        }
    }

    public String getWriteableName() {
        return EsRelation.ENTRY.name;
    }

    protected NodeInfo<EsRelation> info() {
        return NodeInfo.create((Node)this, EsRelation::new, (Object)this.indexPattern, (Object)this.indexMode, this.indexNameWithModes, this.attrs);
    }

    public String indexPattern() {
        return this.indexPattern;
    }

    public IndexMode indexMode() {
        return this.indexMode;
    }

    public Map<String, IndexMode> indexNameWithModes() {
        return this.indexNameWithModes;
    }

    @Override
    public List<Attribute> output() {
        return this.attrs;
    }

    public Set<String> concreteIndices() {
        return this.indexNameWithModes.keySet();
    }

    @Override
    public boolean expressionsResolved() {
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.indexPattern, this.indexMode, this.indexNameWithModes, this.attrs);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        EsRelation other = (EsRelation)((Object)obj);
        return Objects.equals(this.indexPattern, other.indexPattern) && Objects.equals(this.indexMode, other.indexMode) && Objects.equals(this.indexNameWithModes, other.indexNameWithModes) && Objects.equals(this.attrs, other.attrs);
    }

    public String nodeString() {
        return this.nodeName() + "[" + this.indexPattern + "]" + (String)(this.indexMode != IndexMode.STANDARD ? "[" + this.indexMode.name() + "]" : "") + NodeUtils.limitedToString(this.attrs);
    }

    public EsRelation withAttributes(List<Attribute> newAttributes) {
        return new EsRelation(this.source(), this.indexPattern, this.indexMode, this.indexNameWithModes, newAttributes);
    }

    public EsRelation withIndexMode(IndexMode indexMode) {
        return new EsRelation(this.source(), this.indexPattern, indexMode, this.indexNameWithModes, this.attrs);
    }
}

