/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.physical.local;

import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.bucket.sampler.random.RandomSamplingQueryBuilder;
import org.elasticsearch.xpack.esql.expression.Foldables;
import org.elasticsearch.xpack.esql.optimizer.LocalPhysicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.PhysicalOptimizerRules;
import org.elasticsearch.xpack.esql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.SampleExec;
import org.elasticsearch.xpack.esql.planner.mapper.MapperUtils;

public class PushSampleToSource
extends PhysicalOptimizerRules.ParameterizedOptimizerRule<SampleExec, LocalPhysicalOptimizerContext> {
    @Override
    protected PhysicalPlan rule(SampleExec sample, LocalPhysicalOptimizerContext ctx) {
        PhysicalPlan plan = sample;
        PhysicalPlan physicalPlan = sample.child();
        if (physicalPlan instanceof EsQueryExec) {
            EsQueryExec queryExec = (EsQueryExec)physicalPlan;
            BoolQueryBuilder fullQuery = QueryBuilders.boolQuery();
            if (queryExec.query() != null) {
                if (MapperUtils.hasScoreAttribute(queryExec.output())) {
                    fullQuery.must(queryExec.query());
                } else {
                    fullQuery.filter(queryExec.query());
                }
            }
            RandomSamplingQueryBuilder sampleQuery = new RandomSamplingQueryBuilder(((Double)Foldables.valueOf(ctx.foldCtx(), sample.probability())).doubleValue());
            fullQuery.filter((QueryBuilder)sampleQuery);
            plan = queryExec.withQuery((QueryBuilder)fullQuery);
        }
        return plan;
    }
}

