/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.inference;

import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.AsyncOperator;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xpack.core.inference.action.InferenceAction;
import org.elasticsearch.xpack.esql.inference.bulk.BulkInferenceRequestIterator;
import org.elasticsearch.xpack.esql.inference.bulk.BulkInferenceRunner;

public abstract class InferenceOperator
extends AsyncOperator<OngoingInferenceResult> {
    private final String inferenceId;
    private final BlockFactory blockFactory;
    private final BulkInferenceRunner bulkInferenceRunner;

    public InferenceOperator(DriverContext driverContext, BulkInferenceRunner bulkInferenceRunner, String inferenceId, int maxOutstandingPages) {
        super(driverContext, bulkInferenceRunner.threadPool().getThreadContext(), maxOutstandingPages);
        this.blockFactory = driverContext.blockFactory();
        this.bulkInferenceRunner = bulkInferenceRunner;
        this.inferenceId = inferenceId;
    }

    protected BlockFactory blockFactory() {
        return this.blockFactory;
    }

    protected String inferenceId() {
        return this.inferenceId;
    }

    protected void performAsync(Page input, ActionListener<OngoingInferenceResult> listener) {
        try {
            BulkInferenceRequestIterator requests = this.requests(input);
            listener = ActionListener.releaseBefore((Releasable)requests, listener);
            this.bulkInferenceRunner.executeBulk(requests, (ActionListener<List<InferenceAction.Response>>)listener.map(responses -> new OngoingInferenceResult(input, (List<InferenceAction.Response>)responses)));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    protected void releaseFetchedOnAnyThread(OngoingInferenceResult ongoingInferenceResult) {
        Releasables.close((Releasable)ongoingInferenceResult);
    }

    public Page getOutput() {
        Page page;
        block10: {
            OngoingInferenceResult ongoingInferenceResult = (OngoingInferenceResult)this.fetchFromBuffer();
            if (ongoingInferenceResult == null) {
                return null;
            }
            OutputBuilder outputBuilder = this.outputBuilder(ongoingInferenceResult.inputPage);
            try {
                for (InferenceAction.Response response : ongoingInferenceResult.responses) {
                    outputBuilder.addInferenceResponse(response);
                }
                page = outputBuilder.buildOutput();
                if (outputBuilder == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (outputBuilder != null) {
                        try {
                            outputBuilder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.releaseFetchedOnAnyThread(ongoingInferenceResult);
                    throw e;
                }
            }
            outputBuilder.close();
        }
        return page;
    }

    protected abstract BulkInferenceRequestIterator requests(Page var1);

    protected abstract OutputBuilder outputBuilder(Page var1);

    public record OngoingInferenceResult(Page inputPage, List<InferenceAction.Response> responses) implements Releasable
    {
        public void close() {
            InferenceOperator.releasePageOnAnyThread((Page)this.inputPage);
        }
    }

    public static interface OutputBuilder
    extends Releasable {
        public void addInferenceResponse(InferenceAction.Response var1);

        public Page buildOutput();

        public static <IR extends InferenceServiceResults> IR inferenceResults(InferenceAction.Response inferenceResponse, Class<IR> clazz) {
            InferenceServiceResults results = inferenceResponse.getResults();
            if (clazz.isInstance(results)) {
                return (IR)((InferenceServiceResults)clazz.cast(results));
            }
            throw new IllegalStateException(LoggerMessageFormat.format((String)"Inference result has wrong type. Got [{}] while expecting [{}]", (String)results.getClass().getName(), (Object[])new Object[]{clazz.getName()}));
        }

        default public void releasePageOnAnyThread(Page page) {
            InferenceOperator.releasePageOnAnyThread((Page)page);
        }
    }
}

