/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.index;

import java.util.Map;
import java.util.Set;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.xpack.esql.core.type.EsField;

public record EsIndex(String name, Map<String, EsField> mapping, Map<String, IndexMode> indexNameWithModes, Set<String> partiallyUnmappedFields) {
    public EsIndex {
        assert (name != null);
        assert (mapping != null);
        assert (partiallyUnmappedFields != null);
    }

    public EsIndex(String name, Map<String, EsField> mapping, Map<String, IndexMode> indexNameWithModes) {
        this(name, mapping, indexNameWithModes, Set.of());
    }

    public EsIndex(String name, Map<String, EsField> mapping) {
        this(name, mapping, Map.of(), Set.of());
    }

    public boolean isPartiallyUnmappedField(String fieldName) {
        return this.partiallyUnmappedFields.contains(fieldName);
    }

    public Set<String> concreteIndices() {
        return this.indexNameWithModes.keySet();
    }

    @Override
    public String toString() {
        return this.name;
    }
}

