/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateDiff;

public final class DateDiffConstantNanosMillisEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(DateDiffConstantNanosMillisEvaluator.class);
    private final Source source;
    private final DateDiff.Part datePartFieldUnit;
    private final EvalOperator.ExpressionEvaluator startTimestampNanos;
    private final EvalOperator.ExpressionEvaluator endTimestampMillis;
    private final DriverContext driverContext;
    private Warnings warnings;

    public DateDiffConstantNanosMillisEvaluator(Source source, DateDiff.Part datePartFieldUnit, EvalOperator.ExpressionEvaluator startTimestampNanos, EvalOperator.ExpressionEvaluator endTimestampMillis, DriverContext driverContext) {
        this.source = source;
        this.datePartFieldUnit = datePartFieldUnit;
        this.startTimestampNanos = startTimestampNanos;
        this.endTimestampMillis = endTimestampMillis;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (LongBlock startTimestampNanosBlock = (LongBlock)this.startTimestampNanos.eval(page);){
            IntBlock intBlock;
            block20: {
                LongVector endTimestampMillisVector;
                LongVector startTimestampNanosVector;
                LongBlock endTimestampMillisBlock;
                block18: {
                    IntBlock intBlock2;
                    block19: {
                        block16: {
                            IntBlock intBlock3;
                            block17: {
                                endTimestampMillisBlock = (LongBlock)this.endTimestampMillis.eval(page);
                                try {
                                    startTimestampNanosVector = startTimestampNanosBlock.asVector();
                                    if (startTimestampNanosVector != null) break block16;
                                    intBlock3 = this.eval(page.getPositionCount(), startTimestampNanosBlock, endTimestampMillisBlock);
                                    if (endTimestampMillisBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (endTimestampMillisBlock != null) {
                                        try {
                                            endTimestampMillisBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                endTimestampMillisBlock.close();
                            }
                            return intBlock3;
                        }
                        endTimestampMillisVector = endTimestampMillisBlock.asVector();
                        if (endTimestampMillisVector != null) break block18;
                        intBlock2 = this.eval(page.getPositionCount(), startTimestampNanosBlock, endTimestampMillisBlock);
                        if (endTimestampMillisBlock == null) break block19;
                        endTimestampMillisBlock.close();
                    }
                    return intBlock2;
                }
                intBlock = this.eval(page.getPositionCount(), startTimestampNanosVector, endTimestampMillisVector);
                if (endTimestampMillisBlock == null) break block20;
                endTimestampMillisBlock.close();
            }
            return intBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.startTimestampNanos.baseRamBytesUsed();
        return baseRamBytesUsed += this.endTimestampMillis.baseRamBytesUsed();
    }

    public IntBlock eval(int positionCount, LongBlock startTimestampNanosBlock, LongBlock endTimestampMillisBlock) {
        try (IntBlock.Builder result = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            block15: for (int p = 0; p < positionCount; ++p) {
                switch (startTimestampNanosBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block15;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block15;
                    }
                }
                switch (endTimestampMillisBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block15;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block15;
                    }
                }
                long startTimestampNanos = startTimestampNanosBlock.getLong(startTimestampNanosBlock.getFirstValueIndex(p));
                long endTimestampMillis = endTimestampMillisBlock.getLong(endTimestampMillisBlock.getFirstValueIndex(p));
                try {
                    result.appendInt(DateDiff.processNanosMillis(this.datePartFieldUnit, startTimestampNanos, endTimestampMillis));
                    continue;
                }
                catch (IllegalArgumentException | InvalidArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            IntBlock intBlock = result.build();
            return intBlock;
        }
    }

    public IntBlock eval(int positionCount, LongVector startTimestampNanosVector, LongVector endTimestampMillisVector) {
        try (IntBlock.Builder result = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                long startTimestampNanos = startTimestampNanosVector.getLong(p);
                long endTimestampMillis = endTimestampMillisVector.getLong(p);
                try {
                    result.appendInt(DateDiff.processNanosMillis(this.datePartFieldUnit, startTimestampNanos, endTimestampMillis));
                    continue;
                }
                catch (IllegalArgumentException | InvalidArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            IntBlock intBlock = result.build();
            return intBlock;
        }
    }

    public String toString() {
        return "DateDiffConstantNanosMillisEvaluator[datePartFieldUnit=" + String.valueOf(this.datePartFieldUnit) + ", startTimestampNanos=" + String.valueOf(this.startTimestampNanos) + ", endTimestampMillis=" + String.valueOf(this.endTimestampMillis) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.startTimestampNanos, this.endTimestampMillis});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final DateDiff.Part datePartFieldUnit;
        private final EvalOperator.ExpressionEvaluator.Factory startTimestampNanos;
        private final EvalOperator.ExpressionEvaluator.Factory endTimestampMillis;

        public Factory(Source source, DateDiff.Part datePartFieldUnit, EvalOperator.ExpressionEvaluator.Factory startTimestampNanos, EvalOperator.ExpressionEvaluator.Factory endTimestampMillis) {
            this.source = source;
            this.datePartFieldUnit = datePartFieldUnit;
            this.startTimestampNanos = startTimestampNanos;
            this.endTimestampMillis = endTimestampMillis;
        }

        public DateDiffConstantNanosMillisEvaluator get(DriverContext context) {
            return new DateDiffConstantNanosMillisEvaluator(this.source, this.datePartFieldUnit, this.startTimestampNanos.get(context), this.endTimestampMillis.get(context), context);
        }

        public String toString() {
            return "DateDiffConstantNanosMillisEvaluator[datePartFieldUnit=" + String.valueOf(this.datePartFieldUnit) + ", startTimestampNanos=" + String.valueOf(this.startTimestampNanos) + ", endTimestampMillis=" + String.valueOf(this.endTimestampMillis) + "]";
        }
    }
}

