/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.conditional;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.ClampMax;

public final class ClampMaxDoubleEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ClampMaxDoubleEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator field;
    private final EvalOperator.ExpressionEvaluator max;
    private final DriverContext driverContext;
    private Warnings warnings;

    public ClampMaxDoubleEvaluator(Source source, EvalOperator.ExpressionEvaluator field, EvalOperator.ExpressionEvaluator max, DriverContext driverContext) {
        this.source = source;
        this.field = field;
        this.max = max;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (DoubleBlock fieldBlock = (DoubleBlock)this.field.eval(page);){
            DoubleBlock doubleBlock;
            block20: {
                DoubleVector maxVector;
                DoubleVector fieldVector;
                DoubleBlock maxBlock;
                block18: {
                    DoubleBlock doubleBlock2;
                    block19: {
                        block16: {
                            DoubleBlock doubleBlock3;
                            block17: {
                                maxBlock = (DoubleBlock)this.max.eval(page);
                                try {
                                    fieldVector = fieldBlock.asVector();
                                    if (fieldVector != null) break block16;
                                    doubleBlock3 = this.eval(page.getPositionCount(), fieldBlock, maxBlock);
                                    if (maxBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (maxBlock != null) {
                                        try {
                                            maxBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                maxBlock.close();
                            }
                            return doubleBlock3;
                        }
                        maxVector = maxBlock.asVector();
                        if (maxVector != null) break block18;
                        doubleBlock2 = this.eval(page.getPositionCount(), fieldBlock, maxBlock);
                        if (maxBlock == null) break block19;
                        maxBlock.close();
                    }
                    return doubleBlock2;
                }
                doubleBlock = this.eval(page.getPositionCount(), fieldVector, maxVector).asBlock();
                if (maxBlock == null) break block20;
                maxBlock.close();
            }
            return doubleBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.field.baseRamBytesUsed();
        return baseRamBytesUsed += this.max.baseRamBytesUsed();
    }

    public DoubleBlock eval(int positionCount, DoubleBlock fieldBlock, DoubleBlock maxBlock) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            block13: for (int p = 0; p < positionCount; ++p) {
                switch (fieldBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block13;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block13;
                    }
                }
                switch (maxBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block13;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block13;
                    }
                }
                double field = fieldBlock.getDouble(fieldBlock.getFirstValueIndex(p));
                double max = maxBlock.getDouble(maxBlock.getFirstValueIndex(p));
                result.appendDouble(ClampMax.process(field, max));
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public DoubleVector eval(int positionCount, DoubleVector fieldVector, DoubleVector maxVector) {
        try (DoubleVector.FixedBuilder result = this.driverContext.blockFactory().newDoubleVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                double field = fieldVector.getDouble(p);
                double max = maxVector.getDouble(p);
                result.appendDouble(p, ClampMax.process(field, max));
            }
            DoubleVector doubleVector = result.build();
            return doubleVector;
        }
    }

    public String toString() {
        return "ClampMaxDoubleEvaluator[field=" + String.valueOf(this.field) + ", max=" + String.valueOf(this.max) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.field, this.max});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory field;
        private final EvalOperator.ExpressionEvaluator.Factory max;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory field, EvalOperator.ExpressionEvaluator.Factory max) {
            this.source = source;
            this.field = field;
            this.max = max;
        }

        public ClampMaxDoubleEvaluator get(DriverContext context) {
            return new ClampMaxDoubleEvaluator(this.source, this.field.get(context), this.max.get(context), context);
        }

        public String toString() {
            return "ClampMaxDoubleEvaluator[field=" + String.valueOf(this.field) + ", max=" + String.valueOf(this.max) + "]";
        }
    }
}

