/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.action;

import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.async.AsyncExecutionId;
import org.elasticsearch.xpack.esql.action.EsqlGetQueryAction;
import org.elasticsearch.xpack.esql.action.EsqlGetQueryRequest;
import org.elasticsearch.xpack.esql.action.EsqlListQueriesAction;
import org.elasticsearch.xpack.esql.action.EsqlListQueriesRequest;

@ServerlessScope(value=Scope.PUBLIC)
public class RestEsqlListQueriesAction
extends BaseRestHandler {
    private static final Logger LOGGER = LogManager.getLogger(RestEsqlListQueriesAction.class);

    public String getName() {
        return "esql_list_queries";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_query/queries/{id}"), new RestHandler.Route(RestRequest.Method.GET, "/_query/queries"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        return RestEsqlListQueriesAction.restChannelConsumer(request, client);
    }

    private static BaseRestHandler.RestChannelConsumer restChannelConsumer(RestRequest request, NodeClient client) {
        LOGGER.debug("Beginning execution of ESQL list queries.");
        String id = request.param("id");
        ActionType action = id != null ? EsqlGetQueryAction.INSTANCE : EsqlListQueriesAction.INSTANCE;
        Object actionRequest = id != null ? new EsqlGetQueryRequest(AsyncExecutionId.decode((String)id)) : new EsqlListQueriesRequest();
        return arg_0 -> RestEsqlListQueriesAction.lambda$restChannelConsumer$0(client, action, (ActionRequest)actionRequest, arg_0);
    }

    private static /* synthetic */ void lambda$restChannelConsumer$0(NodeClient client, ActionType action, ActionRequest actionRequest, RestChannel channel) throws Exception {
        client.execute(action, actionRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

