/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.StartDatafeedAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class StopDatafeedAction
extends ActionType<Response> {
    public static final StopDatafeedAction INSTANCE = new StopDatafeedAction();
    public static final String NAME = "cluster:admin/xpack/ml/datafeed/stop";
    public static final TimeValue DEFAULT_TIMEOUT = TimeValue.timeValueMinutes((long)5L);

    private StopDatafeedAction() {
        super(NAME);
    }

    public static class Response
    extends BaseTasksResponse
    implements Writeable {
        private final boolean stopped;

        public Response(boolean stopped) {
            super(null, null);
            this.stopped = stopped;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.stopped = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.stopped);
        }

        public boolean isStopped() {
            return this.stopped;
        }
    }

    public static class Request
    extends BaseTasksRequest<Request>
    implements ToXContentObject {
        public static final ParseField TIMEOUT = new ParseField("timeout", new String[0]);
        public static final ParseField FORCE = new ParseField("force", new String[0]);
        public static final ParseField ALLOW_NO_MATCH = new ParseField("allow_no_match", new String[0]);
        public static final ObjectParser<Request, Void> PARSER = new ObjectParser("cluster:admin/xpack/ml/datafeed/stop", Request::new);
        private String datafeedId;
        private String[] resolvedStartedDatafeedIds = new String[0];
        private TimeValue stopTimeout = DEFAULT_TIMEOUT;
        private boolean force = false;
        private boolean allowNoMatch = true;

        public static Request parseRequest(String datafeedId, XContentParser parser) {
            Request request = (Request)((Object)PARSER.apply(parser, null));
            if (datafeedId != null) {
                request.datafeedId = datafeedId;
            }
            return request;
        }

        public Request(String datafeedId) {
            this.datafeedId = ExceptionsHelper.requireNonNull(datafeedId, DatafeedConfig.ID.getPreferredName());
        }

        public Request() {
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.datafeedId = in.readString();
            this.resolvedStartedDatafeedIds = in.readStringArray();
            this.stopTimeout = in.readTimeValue();
            this.force = in.readBoolean();
            this.allowNoMatch = in.readBoolean();
        }

        public String getDatafeedId() {
            return this.datafeedId;
        }

        public String[] getResolvedStartedDatafeedIds() {
            return this.resolvedStartedDatafeedIds;
        }

        public void setResolvedStartedDatafeedIds(String[] resolvedStartedDatafeedIds) {
            assert (resolvedStartedDatafeedIds != null);
            this.resolvedStartedDatafeedIds = resolvedStartedDatafeedIds;
        }

        public TimeValue getStopTimeout() {
            return this.stopTimeout;
        }

        public Request setStopTimeout(TimeValue stopTimeout) {
            this.stopTimeout = ExceptionsHelper.requireNonNull(stopTimeout, TIMEOUT.getPreferredName());
            return this;
        }

        public boolean isForce() {
            return this.force;
        }

        public Request setForce(boolean force) {
            this.force = force;
            return this;
        }

        public boolean allowNoMatch() {
            return this.allowNoMatch;
        }

        public Request setAllowNoMatch(boolean allowNoMatch) {
            this.allowNoMatch = allowNoMatch;
            return this;
        }

        public boolean match(Task task) {
            for (String id : this.resolvedStartedDatafeedIds) {
                String expectedDescription = MlTasks.datafeedTaskId(id);
                if (!(task instanceof StartDatafeedAction.DatafeedTaskMatcher) || !expectedDescription.equals(task.getDescription())) continue;
                return true;
            }
            return false;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.datafeedId);
            out.writeStringArray(this.resolvedStartedDatafeedIds);
            out.writeTimeValue(this.stopTimeout);
            out.writeBoolean(this.force);
            out.writeBoolean(this.allowNoMatch);
        }

        public int hashCode() {
            return Objects.hash(this.datafeedId, this.stopTimeout, this.force, this.allowNoMatch);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(DatafeedConfig.ID.getPreferredName(), this.datafeedId);
            builder.field(TIMEOUT.getPreferredName(), this.stopTimeout.getStringRep());
            builder.field(FORCE.getPreferredName(), this.force);
            builder.field(ALLOW_NO_MATCH.getPreferredName(), this.allowNoMatch);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.datafeedId, other.datafeedId) && Objects.equals(this.stopTimeout, other.stopTimeout) && Objects.equals(this.force, other.force) && Objects.equals(this.allowNoMatch, other.allowNoMatch);
        }

        static {
            PARSER.declareString((request, datafeedId) -> {
                request.datafeedId = datafeedId;
            }, DatafeedConfig.ID);
            PARSER.declareString((request, val) -> request.setStopTimeout(TimeValue.parseTimeValue((String)val, (String)TIMEOUT.getPreferredName())), TIMEOUT);
            PARSER.declareBoolean(Request::setForce, FORCE);
            PARSER.declareBoolean(Request::setAllowNoMatch, ALLOW_NO_MATCH);
        }
    }
}

