/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.core.Strings;

public class InferenceUtils {
    private InferenceUtils() {
    }

    public static <T> T removeAsType(Map<String, Object> sourceMap, String key, Class<T> type, ValidationException validationException) {
        if (sourceMap == null) {
            validationException.addValidationError(Strings.format((String)"Encountered a null input map while parsing field [%s]", (Object[])new Object[]{key}));
            return null;
        }
        Object o = sourceMap.remove(key);
        if (o == null) {
            return null;
        }
        if (type.isAssignableFrom(o.getClass())) {
            return (T)o;
        }
        validationException.addValidationError(InferenceUtils.invalidTypeErrorMsg(key, o, type.getSimpleName()));
        return null;
    }

    public static String extractOptionalString(Map<String, Object> map, String settingName, String scope, ValidationException validationException) {
        int initialValidationErrorCount = validationException.validationErrors().size();
        String optionalField = InferenceUtils.removeAsType(map, settingName, String.class, validationException);
        if (validationException.validationErrors().size() > initialValidationErrorCount) {
            return null;
        }
        if (optionalField != null && optionalField.isEmpty()) {
            validationException.addValidationError(InferenceUtils.mustBeNonEmptyString(settingName, scope));
        }
        if (validationException.validationErrors().size() > initialValidationErrorCount) {
            return null;
        }
        return optionalField;
    }

    public static Integer extractRequiredPositiveInteger(Map<String, Object> map, String settingName, String scope, ValidationException validationException) {
        int initialValidationErrorCount = validationException.validationErrors().size();
        Integer field = InferenceUtils.removeAsType(map, settingName, Integer.class, validationException);
        if (validationException.validationErrors().size() > initialValidationErrorCount) {
            return null;
        }
        if (field == null) {
            validationException.addValidationError(InferenceUtils.missingSettingErrorMsg(settingName, scope));
        } else if (field <= 0) {
            validationException.addValidationError(InferenceUtils.mustBeAPositiveIntegerErrorMessage(settingName, scope, field));
        }
        if (validationException.validationErrors().size() > initialValidationErrorCount) {
            return null;
        }
        return field;
    }

    public static Integer extractRequiredPositiveIntegerGreaterThanOrEqualToMin(Map<String, Object> map, String settingName, int minValue, String scope, ValidationException validationException) {
        Integer field = InferenceUtils.extractRequiredPositiveInteger(map, settingName, scope, validationException);
        if (field != null && field < minValue) {
            validationException.addValidationError(InferenceUtils.mustBeGreaterThanOrEqualNumberErrorMessage(settingName, scope, field.intValue(), minValue));
            return null;
        }
        return field;
    }

    public static Integer extractRequiredPositiveIntegerLessThanOrEqualToMax(Map<String, Object> map, String settingName, int maxValue, String scope, ValidationException validationException) {
        Integer field = InferenceUtils.extractRequiredPositiveInteger(map, settingName, scope, validationException);
        if (field != null && field > maxValue) {
            validationException.addValidationError(InferenceUtils.mustBeLessThanOrEqualNumberErrorMessage(settingName, scope, field.intValue(), maxValue));
        }
        return field;
    }

    public static <T> List<T> extractOptionalList(Map<String, Object> map, String settingName, Class<T> type, ValidationException validationException) {
        int initialValidationErrorCount = validationException.validationErrors().size();
        List optionalField = InferenceUtils.removeAsType(map, settingName, List.class, validationException);
        if (validationException.validationErrors().size() > initialValidationErrorCount) {
            return null;
        }
        if (optionalField != null) {
            for (Object o : optionalField) {
                if (o.getClass().equals(type)) continue;
                validationException.addValidationError(InferenceUtils.invalidTypeErrorMsg(settingName, o, "String"));
            }
        }
        if (validationException.validationErrors().size() > initialValidationErrorCount) {
            return null;
        }
        return optionalField;
    }

    public static <E extends Enum<E>> E extractOptionalEnum(Map<String, Object> map, String settingName, String scope, EnumConstructor<E> constructor, EnumSet<E> validValues, ValidationException validationException) {
        String enumString = InferenceUtils.extractOptionalString(map, settingName, scope, validationException);
        if (enumString == null) {
            return null;
        }
        try {
            E createdEnum = constructor.apply(enumString);
            InferenceUtils.validateEnumValue(createdEnum, validValues);
            return createdEnum;
        }
        catch (IllegalArgumentException e) {
            String[] validValuesAsStrings = (String[])validValues.stream().map(value -> value.toString().toLowerCase(Locale.ROOT)).toArray(String[]::new);
            validationException.addValidationError(InferenceUtils.invalidValue(settingName, scope, enumString, validValuesAsStrings));
            return null;
        }
    }

    private static <E extends Enum<E>> void validateEnumValue(E enumValue, EnumSet<E> validValues) {
        if (!validValues.contains(enumValue)) {
            throw new IllegalArgumentException(Strings.format((String)"Enum value [%s] is not one of the acceptable values", (Object[])new Object[]{enumValue.toString()}));
        }
    }

    public static String mustBeNonEmptyString(String settingName, String scope) {
        return Strings.format((String)"[%s] Invalid value empty string. [%s] must be a non-empty string", (Object[])new Object[]{scope, settingName});
    }

    public static String invalidValue(String settingName, String scope, String invalidType, String[] requiredValues) {
        Object[] copyOfRequiredValues = (String[])requiredValues.clone();
        Arrays.sort(copyOfRequiredValues);
        return Strings.format((String)"[%s] Invalid value [%s] received. [%s] must be one of [%s]", (Object[])new Object[]{scope, invalidType, settingName, String.join((CharSequence)", ", (CharSequence[])copyOfRequiredValues)});
    }

    public static String invalidTypeErrorMsg(String settingName, Object foundObject, String expectedType) {
        return Strings.format((String)"field [%s] is not of the expected type. The value [%s] cannot be converted to a [%s]", (Object[])new Object[]{settingName, foundObject, expectedType});
    }

    public static String missingSettingErrorMsg(String settingName, String scope) {
        return Strings.format((String)"[%s] does not contain the required setting [%s]", (Object[])new Object[]{scope, settingName});
    }

    public static String mustBeGreaterThanOrEqualNumberErrorMessage(String settingName, String scope, double value, double minValue) {
        return Strings.format((String)"[%s] Invalid value [%s]. [%s] must be a greater than or equal to [%s]", (Object[])new Object[]{scope, value, settingName, minValue});
    }

    public static String mustBeLessThanOrEqualNumberErrorMessage(String settingName, String scope, double value, double maxValue) {
        return Strings.format((String)"[%s] Invalid value [%s]. [%s] must be a less than or equal to [%s]", (Object[])new Object[]{scope, value, settingName, maxValue});
    }

    public static String mustBeAPositiveIntegerErrorMessage(String settingName, String scope, int value) {
        return Strings.format((String)"[%s] Invalid value [%s]. [%s] must be a positive integer", (Object[])new Object[]{scope, value, settingName});
    }

    @FunctionalInterface
    public static interface EnumConstructor<E extends Enum<E>> {
        public E apply(String var1) throws IllegalArgumentException;
    }
}

