/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.TimeValue;

public class XContentMapValues {
    private static final int MAX_DETERMINIZED_STATES = 50000;

    public static List<Object> extractRawValues(String path, Map<String, Object> map) {
        ArrayList<Object> values = new ArrayList<Object>();
        String[] pathElements = path.split("\\.");
        if (pathElements.length == 0) {
            return values;
        }
        XContentMapValues.extractRawValues(values, map, pathElements, 0);
        return values;
    }

    private static void extractRawValues(List<Object> values, Map<String, Object> part, String[] pathElements, int index) {
        if (index == pathElements.length) {
            return;
        }
        Object key = pathElements[index];
        int nextIndex = index + 1;
        while (true) {
            Object currentValue;
            if ((currentValue = part.get(key)) != null) {
                if (currentValue instanceof Map) {
                    XContentMapValues.extractRawValues(values, (Map)currentValue, pathElements, nextIndex);
                } else if (currentValue instanceof List) {
                    XContentMapValues.extractRawValues(values, (List)currentValue, pathElements, nextIndex);
                } else if (nextIndex == pathElements.length) {
                    values.add(currentValue);
                }
            }
            if (nextIndex == pathElements.length) {
                return;
            }
            key = (String)key + "." + pathElements[nextIndex];
            ++nextIndex;
        }
    }

    private static void extractRawValues(List<Object> values, List<Object> part, String[] pathElements, int index) {
        for (Object value : part) {
            if (value == null) continue;
            if (value instanceof Map) {
                XContentMapValues.extractRawValues(values, (Map)value, pathElements, index);
                continue;
            }
            if (value instanceof List) {
                XContentMapValues.extractRawValues(values, (List)value, pathElements, index);
                continue;
            }
            if (index != pathElements.length) continue;
            values.add(value);
        }
    }

    public static Object extractValue(String path, Map<?, ?> map) {
        return XContentMapValues.extractValue(map, path.split("\\."));
    }

    public static Object extractValue(Map<?, ?> map, String ... pathElements) {
        if (pathElements.length == 0) {
            return null;
        }
        return XContentMapValues.extractValue(pathElements, 0, map, null);
    }

    public static List<Map<?, ?>> extractNestedSources(String nestedPath, Map<?, ?> map) {
        Object extractedValue = XContentMapValues.extractValue(nestedPath, map);
        List nestedParsedSource = null;
        if (extractedValue != null) {
            if (extractedValue instanceof List) {
                nestedParsedSource = (List)extractedValue;
            } else {
                if (extractedValue instanceof Map) {
                    return Collections.singletonList((Map)extractedValue);
                }
                throw new IllegalStateException("Cannot extract nested source from path [" + nestedPath + "]: got [" + String.valueOf(extractedValue) + "]");
            }
        }
        if (nestedParsedSource == null) {
            return null;
        }
        ArrayList flattenedSource = new ArrayList();
        XContentMapValues.extractObjects(nestedParsedSource, flattenedSource);
        return flattenedSource;
    }

    private static void extractObjects(List<?> source, List<Map<?, ?>> extracted) {
        for (Object object : source) {
            if (object instanceof Map) {
                extracted.add((Map)object);
                continue;
            }
            if (!(object instanceof List)) continue;
            XContentMapValues.extractObjects((List)object, extracted);
        }
    }

    public static Object extractValue(String path, Map<?, ?> map, Object nullValue) {
        String[] pathElements = path.split("\\.");
        if (pathElements.length == 0) {
            return null;
        }
        return XContentMapValues.extractValue(pathElements, 0, map, nullValue);
    }

    private static Object extractValue(String[] pathElements, int index, Object currentValue, Object nullValue) {
        if (currentValue instanceof List) {
            List valueList = (List)currentValue;
            ArrayList<Object> newList = new ArrayList<Object>(valueList.size());
            for (Object o : valueList) {
                Object listValue = XContentMapValues.extractValue(pathElements, index, o, nullValue);
                if (listValue == null) continue;
                if (listValue instanceof List) {
                    List list = (List)listValue;
                    if (index == pathElements.length) {
                        newList.add(list);
                        continue;
                    }
                    newList.addAll(list);
                    continue;
                }
                newList.add(listValue);
            }
            return newList;
        }
        if (index == pathElements.length) {
            return currentValue != null ? currentValue : nullValue;
        }
        if (currentValue instanceof Map) {
            Map map = (Map)currentValue;
            Object key = pathElements[index];
            int nextIndex = index + 1;
            ArrayList<Object> extractedValues = new ArrayList<Object>();
            while (true) {
                if (map.containsKey(key)) {
                    Object mapValue = map.get(key);
                    if (mapValue == null) {
                        extractedValues.add(nullValue);
                    } else {
                        Object val = XContentMapValues.extractValue(pathElements, nextIndex, mapValue, nullValue);
                        if (val != null) {
                            extractedValues.add(val);
                        }
                    }
                }
                if (nextIndex == pathElements.length) {
                    if (extractedValues.size() == 0) {
                        return null;
                    }
                    if (extractedValues.size() == 1) {
                        return extractedValues.get(0);
                    }
                    return extractedValues;
                }
                key = (String)key + "." + pathElements[nextIndex];
                ++nextIndex;
            }
        }
        return null;
    }

    public static Map<String, Object> filter(Map<String, Object> map, String[] includes, String[] excludes) {
        return XContentMapValues.filter(includes, excludes).apply(map);
    }

    public static Function<Map<String, Object>, Map<String, Object>> filter(String[] includes, String[] excludes) {
        CharacterRunAutomaton matchAllAutomaton = new CharacterRunAutomaton(Automata.makeAnyString());
        CharacterRunAutomaton include = XContentMapValues.compileAutomaton(includes, matchAllAutomaton);
        CharacterRunAutomaton exclude = XContentMapValues.compileAutomaton(excludes, new CharacterRunAutomaton(Automata.makeEmpty()));
        return map -> XContentMapValues.filter(map, include, 0, exclude, 0, matchAllAutomaton);
    }

    public static CharacterRunAutomaton compileAutomaton(String[] patterns, CharacterRunAutomaton defaultValue) {
        if (patterns == null || patterns.length == 0) {
            return defaultValue;
        }
        Automaton aut = Regex.simpleMatchToAutomaton(patterns);
        aut = Operations.determinize((Automaton)XContentMapValues.makeMatchDotsInFieldNames(aut), (int)50000);
        return new CharacterRunAutomaton(aut);
    }

    private static Automaton makeMatchDotsInFieldNames(Automaton automaton) {
        Automaton tail = Operations.union((Automaton)Automata.makeEmptyString(), (Automaton)Operations.concatenate((Automaton)Automata.makeChar((int)46), (Automaton)Automata.makeAnyString()));
        return Operations.concatenate((Automaton)automaton, (Automaton)tail);
    }

    private static int step(CharacterRunAutomaton automaton, String key, int state) {
        for (int i = 0; state != -1 && i < key.length(); ++i) {
            state = automaton.step(state, (int)key.charAt(i));
        }
        return state;
    }

    private static Map<String, Object> filter(Map<String, ?> map, CharacterRunAutomaton includeAutomaton, int initialIncludeState, CharacterRunAutomaton excludeAutomaton, int initialExcludeState, CharacterRunAutomaton matchAllAutomaton) {
        HashMap<String, Object> filtered = new HashMap<String, Object>();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            int excludeState;
            String key = entry.getKey();
            int includeState = XContentMapValues.step(includeAutomaton, key, initialIncludeState);
            if (includeState == -1 || (excludeState = XContentMapValues.step(excludeAutomaton, key, initialExcludeState)) != -1 && excludeAutomaton.isAccept(excludeState)) continue;
            Object value = entry.getValue();
            CharacterRunAutomaton subIncludeAutomaton = includeAutomaton;
            int subIncludeState = includeState;
            if (includeAutomaton.isAccept(includeState)) {
                if (excludeState == -1 || excludeAutomaton.step(excludeState, 46) == -1) {
                    filtered.put(key, value);
                    continue;
                }
                subIncludeAutomaton = matchAllAutomaton;
                subIncludeState = 0;
            }
            if (value instanceof Map) {
                if ((subIncludeState = subIncludeAutomaton.step(subIncludeState, 46)) == -1) continue;
                if (excludeState != -1) {
                    excludeState = excludeAutomaton.step(excludeState, 46);
                }
                Map valueAsMap = (Map)value;
                Map<String, Object> filteredValue = XContentMapValues.filter(valueAsMap, subIncludeAutomaton, subIncludeState, excludeAutomaton, excludeState, matchAllAutomaton);
                if (!includeAutomaton.isAccept(includeState) && filteredValue.isEmpty()) continue;
                filtered.put(key, filteredValue);
                continue;
            }
            if (value instanceof Iterable) {
                List<Object> filteredValue = XContentMapValues.filter((Iterable)value, subIncludeAutomaton, subIncludeState, excludeAutomaton, excludeState, matchAllAutomaton);
                if (!includeAutomaton.isAccept(includeState) && filteredValue.isEmpty()) continue;
                filtered.put(key, filteredValue);
                continue;
            }
            if (!includeAutomaton.isAccept(includeState) || excludeState != -1 && excludeAutomaton.isAccept(excludeState)) continue;
            filtered.put(key, value);
        }
        return filtered;
    }

    private static List<Object> filter(Iterable<?> iterable, CharacterRunAutomaton includeAutomaton, int initialIncludeState, CharacterRunAutomaton excludeAutomaton, int initialExcludeState, CharacterRunAutomaton matchAllAutomaton) {
        ArrayList<Object> filtered = new ArrayList<Object>();
        boolean isInclude = includeAutomaton.isAccept(initialIncludeState);
        for (Object value : iterable) {
            if (value instanceof Map) {
                Map<String, Object> filteredValue;
                int includeState = includeAutomaton.step(initialIncludeState, 46);
                int excludeState = initialExcludeState;
                if (excludeState != -1) {
                    excludeState = excludeAutomaton.step(excludeState, 46);
                }
                if ((filteredValue = XContentMapValues.filter((Map)value, includeAutomaton, includeState, excludeAutomaton, excludeState, matchAllAutomaton)).isEmpty()) continue;
                filtered.add(filteredValue);
                continue;
            }
            if (value instanceof Iterable) {
                List<Object> filteredValue = XContentMapValues.filter((Iterable)value, includeAutomaton, initialIncludeState, excludeAutomaton, initialExcludeState, matchAllAutomaton);
                if (filteredValue.isEmpty()) continue;
                filtered.add(filteredValue);
                continue;
            }
            if (!isInclude) continue;
            filtered.add(value);
        }
        return filtered;
    }

    public static boolean isArray(Object node) {
        return node instanceof List;
    }

    public static String nodeStringValue(Object node, String defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return node.toString();
    }

    public static String nodeStringValue(Object node) {
        if (node == null) {
            return null;
        }
        return node.toString();
    }

    public static double nodeDoubleValue(Object node, double defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeDoubleValue(node);
    }

    public static double nodeDoubleValue(Object node) {
        if (node instanceof Number) {
            return ((Number)node).doubleValue();
        }
        return Double.parseDouble(node.toString());
    }

    public static int nodeIntegerValue(Object node) {
        if (node instanceof Number) {
            return Numbers.toIntExact((Number)node);
        }
        return Integer.parseInt(node.toString());
    }

    public static int nodeIntegerValue(Object node, int defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeIntegerValue(node);
    }

    public static boolean nodeBooleanValue(Object node, String name, boolean defaultValue) {
        try {
            return XContentMapValues.nodeBooleanValue(node, defaultValue);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Could not convert [" + name + "] to boolean", ex);
        }
    }

    public static boolean nodeBooleanValue(Object node, boolean defaultValue) {
        String nodeValue = node == null ? null : node.toString();
        return Booleans.parseBoolean((String)nodeValue, (boolean)defaultValue);
    }

    public static boolean nodeBooleanValue(Object node, String name) {
        try {
            return XContentMapValues.nodeBooleanValue(node);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Could not convert [" + name + "] to boolean", ex);
        }
    }

    public static boolean nodeBooleanValue(Object node) {
        if (node instanceof Boolean) {
            return (Boolean)node;
        }
        return Booleans.parseBoolean((String)node.toString());
    }

    public static TimeValue nodeTimeValue(Object node, TimeValue defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeTimeValue(node);
    }

    public static TimeValue nodeTimeValue(Object node) {
        if (node instanceof Number) {
            return TimeValue.timeValueMillis((long)((Number)node).longValue());
        }
        return TimeValue.parseTimeValue((String)node.toString(), null, (String)(XContentMapValues.class.getSimpleName() + ".nodeTimeValue"));
    }

    public static Map<String, Object> nodeMapValue(Object node, String desc) {
        if (node instanceof Map) {
            return (Map)node;
        }
        throw new ElasticsearchParseException(desc + " should be a map but was of type: " + String.valueOf(node.getClass()), new Object[0]);
    }

    public static String[] nodeStringArrayValue(Object node) {
        if (node == null) {
            throw new ElasticsearchParseException("Expected a list of strings but got null", new Object[0]);
        }
        if (XContentMapValues.isArray(node)) {
            List list = (List)node;
            String[] arr = new String[list.size()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = XContentMapValues.nodeStringValue(list.get(i), null);
            }
            return arr;
        }
        return Strings.splitStringByCommaToArray(node.toString());
    }

    public static void insertValue(String path, Map<?, ?> map, Object newValue) {
        XContentMapValues.insertValue(path, map, newValue, true);
    }

    public static void insertValue(String path, Map<?, ?> map, Object newValue, boolean failOnMultiMap) {
        String[] pathElements = path.split("\\.");
        if (pathElements.length == 0) {
            return;
        }
        List<SuffixMap> suffixMaps = XContentMapValues.extractSuffixMaps(pathElements, 0, map);
        if (suffixMaps.isEmpty()) {
            throw new IllegalStateException("extractSuffixMaps returned an empty suffix map list");
        }
        if (suffixMaps.size() > 1 && failOnMultiMap) {
            throw new IllegalArgumentException("Path [" + path + "] could be inserted in " + suffixMaps.size() + " distinct ways, it is ambiguous which one to use");
        }
        SuffixMap suffixMap = suffixMaps.getFirst();
        suffixMap.map().put(suffixMap.suffix(), newValue);
    }

    private static List<SuffixMap> extractSuffixMaps(String[] pathElements, int index, Object currentValue) {
        if (currentValue instanceof List) {
            List valueList = (List)currentValue;
            ArrayList<SuffixMap> suffixMaps = new ArrayList<SuffixMap>(valueList.size());
            for (Object o : valueList) {
                suffixMaps.addAll(XContentMapValues.extractSuffixMaps(pathElements, index, o));
            }
            return suffixMaps;
        }
        if (currentValue instanceof Map) {
            Map map = (Map)currentValue;
            ArrayList<SuffixMap> suffixMaps = new ArrayList<SuffixMap>(map.size());
            Object key = pathElements[index];
            while (index < pathElements.length) {
                if (map.containsKey(key)) {
                    if (index + 1 == pathElements.length) {
                        suffixMaps.add(new SuffixMap((String)key, map));
                    } else {
                        suffixMaps.addAll(XContentMapValues.extractSuffixMaps(pathElements, index + 1, map.get(key)));
                    }
                }
                if (++index >= pathElements.length) continue;
                key = (String)key + "." + pathElements[index];
            }
            if (suffixMaps.isEmpty()) {
                suffixMaps.add(new SuffixMap((String)key, map));
            }
            return suffixMaps;
        }
        throw new IllegalArgumentException("Path [" + String.join((CharSequence)".", Arrays.copyOfRange(pathElements, 0, index)) + "] has value [" + String.valueOf(currentValue) + "] of type [" + currentValue.getClass().getSimpleName() + "], which cannot be traversed into further");
    }

    record SuffixMap(String suffix, Map<String, Object> map) {
    }
}

