/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.GenericNamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.OutputStreamStreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.util.ByteUtils;
import org.elasticsearch.core.CharArrays;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.Text;
import org.elasticsearch.xcontent.XContentString;
import org.elasticsearch.xcontent.XContentType;

public abstract class StreamOutput
extends OutputStream {
    private TransportVersion version = TransportVersion.current();
    private static final ThreadLocal<byte[]> scratch = ThreadLocal.withInitial(() -> new byte[1024]);
    private static final ThreadLocal<BytesRefBuilder> spareBytesRefBuilder = ThreadLocal.withInitial(BytesRefBuilder::new);
    private static final byte ZERO = 0;
    private static final byte ONE = 1;
    private static final byte TWO = 2;
    private static final Map<Class<?>, Writeable.Writer<?>> WRITERS = Map.ofEntries(Map.entry(String.class, (o, v) -> o.writeGenericString((String)v)), Map.entry(Integer.class, (o, v) -> {
        o.writeByte((byte)1);
        o.writeInt((Integer)v);
    }), Map.entry(Long.class, (o, v) -> {
        o.writeByte((byte)2);
        o.writeLong((Long)v);
    }), Map.entry(Float.class, (o, v) -> {
        o.writeByte((byte)3);
        o.writeFloat(((Float)v).floatValue());
    }), Map.entry(Double.class, (o, v) -> {
        o.writeByte((byte)4);
        o.writeDouble((Double)v);
    }), Map.entry(Boolean.class, (o, v) -> {
        o.writeByte((byte)5);
        o.writeBoolean((Boolean)v);
    }), Map.entry(byte[].class, (o, v) -> {
        o.writeByte((byte)6);
        byte[] bytes = (byte[])v;
        o.writeVInt(bytes.length);
        o.writeBytes(bytes);
    }), Map.entry(List.class, (o, v) -> o.writeGenericList((List)v, StreamOutput::writeGenericValue)), Map.entry(Object[].class, (o, v) -> {
        o.writeByte((byte)8);
        Object[] list = (Object[])v;
        o.writeArray(StreamOutput::writeGenericValue, list);
    }), Map.entry(Map.class, (o, v) -> {
        if (v instanceof LinkedHashMap) {
            o.writeByte((byte)9);
        } else {
            o.writeByte((byte)10);
        }
        if (o.getTransportVersion().onOrAfter(TransportVersions.V_8_7_0)) {
            Map map = (Map)v;
            o.writeMap(map, StreamOutput::writeGenericValue, StreamOutput::writeGenericValue);
        } else {
            Map map = (Map)v;
            o.writeMap(map, StreamOutput::writeGenericValue);
        }
    }), Map.entry(Byte.class, (o, v) -> {
        o.writeByte((byte)11);
        o.writeByte((Byte)v);
    }), Map.entry(Date.class, (o, v) -> {
        o.writeByte((byte)12);
        o.writeLong(((Date)v).getTime());
    }), Map.entry(BytesReference.class, (o, v) -> {
        o.writeByte((byte)14);
        o.writeBytesReference((BytesReference)v);
    }), Map.entry(Text.class, (o, v) -> {
        o.writeByte((byte)15);
        o.writeText((Text)v);
    }), Map.entry(Short.class, (o, v) -> {
        o.writeByte((byte)16);
        o.writeShort((Short)v);
    }), Map.entry(int[].class, (o, v) -> {
        o.writeByte((byte)17);
        o.writeIntArray((int[])v);
    }), Map.entry(long[].class, (o, v) -> {
        o.writeByte((byte)18);
        o.writeLongArray((long[])v);
    }), Map.entry(float[].class, (o, v) -> {
        o.writeByte((byte)19);
        o.writeFloatArray((float[])v);
    }), Map.entry(double[].class, (o, v) -> {
        o.writeByte((byte)20);
        o.writeDoubleArray((double[])v);
    }), Map.entry(BytesRef.class, (o, v) -> {
        o.writeByte((byte)21);
        o.writeBytesRef((BytesRef)v);
    }), Map.entry(GeoPoint.class, (o, v) -> {
        o.writeByte((byte)22);
        o.writeGeoPoint((GeoPoint)v);
    }), Map.entry(ZonedDateTime.class, (o, v) -> {
        o.writeByte((byte)23);
        ZonedDateTime zonedDateTime = (ZonedDateTime)v;
        o.writeString(zonedDateTime.getZone().getId());
        Instant instant = zonedDateTime.toInstant();
        if (o.getTransportVersion().onOrAfter(TransportVersions.V_8_16_0)) {
            o.writeZLong(instant.getEpochSecond());
            o.writeInt(instant.getNano());
        } else {
            o.writeLong(instant.toEpochMilli());
        }
    }), Map.entry(Set.class, (o, v) -> {
        if (v instanceof LinkedHashSet) {
            o.writeByte((byte)24);
        } else {
            o.writeByte((byte)25);
        }
        o.writeCollection((Set)v, StreamOutput::writeGenericValue);
    }), Map.entry(BigInteger.class, (o, v) -> {
        o.writeByte((byte)26);
        o.writeString(v.toString());
    }), Map.entry(OffsetTime.class, (o, v) -> {
        o.writeByte((byte)27);
        OffsetTime offsetTime = (OffsetTime)v;
        o.writeString(offsetTime.getOffset().getId());
        o.writeLong(offsetTime.toLocalTime().toNanoOfDay());
    }), Map.entry(Duration.class, (o, v) -> {
        o.writeByte((byte)28);
        Duration duration = (Duration)v;
        o.writeLong(duration.getSeconds());
        o.writeLong(duration.getNano());
    }), Map.entry(Period.class, (o, v) -> {
        o.writeByte((byte)29);
        Period period = (Period)v;
        o.writeInt(period.getYears());
        o.writeInt(period.getMonths());
        o.writeInt(period.getDays());
    }), Map.entry(GenericNamedWriteable.class, (o, v) -> {
        GenericNamedWriteable genericNamedWriteable = (GenericNamedWriteable)v;
        if (!genericNamedWriteable.supportsVersion(o.getTransportVersion())) {
            String message = Strings.format("[%s] doesn't support serialization with transport version [%s]", genericNamedWriteable.getWriteableName(), o.getTransportVersion());
            assert (false) : message;
            throw new IllegalStateException(message);
        }
        o.writeByte((byte)30);
        o.writeNamedWriteable(genericNamedWriteable);
    }));
    public static final byte GENERIC_LIST_HEADER = 7;

    public TransportVersion getTransportVersion() {
        return this.version;
    }

    public void setTransportVersion(TransportVersion version) {
        this.version = version;
    }

    public long position() throws IOException {
        throw new UnsupportedOperationException();
    }

    public abstract void writeByte(byte var1) throws IOException;

    public void writeBytes(byte[] b) throws IOException {
        this.writeBytes(b, 0, b.length);
    }

    public void writeBytes(byte[] b, int length) throws IOException {
        this.writeBytes(b, 0, length);
    }

    public abstract void writeBytes(byte[] var1, int var2, int var3) throws IOException;

    public void writeByteArray(byte[] b) throws IOException {
        this.writeVInt(b.length);
        this.writeBytes(b, 0, b.length);
    }

    @Deprecated
    public void legacyWriteWithSizePrefix(Writeable writeable) throws IOException {
        BytesStreamOutput tmp = new BytesStreamOutput();
        tmp.setTransportVersion(this.version);
        writeable.writeTo(tmp);
        this.writeBytesReference(tmp.bytes());
    }

    public void writeWithSizePrefix(Writeable writeable) throws IOException {
        BytesStreamOutput tmp = new BytesStreamOutput();
        try (OutputStreamStreamOutput o = new OutputStreamStreamOutput(CompressorFactory.COMPRESSOR.threadLocalOutputStream(tmp));){
            o.setTransportVersion(this.version);
            writeable.writeTo(o);
        }
        BytesReference bytes = tmp.bytes();
        this.writeInt(bytes.length());
        bytes.writeTo(this);
    }

    public void writeBytesReference(@Nullable BytesReference bytes) throws IOException {
        if (bytes == null) {
            this.writeVInt(0);
            return;
        }
        this.writeVInt(bytes.length());
        bytes.writeTo(this);
    }

    public void writeOptionalBytesReference(@Nullable BytesReference bytes) throws IOException {
        if (bytes == null) {
            this.writeVInt(0);
            return;
        }
        this.writeVInt(bytes.length() + 1);
        bytes.writeTo(this);
    }

    public void writeBytesRef(BytesRef bytes) throws IOException {
        if (bytes == null) {
            this.writeVInt(0);
            return;
        }
        this.writeVInt(bytes.length);
        this.write(bytes.bytes, bytes.offset, bytes.length);
    }

    public final void writeShort(short v) throws IOException {
        byte[] buffer = scratch.get();
        ByteUtils.writeShortBE(v, buffer, 0);
        this.writeBytes(buffer, 0, 2);
    }

    public void writeInt(int i) throws IOException {
        byte[] buffer = scratch.get();
        ByteUtils.writeIntBE(i, buffer, 0);
        this.writeBytes(buffer, 0, 4);
    }

    public void writeIntLE(int i) throws IOException {
        byte[] buffer = scratch.get();
        ByteUtils.writeIntLE(i, buffer, 0);
        this.writeBytes(buffer, 0, 4);
    }

    public void writeVInt(int i) throws IOException {
        if (Integer.numberOfLeadingZeros(i) >= 25) {
            this.writeByte((byte)i);
            return;
        }
        byte[] buffer = scratch.get();
        int index = StreamOutput.putMultiByteVInt(buffer, i, 0);
        this.writeBytes(buffer, 0, index);
    }

    public static int putVInt(byte[] buffer, int i, int off) {
        if (Integer.numberOfLeadingZeros(i) >= 25) {
            buffer[off] = (byte)i;
            return 1;
        }
        return StreamOutput.putMultiByteVInt(buffer, i, off);
    }

    protected static int putMultiByteVInt(byte[] buffer, int i, int off) {
        int index = off;
        do {
            buffer[index++] = (byte)(i & 0x7F | 0x80);
        } while (((i >>>= 7) & 0xFFFFFF80) != 0);
        buffer[index++] = (byte)i;
        return index - off;
    }

    public void writeLong(long i) throws IOException {
        byte[] buffer = scratch.get();
        ByteUtils.writeLongBE(i, buffer, 0);
        this.writeBytes(buffer, 0, 8);
    }

    public void writeLongLE(long i) throws IOException {
        byte[] buffer = scratch.get();
        ByteUtils.writeLongLE(i, buffer, 0);
        this.writeBytes(buffer, 0, 8);
    }

    public void writeVLong(long i) throws IOException {
        if (i < 0L) {
            throw new IllegalStateException("Negative longs unsupported, use writeLong or writeZLong for negative numbers [" + i + "]");
        }
        this.writeVLongNoCheck(i);
    }

    public void writeOptionalVLong(@Nullable Long l) throws IOException {
        if (l == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeVLong(l);
        }
    }

    void writeVLongNoCheck(long i) throws IOException {
        byte[] buffer = scratch.get();
        int index = 0;
        while ((i & 0xFFFFFFFFFFFFFF80L) != 0L) {
            buffer[index++] = (byte)(i & 0x7FL | 0x80L);
            i >>>= 7;
        }
        buffer[index++] = (byte)i;
        this.writeBytes(buffer, 0, index);
    }

    public void writeZLong(long i) throws IOException {
        byte[] buffer = scratch.get();
        int index = 0;
        long value = BitUtil.zigZagEncode((long)i);
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            buffer[index++] = (byte)(value & 0x7FL | 0x80L);
            value >>>= 7;
        }
        buffer[index++] = (byte)(value & 0x7FL);
        this.writeBytes(buffer, 0, index);
    }

    public void writeOptionalLong(@Nullable Long l) throws IOException {
        if (l == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeLong(l);
        }
    }

    public void writeOptionalString(@Nullable String str) throws IOException {
        if (str == null) {
            this.writeBoolean(false);
        } else {
            byte[] buffer = scratch.get();
            buffer[0] = 1;
            this.writeString(str, buffer, 1);
        }
    }

    public void writeOptionalSecureString(@Nullable SecureString secureStr) throws IOException {
        if (secureStr == null) {
            this.writeOptionalBytesReference(null);
        } else {
            byte[] secureStrBytes = CharArrays.toUtf8Bytes((char[])secureStr.getChars());
            try {
                this.writeOptionalBytesReference(new BytesArray(secureStrBytes));
            }
            finally {
                Arrays.fill(secureStrBytes, (byte)0);
            }
        }
    }

    public void writeOptionalInt(@Nullable Integer integer) throws IOException {
        if (integer == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeInt(integer);
        }
    }

    public void writeOptionalVInt(@Nullable Integer integer) throws IOException {
        if (integer == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeVInt(integer);
        }
    }

    public void writeOptionalFloat(@Nullable Float floatValue) throws IOException {
        if (floatValue == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeFloat(floatValue.floatValue());
        }
    }

    public void writeOptionalText(@Nullable Text text) throws IOException {
        if (text == null) {
            this.writeInt(-1);
        } else {
            this.writeText(text);
        }
    }

    public void writeText(Text text) throws IOException {
        if (!text.hasBytes()) {
            String string = text.string();
            BytesRefBuilder spare = spareBytesRefBuilder.get();
            spare.copyChars((CharSequence)string);
            this.writeInt(spare.length());
            this.write(spare.bytes(), 0, spare.length());
        } else {
            XContentString.UTF8Bytes encoded = text.bytes();
            BytesArray bytes = new BytesArray(encoded.bytes(), encoded.offset(), encoded.length());
            this.writeInt(bytes.length());
            bytes.writeTo(this);
        }
    }

    public void writeString(String str) throws IOException {
        this.writeString(str, scratch.get(), 0);
    }

    private void writeString(String str, byte[] buffer, int off) throws IOException {
        int charCount = str.length();
        int offset = off + StreamOutput.putVInt(buffer, charCount, off);
        for (int i = 0; i < charCount; ++i) {
            char c = str.charAt(i);
            if (c <= '\u007f') {
                buffer[offset++] = (byte)c;
            } else if (c > '\u07ff') {
                buffer[offset++] = (byte)(0xE0 | c >> 12 & 0xF);
                buffer[offset++] = (byte)(0x80 | c >> 6 & 0x3F);
                buffer[offset++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                buffer[offset++] = (byte)(0xC0 | c >> 6 & 0x1F);
                buffer[offset++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            if (offset <= buffer.length - 3) continue;
            this.writeBytes(buffer, offset);
            offset = 0;
        }
        this.writeBytes(buffer, offset);
    }

    public void writeSecureString(SecureString secureStr) throws IOException {
        byte[] secureStrBytes = CharArrays.toUtf8Bytes((char[])secureStr.getChars());
        try {
            this.writeBytesReference(new BytesArray(secureStrBytes));
        }
        finally {
            Arrays.fill(secureStrBytes, (byte)0);
        }
    }

    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public void writeDoubleLE(double v) throws IOException {
        this.writeLongLE(Double.doubleToLongBits(v));
    }

    public void writeOptionalDouble(@Nullable Double v) throws IOException {
        if (v == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeDouble(v);
        }
    }

    public void writeBoolean(boolean b) throws IOException {
        this.writeByte(b ? (byte)1 : 0);
    }

    public void writeOptionalBoolean(@Nullable Boolean b) throws IOException {
        if (b == null) {
            this.writeByte((byte)2);
        } else {
            this.writeBoolean(b);
        }
    }

    @Override
    public abstract void flush() throws IOException;

    @Override
    public abstract void close() throws IOException;

    @Override
    public void write(int b) throws IOException {
        this.writeByte((byte)b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.writeBytes(b, off, len);
    }

    public void writeStringArray(String[] array) throws IOException {
        this.writeVInt(array.length);
        for (String s : array) {
            this.writeString(s);
        }
    }

    public void writeStringArrayNullable(@Nullable String[] array) throws IOException {
        if (array == null) {
            this.writeVInt(0);
        } else {
            this.writeStringArray(array);
        }
    }

    public void writeOptionalStringArray(@Nullable String[] array) throws IOException {
        if (array == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeStringArray(array);
        }
    }

    public void writeOptionalByteArray(@Nullable byte[] array) throws IOException {
        if (array == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeByteArray(array);
        }
    }

    public void writeOptionalFloatArray(@Nullable float[] array) throws IOException {
        if (array == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeFloatArray(array);
        }
    }

    public void writeGenericMap(@Nullable Map<String, Object> map) throws IOException {
        this.writeGenericValue(map);
    }

    public void writeMapWithConsistentOrder(@Nullable Map<String, ? extends Object> map) throws IOException {
        if (map == null) {
            this.writeByte((byte)-1);
            return;
        }
        assert (!(map instanceof LinkedHashMap));
        this.writeByte((byte)10);
        this.writeVInt(map.size());
        Iterator iterator = map.entrySet().stream().sorted(Map.Entry.comparingByKey()).iterator();
        while (iterator.hasNext()) {
            Map.Entry next = (Map.Entry)iterator.next();
            if (this.getTransportVersion().onOrAfter(TransportVersions.V_8_7_0)) {
                this.writeGenericValue(next.getKey());
            } else {
                this.writeString((String)next.getKey());
            }
            this.writeGenericValue(next.getValue());
        }
    }

    public final <V> void writeMapValues(Map<?, V> map, Writeable.Writer<V> valueWriter) throws IOException {
        this.writeCollection(map.values(), valueWriter);
    }

    public final <V extends Writeable> void writeMapValues(Map<?, V> map) throws IOException {
        this.writeMapValues(map, StreamOutput::writeWriteable);
    }

    public final <K extends Writeable, V extends Writeable> void writeMap(Map<K, V> map) throws IOException {
        this.writeMap(map, StreamOutput::writeWriteable, StreamOutput::writeWriteable);
    }

    public final <K, V> void writeOptionalMap(Map<K, V> map, Writeable.Writer<K> keyWriter, Writeable.Writer<V> valueWriter) throws IOException {
        if (map == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeMap(map, keyWriter, valueWriter);
        }
    }

    public final <K, V> void writeMap(Map<K, V> map, Writeable.Writer<K> keyWriter, Writeable.Writer<V> valueWriter) throws IOException {
        int size = map.size();
        this.writeVInt(size);
        if (size > 0) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                keyWriter.write(this, entry.getKey());
                valueWriter.write(this, entry.getValue());
            }
        }
    }

    public final <V> void writeMap(Map<String, V> map, Writeable.Writer<V> valueWriter) throws IOException {
        this.writeMap(map, StreamOutput::writeString, valueWriter);
    }

    public final void writeInstant(Instant instant) throws IOException {
        this.writeLong(instant.getEpochSecond());
        this.writeInt(instant.getNano());
    }

    public final void writeOptionalInstant(@Nullable Instant instant) throws IOException {
        if (instant == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeInstant(instant);
        }
    }

    public <T> void writeGenericList(List<T> v, Writeable.Writer<T> writer) throws IOException {
        this.writeByte((byte)7);
        this.writeCollection(v, writer);
    }

    public void writeGenericString(String value) throws IOException {
        byte[] buffer = scratch.get();
        buffer[0] = 0;
        this.writeString(value, buffer, 1);
    }

    public void writeGenericNull() throws IOException {
        this.writeByte((byte)-1);
    }

    private static Class<?> getGenericType(Object value) {
        if (value instanceof List) {
            return List.class;
        }
        if (value instanceof Object[]) {
            return Object[].class;
        }
        if (value instanceof Map) {
            return Map.class;
        }
        if (value instanceof Set) {
            return Set.class;
        }
        if (value instanceof BytesReference) {
            return BytesReference.class;
        }
        if (value instanceof GenericNamedWriteable) {
            return GenericNamedWriteable.class;
        }
        return value.getClass();
    }

    public void writeGenericValue(@Nullable Object value) throws IOException {
        if (value == null) {
            this.writeGenericNull();
            return;
        }
        Class<?> type = StreamOutput.getGenericType(value);
        Writeable.Writer<?> writer = WRITERS.get(type);
        if (writer == null) {
            throw new IllegalArgumentException("can not write type [" + String.valueOf(type) + "]");
        }
        writer.write(this, value);
    }

    public static void checkWriteable(@Nullable Object value) throws IllegalArgumentException {
        if (value == null) {
            return;
        }
        Class<?> type = StreamOutput.getGenericType(value);
        if (type == List.class) {
            List list = (List)value;
            for (Object v : list) {
                StreamOutput.checkWriteable(v);
            }
        } else if (type == Object[].class) {
            Object[] array;
            for (Object v : array = (Object[])value) {
                StreamOutput.checkWriteable(v);
            }
        } else if (type == Map.class) {
            Map map = (Map)value;
            for (Map.Entry entry : map.entrySet()) {
                StreamOutput.checkWriteable(entry.getKey());
                StreamOutput.checkWriteable(entry.getValue());
            }
        } else if (type == Set.class) {
            Set set = (Set)value;
            for (Object v : set) {
                StreamOutput.checkWriteable(v);
            }
        } else if (!WRITERS.containsKey(type)) {
            throw new IllegalArgumentException("Cannot write type [" + type.getCanonicalName() + "] to stream");
        }
    }

    public void writeIntArray(int[] values) throws IOException {
        this.writeVInt(values.length);
        for (int value : values) {
            this.writeInt(value);
        }
    }

    public void writeVIntArray(int[] values) throws IOException {
        this.writeVInt(values.length);
        for (int value : values) {
            this.writeVInt(value);
        }
    }

    public void writeLongArray(long[] values) throws IOException {
        this.writeVInt(values.length);
        for (long value : values) {
            this.writeLong(value);
        }
    }

    public void writeVLongArray(long[] values) throws IOException {
        this.writeVInt(values.length);
        for (long value : values) {
            this.writeVLong(value);
        }
    }

    public void writeFloatArray(float[] values) throws IOException {
        this.writeVInt(values.length);
        for (float value : values) {
            this.writeFloat(value);
        }
    }

    public void writeDoubleArray(double[] values) throws IOException {
        this.writeVInt(values.length);
        for (double value : values) {
            this.writeDouble(value);
        }
    }

    public <T> void writeArray(Writeable.Writer<T> writer, T[] array) throws IOException {
        this.writeVInt(array.length);
        for (T value : array) {
            writer.write(this, value);
        }
    }

    public <T> void writeOptionalArray(Writeable.Writer<T> writer, @Nullable T[] array) throws IOException {
        if (array == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeArray(writer, array);
        }
    }

    public <T extends Writeable> void writeArray(T[] array) throws IOException {
        this.writeArray(StreamOutput::writeWriteable, array);
    }

    public <T extends Writeable> void writeOptionalArray(@Nullable T[] array) throws IOException {
        this.writeOptionalArray(StreamOutput::writeWriteable, array);
    }

    public void writeOptionalWriteable(@Nullable Writeable writeable) throws IOException {
        if (writeable != null) {
            this.writeBoolean(true);
            writeable.writeTo(this);
        } else {
            this.writeBoolean(false);
        }
    }

    public <T> void writeOptional(Writeable.Writer<T> writer, @Nullable T maybeItem) throws IOException {
        if (maybeItem != null) {
            this.writeBoolean(true);
            writer.write(this, maybeItem);
        } else {
            this.writeBoolean(false);
        }
    }

    public void writeWriteable(Writeable writeable) throws IOException {
        writeable.writeTo(this);
    }

    public void writeException(Throwable throwable) throws IOException {
        ElasticsearchException.writeException(throwable, this);
    }

    public void writeNamedWriteable(NamedWriteable namedWriteable) throws IOException {
        this.writeString(namedWriteable.getWriteableName());
        namedWriteable.writeTo(this);
    }

    public void writeOptionalNamedWriteable(@Nullable NamedWriteable namedWriteable) throws IOException {
        if (namedWriteable == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeNamedWriteable(namedWriteable);
        }
    }

    public void writeGeoPoint(GeoPoint geoPoint) throws IOException {
        this.writeDouble(geoPoint.lat());
        this.writeDouble(geoPoint.lon());
    }

    public void writeZoneId(ZoneId timeZone) throws IOException {
        this.writeString(timeZone.getId());
    }

    public void writeOptionalZoneId(@Nullable ZoneId timeZone) throws IOException {
        if (timeZone == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeZoneId(timeZone);
        }
    }

    public void writeCollection(Collection<? extends Writeable> collection) throws IOException {
        this.writeCollection(collection, StreamOutput::writeWriteable);
    }

    public <T> void writeCollection(Collection<T> collection, Writeable.Writer<T> writer) throws IOException {
        this.writeVInt(collection.size());
        for (T val : collection) {
            writer.write(this, val);
        }
    }

    public void writeStringCollection(Collection<String> collection) throws IOException {
        this.writeCollection(collection, StreamOutput::writeString);
    }

    public <T extends Writeable> void writeOptionalCollection(@Nullable Collection<T> collection) throws IOException {
        this.writeOptionalCollection(collection, StreamOutput::writeWriteable);
    }

    public <T> void writeOptionalCollection(@Nullable Collection<T> collection, Writeable.Writer<T> writer) throws IOException {
        if (collection != null) {
            this.writeBoolean(true);
            this.writeCollection(collection, writer);
        } else {
            this.writeBoolean(false);
        }
    }

    public void writeOptionalStringCollection(@Nullable Collection<String> collection) throws IOException {
        this.writeOptionalCollection(collection, StreamOutput::writeString);
    }

    public void writeNamedWriteableCollection(Collection<? extends NamedWriteable> list) throws IOException {
        this.writeCollection(list, StreamOutput::writeNamedWriteable);
    }

    public <E extends Enum<E>> void writeEnum(E enumValue) throws IOException {
        assert (!(enumValue instanceof XContentType)) : "XContentHelper#writeTo should be used for XContentType serialisation";
        this.writeVInt(enumValue.ordinal());
    }

    public <E extends Enum<E>> void writeOptionalEnum(@Nullable E enumValue) throws IOException {
        if (enumValue == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            assert (!(enumValue instanceof XContentType)) : "XContentHelper#writeTo should be used for XContentType serialisation";
            this.writeVInt(enumValue.ordinal());
        }
    }

    public <E extends Enum<E>> void writeEnumSet(EnumSet<E> enumSet) throws IOException {
        this.writeVInt(enumSet.size());
        for (Enum e : enumSet) {
            this.writeEnum(e);
        }
    }

    public void writeTimeValue(TimeValue timeValue) throws IOException {
        this.writeZLong(timeValue.duration());
        this.writeByte((byte)timeValue.timeUnit().ordinal());
    }

    public void writeOptionalTimeValue(@Nullable TimeValue timeValue) throws IOException {
        if (timeValue == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeTimeValue(timeValue);
        }
    }

    public <T extends Writeable> void writeMissingWriteable(Class<T> ignored) throws IOException {
        this.writeBoolean(false);
    }

    public void writeMissingString() throws IOException {
        this.writeBoolean(false);
    }

    public void writeBigInteger(BigInteger bigInteger) throws IOException {
        this.writeString(bigInteger.toString());
    }
}

