/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import org.elasticsearch.action.admin.cluster.stats.CCSTelemetrySnapshot;
import org.elasticsearch.action.admin.cluster.stats.CCSUsage;
import org.elasticsearch.action.admin.cluster.stats.LongMetric;
import org.elasticsearch.common.util.Maps;

public class CCSUsageTelemetry {
    public static final String MRT_FEATURE = "mrt_on";
    public static final String ASYNC_FEATURE = "async";
    public static final String WILDCARD_FEATURE = "wildcards";
    public static final String PIT_FEATURE = "pit";
    public static final Set<String> KNOWN_CLIENTS = Set.of("kibana", "cloud", "logstash", "beats", "fleet", "ml", "security", "observability", "enterprise-search", "elasticsearch", "connectors", "connectors-cli");
    private final LongAdder totalCount;
    private final LongAdder successCount;
    private final Map<Result, LongAdder> failureReasons;
    private final LongMetric took;
    private final LongMetric tookMrtTrue;
    private final LongMetric tookMrtFalse;
    private final LongMetric remotesPerSearch;
    private final LongAdder skippedRemotes;
    private final Map<String, LongAdder> featureCounts;
    private final Map<String, LongAdder> clientCounts;
    private final Map<String, PerClusterCCSTelemetry> byRemoteCluster = new ConcurrentHashMap<String, PerClusterCCSTelemetry>();
    private final boolean useMRT;

    public CCSUsageTelemetry() {
        this(true);
    }

    public CCSUsageTelemetry(boolean useMRT) {
        this.totalCount = new LongAdder();
        this.successCount = new LongAdder();
        this.failureReasons = new ConcurrentHashMap<Result, LongAdder>();
        this.took = new LongMetric();
        this.tookMrtTrue = new LongMetric();
        this.tookMrtFalse = new LongMetric();
        this.remotesPerSearch = new LongMetric();
        this.skippedRemotes = new LongAdder();
        this.featureCounts = new ConcurrentHashMap<String, LongAdder>();
        this.clientCounts = new ConcurrentHashMap<String, LongAdder>();
        this.useMRT = useMRT;
    }

    public void updateUsage(CCSUsage ccsUsage) {
        assert (ccsUsage.getRemotesCount() > 0L) : "Expected at least one remote cluster in CCSUsage";
        this.doUpdate(ccsUsage);
    }

    private void doUpdate(CCSUsage ccsUsage) {
        this.totalCount.increment();
        long searchTook = ccsUsage.getTook();
        if (this.isSuccess(ccsUsage)) {
            this.successCount.increment();
            this.took.record(searchTook);
            if (this.useMRT) {
                if (this.isMRT(ccsUsage)) {
                    this.tookMrtTrue.record(searchTook);
                } else {
                    this.tookMrtFalse.record(searchTook);
                }
            }
            ccsUsage.getPerClusterUsage().forEach((r, u) -> this.byRemoteCluster.computeIfAbsent((String)r, PerClusterCCSTelemetry::new).update((CCSUsage.PerClusterUsage)u));
        } else {
            this.failureReasons.computeIfAbsent(ccsUsage.getStatus(), k -> new LongAdder()).increment();
        }
        this.remotesPerSearch.record(ccsUsage.getRemotesCount());
        if (!ccsUsage.getSkippedRemotes().isEmpty()) {
            this.skippedRemotes.increment();
            ccsUsage.getSkippedRemotes().forEach(remote -> this.byRemoteCluster.computeIfAbsent((String)remote, PerClusterCCSTelemetry::new).skipped());
        }
        ccsUsage.getFeatures().forEach(f -> {
            if (this.useMRT || !f.equals(MRT_FEATURE)) {
                this.featureCounts.computeIfAbsent((String)f, k -> new LongAdder()).increment();
            }
        });
        String client = ccsUsage.getClient();
        if (client != null && KNOWN_CLIENTS.contains(client)) {
            this.clientCounts.computeIfAbsent(ccsUsage.getClient(), k -> new LongAdder()).increment();
        }
    }

    private boolean isMRT(CCSUsage ccsUsage) {
        return ccsUsage.getFeatures().contains(MRT_FEATURE);
    }

    private boolean isSuccess(CCSUsage ccsUsage) {
        return ccsUsage.getStatus() == Result.SUCCESS;
    }

    public Map<String, PerClusterCCSTelemetry> getTelemetryByCluster() {
        return this.byRemoteCluster;
    }

    public CCSTelemetrySnapshot getCCSTelemetrySnapshot() {
        Map reasonsMap = Maps.newMapWithExpectedSize(this.failureReasons.size());
        this.failureReasons.forEach((k, v) -> reasonsMap.put(k.getName(), v.longValue()));
        LongMetric.LongMetricValue remotes = this.remotesPerSearch.getValue();
        return new CCSTelemetrySnapshot(this.totalCount.longValue(), this.successCount.longValue(), Collections.unmodifiableMap(reasonsMap), this.took.getValue(), this.tookMrtTrue.getValue(), this.tookMrtFalse.getValue(), remotes.max(), remotes.avg(), this.skippedRemotes.longValue(), Collections.unmodifiableMap(Maps.transformValues(this.featureCounts, LongAdder::longValue)), Collections.unmodifiableMap(Maps.transformValues(this.clientCounts, LongAdder::longValue)), Collections.unmodifiableMap(Maps.transformValues(this.byRemoteCluster, PerClusterCCSTelemetry::getSnapshot))).setUseMRT(this.useMRT);
    }

    public static enum Result {
        SUCCESS("success"),
        REMOTES_UNAVAILABLE("remotes_unavailable"),
        CANCELED("canceled"),
        NOT_FOUND("not_found"),
        TIMEOUT("timeout"),
        CORRUPTION("corruption"),
        SECURITY("security"),
        LICENSE("license"),
        UNKNOWN("other");

        private final String name;

        private Result(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class PerClusterCCSTelemetry {
        private final String clusterAlias;
        private final LongAdder count;
        private final LongAdder skippedCount;
        private final LongMetric took;

        PerClusterCCSTelemetry(String clusterAlias) {
            this.clusterAlias = clusterAlias;
            this.count = new LongAdder();
            this.took = new LongMetric();
            this.skippedCount = new LongAdder();
        }

        void update(CCSUsage.PerClusterUsage remoteUsage) {
            this.count.increment();
            this.took.record(remoteUsage.getTook());
        }

        void skipped() {
            this.skippedCount.increment();
        }

        public long getCount() {
            return this.count.longValue();
        }

        public String toString() {
            return "PerClusterCCSTelemetry{clusterAlias='" + this.clusterAlias + "', count=" + String.valueOf(this.count) + ", latency=" + this.took.toString() + "}";
        }

        public long getSkippedCount() {
            return this.skippedCount.longValue();
        }

        public CCSTelemetrySnapshot.PerClusterCCSTelemetry getSnapshot() {
            return new CCSTelemetrySnapshot.PerClusterCCSTelemetry(this.count.longValue(), this.skippedCount.longValue(), this.took.getValue());
        }
    }
}

