/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.repositories.delete;

import java.util.Optional;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.repositories.delete.DeleteRepositoryRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.project.ProjectStateRegistry;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteRepositoryAction
extends AcknowledgedTransportMasterNodeAction<DeleteRepositoryRequest> {
    public static final ActionType<AcknowledgedResponse> TYPE = new ActionType("cluster:admin/repository/delete");
    private final RepositoriesService repositoriesService;
    private final ProjectResolver projectResolver;

    @Inject
    public TransportDeleteRepositoryAction(TransportService transportService, ClusterService clusterService, RepositoriesService repositoriesService, ThreadPool threadPool, ActionFilters actionFilters, ProjectResolver projectResolver) {
        super(TYPE.name(), transportService, clusterService, threadPool, actionFilters, DeleteRepositoryRequest::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.repositoriesService = repositoriesService;
        this.projectResolver = projectResolver;
    }

    @Override
    protected ClusterBlockException checkBlock(DeleteRepositoryRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(this.projectResolver.getProjectId(), ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected void masterOperation(Task task, DeleteRepositoryRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        this.repositoriesService.unregisterRepository(this.projectResolver.getProjectId(), request, listener);
    }

    @Override
    public Optional<String> reservedStateHandlerName() {
        return Optional.of("snapshot_repositories");
    }

    @Override
    public Set<String> modifiedKeys(DeleteRepositoryRequest request) {
        return Set.of(request.name());
    }

    @Override
    protected void validateForReservedState(DeleteRepositoryRequest request, ClusterState state) {
        super.validateForReservedState(request, state);
        this.validateForReservedState(ProjectStateRegistry.get(state).reservedStateMetadata(this.projectResolver.getProjectId()).values(), this.reservedStateHandlerName().get(), this.modifiedKeys(request), request::toString);
    }
}

