/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.metric;

import org.elasticsearch.xpack.security.metric.SecurityMetricGroup;
import org.elasticsearch.xpack.security.metric.SecurityMetricInfo;

public enum SecurityMetricType {
    AUTHC_API_KEY(SecurityMetricGroup.AUTHC, new SecurityMetricInfo("es.security.authc.api_key.success.total", "Number of successful API key authentications.", "count"), new SecurityMetricInfo("es.security.authc.api_key.failures.total", "Number of failed API key authentications.", "count"), new SecurityMetricInfo("es.security.authc.api_key.time", "Time it took (in nanoseconds) to execute API key authentication.", "ns")),
    CLOUD_AUTHC_API_KEY(SecurityMetricGroup.AUTHC, new SecurityMetricInfo("es.security.authc.cloud_api_key.success.total", "Number of successful cloud API key authentications.", "count"), new SecurityMetricInfo("es.security.authc.cloud_api_key.failures.total", "Number of failed cloud API key authentications.", "count"), new SecurityMetricInfo("es.security.authc.cloud_api_key.time", "Time it took (in nanoseconds) to execute cloud API key authentication.", "ns")),
    AUTHC_SERVICE_ACCOUNT(SecurityMetricGroup.AUTHC, new SecurityMetricInfo("es.security.authc.service_account.success.total", "Number of successful service account authentications.", "count"), new SecurityMetricInfo("es.security.authc.service_account.failures.total", "Number of failed service account authentications.", "count"), new SecurityMetricInfo("es.security.authc.service_account.time", "Time it took (in nanoseconds) to execute service account authentication.", "ns")),
    AUTHC_OAUTH2_TOKEN(SecurityMetricGroup.AUTHC, new SecurityMetricInfo("es.security.authc.token.success.total", "Number of successful OAuth2 token authentications.", "count"), new SecurityMetricInfo("es.security.authc.token.failures.total", "Number of failed OAuth2 token authentications.", "count"), new SecurityMetricInfo("es.security.authc.token.time", "Time it took (in nanoseconds) to execute OAuth2 token authentication.", "ns")),
    AUTHC_REALMS(SecurityMetricGroup.AUTHC, new SecurityMetricInfo("es.security.authc.realms.success.total", "Number of successful realm authentications.", "count"), new SecurityMetricInfo("es.security.authc.realms.failures.total", "Number of failed realm authentications.", "count"), new SecurityMetricInfo("es.security.authc.realms.time", "Time it took (in nanoseconds) to execute realm authentication.", "ns"));

    private final SecurityMetricGroup group;
    private final SecurityMetricInfo successMetricInfo;
    private final SecurityMetricInfo failuresMetricInfo;
    private final SecurityMetricInfo timeMetricInfo;

    private SecurityMetricType(SecurityMetricGroup group, SecurityMetricInfo successMetricInfo, SecurityMetricInfo failuresMetricInfo, SecurityMetricInfo timeMetricInfo) {
        this.group = group;
        this.successMetricInfo = successMetricInfo;
        this.failuresMetricInfo = failuresMetricInfo;
        this.timeMetricInfo = timeMetricInfo;
    }

    public SecurityMetricGroup group() {
        return this.group;
    }

    public SecurityMetricInfo successMetricInfo() {
        return this.successMetricInfo;
    }

    public SecurityMetricInfo failuresMetricInfo() {
        return this.failuresMetricInfo;
    }

    public SecurityMetricInfo timeMetricInfo() {
        return this.timeMetricInfo;
    }
}

