/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.node.Node;
import org.elasticsearch.xpack.core.common.IteratingActionListener;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.authc.AuthenticationServiceField;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.authc.Realm;
import org.elasticsearch.xpack.core.security.authc.support.AuthenticationContextSerializer;
import org.elasticsearch.xpack.core.security.support.Exceptions;
import org.elasticsearch.xpack.core.security.user.AnonymousUser;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authc.ApiKeyAuthenticator;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authc.Authenticator;
import org.elasticsearch.xpack.security.authc.OAuth2TokenAuthenticator;
import org.elasticsearch.xpack.security.authc.PluggableAuthenticatorChain;
import org.elasticsearch.xpack.security.authc.RealmsAuthenticator;
import org.elasticsearch.xpack.security.authc.ServiceAccountAuthenticator;
import org.elasticsearch.xpack.security.operator.OperatorPrivileges;

class AuthenticatorChain {
    private static final Logger logger = LogManager.getLogger(AuthenticatorChain.class);
    private final String nodeName;
    private final boolean runAsEnabled;
    private final OperatorPrivileges.OperatorPrivilegesService operatorPrivilegesService;
    private final AnonymousUser anonymousUser;
    private final boolean isAnonymousUserEnabled;
    private final AuthenticationContextSerializer authenticationSerializer;
    private final RealmsAuthenticator realmsAuthenticator;
    private final List<Authenticator> allAuthenticators;

    AuthenticatorChain(Settings settings, OperatorPrivileges.OperatorPrivilegesService operatorPrivilegesService, AnonymousUser anonymousUser, AuthenticationContextSerializer authenticationSerializer, PluggableAuthenticatorChain pluggableAuthenticatorChain, ServiceAccountAuthenticator serviceAccountAuthenticator, OAuth2TokenAuthenticator oAuth2TokenAuthenticator, ApiKeyAuthenticator apiKeyAuthenticator, RealmsAuthenticator realmsAuthenticator) {
        this.nodeName = (String)Node.NODE_NAME_SETTING.get(settings);
        this.runAsEnabled = (Boolean)AuthenticationServiceField.RUN_AS_ENABLED.get(settings);
        this.operatorPrivilegesService = operatorPrivilegesService;
        this.anonymousUser = anonymousUser;
        this.isAnonymousUserEnabled = AnonymousUser.isAnonymousEnabled((Settings)settings);
        this.authenticationSerializer = authenticationSerializer;
        this.realmsAuthenticator = realmsAuthenticator;
        ArrayList<Authenticator> authenticators = new ArrayList<Authenticator>();
        if (pluggableAuthenticatorChain.hasCustomAuthenticators()) {
            authenticators.add(pluggableAuthenticatorChain);
        }
        authenticators.add(serviceAccountAuthenticator);
        authenticators.add(oAuth2TokenAuthenticator);
        authenticators.add(apiKeyAuthenticator);
        authenticators.add(realmsAuthenticator);
        this.allAuthenticators = Collections.unmodifiableList(authenticators);
    }

    void authenticate(Authenticator.Context context, ActionListener<Authentication> originalListener) {
        Authentication authentication2;
        assert (!context.getDefaultOrderedRealmList().isEmpty()) : "realm list must not be empty";
        ActionListener listener = ActionListener.wrap(authentication -> {
            assert (authentication != null);
            this.operatorPrivilegesService.maybeMarkOperatorUser((Authentication)authentication, context.getThreadContext());
            logger.trace(() -> Strings.format((String)"Authentication for [%s]", (Object[])new Object[]{authentication}));
            originalListener.onResponse(authentication);
        }, ex -> {
            logger.debug(() -> Strings.format((String)"Authentication for context [%s] failed", (Object[])new Object[]{context}), (Throwable)ex);
            originalListener.onFailure(ex);
        });
        if (context.getMostRecentAuthenticationToken() != null) {
            this.doAuthenticate(context, (ActionListener<Authentication>)listener);
            return;
        }
        try {
            authentication2 = this.lookForExistingAuthentication(context);
        }
        catch (Exception e) {
            listener.onFailure(e);
            return;
        }
        if (authentication2 != null) {
            logger.trace("Found existing authentication [{}] in request [{}]", (Object)authentication2, (Object)context.getRequest());
            listener.onResponse((Object)authentication2);
        } else {
            this.doAuthenticate(context, (ActionListener<Authentication>)ActionListener.runBefore((ActionListener)listener, context::close));
        }
    }

    private void doAuthenticate(Authenticator.Context context, ActionListener<Authentication> listener) {
        IteratingActionListener iterListener = new IteratingActionListener(listener.delegateFailureAndWrap((l, result) -> {
            assert (result.getStatus() != AuthenticationResult.Status.TERMINATE) : "terminate should already be handled by each individual authenticator";
            if (result.getStatus() == AuthenticationResult.Status.SUCCESS) {
                this.maybeLookupRunAsUser(context, (Authentication)result.getValue(), (ActionListener<Authentication>)l);
            } else {
                assert (result.getStatus() == AuthenticationResult.Status.CONTINUE);
                if (context.shouldHandleNullToken()) {
                    this.handleNullToken(context, (ActionListener<Authentication>)l);
                } else {
                    l.onFailure((Exception)((Object)Exceptions.authenticationError((String)"failed to authenticate", (Throwable)result.getException(), (Object[])new Object[0])));
                }
            }
        }), AuthenticatorChain.getAuthenticatorConsumer(context), this.allAuthenticators, context.getThreadContext(), Function.identity(), result -> result.getStatus() == AuthenticationResult.Status.CONTINUE);
        iterListener.run();
    }

    private static BiConsumer<Authenticator, ActionListener<AuthenticationResult<Authentication>>> getAuthenticatorConsumer(Authenticator.Context context) {
        return (authenticator, listener) -> {
            if (context.shouldExtractCredentials()) {
                AuthenticationToken authenticationToken;
                try {
                    authenticationToken = authenticator.extractCredentials(context);
                }
                catch (Exception e2) {
                    if (e2 instanceof ElasticsearchSecurityException) {
                        listener.onFailure(e2);
                    } else {
                        context.addUnsuccessfulMessage(authenticator.name() + ": " + e2.getMessage());
                        listener.onResponse((Object)AuthenticationResult.unsuccessful((String)e2.getMessage(), (Exception)e2));
                    }
                    return;
                }
                if (authenticationToken == null) {
                    listener.onResponse((Object)AuthenticationResult.notHandled());
                    return;
                }
                context.addAuthenticationToken(authenticationToken);
            }
            Consumer<Exception> onFailure = e -> {
                assert (e != null) : "exception cannot be null";
                if (e instanceof ElasticsearchSecurityException) {
                    ElasticsearchSecurityException ese = (ElasticsearchSecurityException)((Object)((Object)((Object)e)));
                    if (!context.getUnsuccessfulMessages().isEmpty()) {
                        AuthenticatorChain.addMetadata(context, ese);
                    }
                }
                listener.onFailure(e);
            };
            authenticator.authenticate(context, (ActionListener<AuthenticationResult<Authentication>>)ActionListener.wrap(result -> {
                if (result.getStatus() == AuthenticationResult.Status.TERMINATE) {
                    onFailure.accept(result.getException());
                    return;
                }
                if (result.getStatus() == AuthenticationResult.Status.CONTINUE && result.getMessage() != null) {
                    context.addUnsuccessfulMessage(authenticator.name() + ": " + result.getMessage());
                }
                listener.onResponse(result);
            }, onFailure));
        };
    }

    void maybeLookupRunAsUser(Authenticator.Context context, Authentication authentication, ActionListener<Authentication> listener) {
        if (!this.runAsEnabled) {
            this.finishAuthentication(context, authentication, listener);
            return;
        }
        String runAsUsername = context.getThreadContext().getHeader("es-security-runas-user");
        if (runAsUsername == null) {
            this.finishAuthentication(context, authentication, listener);
            return;
        }
        if (!authentication.supportsRunAs(this.anonymousUser)) {
            logger.info("ignore run-as header since it is currently not supported for authentication [{}]", (Object)authentication);
            this.finishAuthentication(context, authentication, listener);
            return;
        }
        this.realmsAuthenticator.lookupRunAsUser(context, authentication, (ActionListener<Tuple<User, Realm>>)listener.delegateFailureAndWrap((l, tuple) -> {
            Authentication finalAuth;
            if (tuple == null) {
                logger.debug("Cannot find run-as user [{}] for authenticated user [{}]", (Object)runAsUsername, (Object)authentication.getAuthenticatingSubject().getUser().principal());
                finalAuth = authentication.runAs(new User(runAsUsername, null, null, null, Map.of(), true), null);
            } else {
                finalAuth = authentication.runAs((User)tuple.v1(), ((Realm)tuple.v2()).realmRef());
            }
            this.finishAuthentication(context, finalAuth, (ActionListener<Authentication>)l);
        }));
    }

    private Authentication lookForExistingAuthentication(Authenticator.Context context) {
        Authentication authentication;
        try {
            authentication = this.authenticationSerializer.readFromContext(context.getThreadContext());
        }
        catch (Exception e) {
            logger.error(() -> Strings.format((String)"caught exception while trying to read authentication from request [%s]", (Object[])new Object[]{context.getRequest()}), (Throwable)e);
            throw context.getRequest().tamperedRequest();
        }
        if (authentication != null && context.getRequest() instanceof AuthenticationService.AuditableHttpRequest) {
            throw context.getRequest().tamperedRequest();
        }
        return authentication;
    }

    void handleNullToken(Authenticator.Context context, ActionListener<Authentication> listener) {
        Authentication authentication;
        if (context.getFallbackUser() != null) {
            logger.trace("No valid credentials found in request [{}], using fallback [{}]", (Object)context.getRequest(), (Object)context.getFallbackUser().principal());
            authentication = Authentication.newInternalFallbackAuthentication((User)context.getFallbackUser(), (String)this.nodeName);
        } else if (this.shouldFallbackToAnonymous(context)) {
            logger.trace("No valid credentials found in request [{}], using anonymous [{}]", (Object)context.getRequest(), (Object)this.anonymousUser.principal());
            authentication = Authentication.newAnonymousAuthentication((AnonymousUser)this.anonymousUser, (String)this.nodeName);
        } else {
            authentication = null;
        }
        if (authentication != null) {
            this.writeAuthToContext(context, authentication, listener);
        } else {
            ElasticsearchSecurityException ese = context.getRequest().anonymousAccessDenied();
            if (!context.getUnsuccessfulMessages().isEmpty()) {
                logger.debug("Authenticating with null credentials is unsuccessful in request [{}] after unsuccessful attempts of other credentials", (Object)context.getRequest());
                ElasticsearchSecurityException eseWithPreviousCredentials = new ElasticsearchSecurityException("unable to authenticate with provided credentials and anonymous access is not allowed for this request", ese.status(), ese.getCause(), new Object[0]);
                ese.getBodyHeaderKeys().forEach(k -> eseWithPreviousCredentials.addBodyHeader(k, ese.getBodyHeader(k)));
                AuthenticatorChain.addMetadata(context, eseWithPreviousCredentials);
                listener.onFailure((Exception)((Object)eseWithPreviousCredentials));
            } else {
                logger.debug("No valid credentials found in request [{}], rejecting", (Object)context.getRequest());
                listener.onFailure((Exception)((Object)ese));
            }
        }
    }

    void finishAuthentication(Authenticator.Context context, Authentication authentication, ActionListener<Authentication> listener) {
        if (!authentication.getEffectiveSubject().getUser().enabled() || !authentication.getAuthenticatingSubject().getUser().enabled()) {
            logger.debug("user [{}] is disabled. failing authentication", (Object)authentication.getEffectiveSubject().getUser());
            listener.onFailure((Exception)((Object)context.getRequest().authenticationFailed(context.getMostRecentAuthenticationToken())));
        } else {
            this.writeAuthToContext(context, authentication, listener);
        }
    }

    void writeAuthToContext(Authenticator.Context context, Authentication authentication, ActionListener<Authentication> listener) {
        try {
            this.authenticationSerializer.writeToContext(authentication, context.getThreadContext());
            context.getRequest().authenticationSuccess(authentication);
        }
        catch (Exception e) {
            logger.debug(() -> Strings.format((String)"Failed to store authentication [%s] for request [%s]", (Object[])new Object[]{authentication, context.getRequest()}), (Throwable)e);
            ElasticsearchSecurityException ese = context.getRequest().exceptionProcessingRequest(e, context.getMostRecentAuthenticationToken());
            AuthenticatorChain.addMetadata(context, ese);
            listener.onFailure((Exception)((Object)ese));
            return;
        }
        logger.trace("Established authentication [{}] for request [{}]", (Object)authentication, (Object)context.getRequest());
        listener.onResponse((Object)authentication);
    }

    private static void addMetadata(Authenticator.Context context, ElasticsearchSecurityException ese) {
        if (!context.getUnsuccessfulMessages().isEmpty()) {
            ese.addMetadata("es.additional_unsuccessful_credentials", context.getUnsuccessfulMessages());
        }
    }

    private boolean shouldFallbackToAnonymous(Authenticator.Context context) {
        if (!this.isAnonymousUserEnabled) {
            return false;
        }
        if (!context.isAllowAnonymous()) {
            return false;
        }
        return context.getBearerString() == null && context.getApiKeyString() == null;
    }
}

