/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datageneration.matchers.source;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

class MappingTransforms {
    MappingTransforms() {
    }

    public static Map<String, FieldMapping> normalizeMapping(Map<String, Object> map) {
        HashMap<String, FieldMapping> flattened = new HashMap<String, FieldMapping>();
        MappingTransforms.descend(null, map, flattened);
        return flattened;
    }

    private static void descend(String pathFromRoot, Map<String, Object> currentLevel, Map<String, FieldMapping> flattened) {
        for (Map.Entry<String, Object> entry : currentLevel.entrySet()) {
            String pathToField;
            Object object;
            if (entry.getKey().equals("_doc") || entry.getKey().equals("properties")) {
                MappingTransforms.descend(pathFromRoot, (Map)entry.getValue(), flattened);
                continue;
            }
            if (!entry.getKey().equals("fields") && (object = entry.getValue()) instanceof Map) {
                Map map = (Map)object;
                String string = pathToField = pathFromRoot == null ? entry.getKey() : pathFromRoot + "." + entry.getKey();
                if (pathFromRoot != null) {
                    FieldMapping parentMapping = flattened.computeIfAbsent(pathFromRoot, k -> new FieldMapping(new HashMap<String, Object>(), new ArrayList<Map<String, Object>>()));
                    FieldMapping childMapping = flattened.computeIfAbsent(pathToField, k -> new FieldMapping(new HashMap<String, Object>(), new ArrayList<Map<String, Object>>()));
                    childMapping.parentMappingParameters.add(parentMapping.mappingParameters);
                    childMapping.parentMappingParameters.addAll(parentMapping.parentMappingParameters);
                }
                MappingTransforms.descend(pathToField, map, flattened);
                continue;
            }
            pathToField = pathFromRoot == null ? "_doc" : pathFromRoot;
            flattened.computeIfAbsent((String)pathToField, (Function<String, FieldMapping>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$descend$2(java.lang.String ), (Ljava/lang/String;)Lorg/elasticsearch/datageneration/matchers/source/MappingTransforms$FieldMapping;)()).mappingParameters.put(entry.getKey(), entry.getValue());
        }
    }

    private static /* synthetic */ FieldMapping lambda$descend$2(String k) {
        return new FieldMapping(new HashMap<String, Object>(), new ArrayList<Map<String, Object>>());
    }

    record FieldMapping(Map<String, Object> mappingParameters, List<Map<String, Object>> parentMappingParameters) {
    }
}

