/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.deployment;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.ml.inference.deployment.AbstractControlMessagePyTorchAction;
import org.elasticsearch.xpack.ml.inference.deployment.DeploymentManager;
import org.elasticsearch.xpack.ml.inference.pytorch.results.PyTorchResult;
import org.elasticsearch.xpack.ml.inference.pytorch.results.ThreadSettings;

public class ThreadSettingsControlMessagePytorchAction
extends AbstractControlMessagePyTorchAction<ThreadSettings> {
    private final int numAllocationThreads;

    ThreadSettingsControlMessagePytorchAction(String deploymentId, long requestId, int numAllocationThreads, TimeValue timeout, DeploymentManager.ProcessContext processContext, ThreadPool threadPool, ActionListener<ThreadSettings> listener) {
        super(deploymentId, requestId, timeout, processContext, threadPool, listener);
        this.numAllocationThreads = numAllocationThreads;
    }

    @Override
    int controlOrdinal() {
        return AbstractControlMessagePyTorchAction.ControlMessageTypes.AllocationThreads.ordinal();
    }

    @Override
    void writeMessage(XContentBuilder builder) throws IOException {
        builder.field("num_allocations", this.numAllocationThreads);
    }

    @Override
    ThreadSettings getResult(PyTorchResult result) {
        return result.threadSettings();
    }
}

