/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.exponentialhistogram.aggregations.support;

import java.io.IOException;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.index.fielddata.DocValueBits;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.search.aggregations.AggregationErrors;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.xpack.exponentialhistogram.fielddata.ExponentialHistogramValuesReader;
import org.elasticsearch.xpack.exponentialhistogram.fielddata.IndexExponentialHistogramFieldData;
import org.elasticsearch.xpack.exponentialhistogram.fielddata.LeafExponentialHistogramFieldData;

public class ExponentialHistogramValuesSource {

    public static abstract class ExponentialHistogram
    extends ValuesSource {
        public abstract ExponentialHistogramValuesReader getHistogramValues(LeafReaderContext var1) throws IOException;

        public static class Fielddata
        extends ExponentialHistogram {
            protected final IndexExponentialHistogramFieldData indexFieldData;

            public Fielddata(IndexExponentialHistogramFieldData indexFieldData) {
                this.indexFieldData = indexFieldData;
            }

            public SortedBinaryDocValues bytesValues(LeafReaderContext context) {
                return ((LeafExponentialHistogramFieldData)this.indexFieldData.load(context)).getBytesValues();
            }

            public DocValueBits docsWithValue(LeafReaderContext context) throws IOException {
                final ExponentialHistogramValuesReader values = this.getHistogramValues(context);
                return new DocValueBits(this){

                    public boolean advanceExact(int doc) throws IOException {
                        return values.advanceExact(doc);
                    }
                };
            }

            protected Function<Rounding, Rounding.Prepared> roundingPreparer(AggregationContext context) {
                throw AggregationErrors.unsupportedRounding((String)"exponential_histogram");
            }

            @Override
            public ExponentialHistogramValuesReader getHistogramValues(LeafReaderContext context) throws IOException {
                return ((LeafExponentialHistogramFieldData)this.indexFieldData.load(context)).getHistogramValues();
            }
        }
    }
}

