/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.PlanStreamInput;
import org.elasticsearch.xpack.esql.core.util.PlanStreamOutput;

public abstract class Attribute
extends NamedExpression {
    public static final String SYNTHETIC_ATTRIBUTE_NAME_PREFIX = "$$";
    public static final String SYNTHETIC_ATTRIBUTE_NAME_SEPARATOR = "$";
    private static final TransportVersion ESQL_QUALIFIERS_IN_ATTRIBUTES = TransportVersion.fromName((String)"esql_qualifiers_in_attributes");
    private final Nullability nullability;
    private final String qualifier;

    public IdIgnoringWrapper ignoreId() {
        return new IdIgnoringWrapper(this);
    }

    public Attribute(Source source, String name, @Nullable NameId id) {
        this(source, name, Nullability.TRUE, id);
    }

    public Attribute(Source source, @Nullable String qualifier, String name, @Nullable NameId id) {
        this(source, qualifier, name, Nullability.TRUE, id);
    }

    public Attribute(Source source, String name, Nullability nullability, @Nullable NameId id) {
        this(source, null, name, nullability, id);
    }

    public Attribute(Source source, @Nullable String qualifier, String name, Nullability nullability, @Nullable NameId id) {
        this(source, qualifier, name, nullability, id, false);
    }

    public Attribute(Source source, String name, Nullability nullability, @Nullable NameId id, boolean synthetic) {
        this(source, null, name, nullability, id, synthetic);
    }

    public Attribute(Source source, @Nullable String qualifier, String name, Nullability nullability, @Nullable NameId id, boolean synthetic) {
        super(source, name, Collections.emptyList(), id, synthetic);
        this.qualifier = qualifier;
        this.nullability = nullability;
    }

    public static String rawTemporaryName(String ... parts) {
        String name = String.join((CharSequence)SYNTHETIC_ATTRIBUTE_NAME_SEPARATOR, parts);
        return name.isEmpty() || name.startsWith(SYNTHETIC_ATTRIBUTE_NAME_PREFIX) ? name : SYNTHETIC_ATTRIBUTE_NAME_PREFIX + name;
    }

    @Override
    public final Expression replaceChildren(List<Expression> newChildren) {
        throw new UnsupportedOperationException("this type of node doesn't have any children to replace");
    }

    public String qualifier() {
        return this.qualifier;
    }

    public String qualifiedName() {
        return this.qualifier != null ? "[" + this.qualifier + "].[" + this.name() + "]" : this.name();
    }

    @Override
    public Nullability nullable() {
        return this.nullability;
    }

    @Override
    public AttributeSet references() {
        return AttributeSet.of(this);
    }

    public Attribute withLocation(Source source) {
        return Objects.equals(this.source(), source) ? this : this.clone(source, this.qualifier(), this.name(), this.dataType(), this.nullable(), this.id(), this.synthetic());
    }

    public Attribute withQualifier(String qualifier) {
        return Objects.equals(qualifier, qualifier) ? this : this.clone(this.source(), qualifier, this.name(), this.dataType(), this.nullable(), this.id(), this.synthetic());
    }

    public Attribute withName(String name) {
        return Objects.equals(this.name(), name) ? this : this.clone(this.source(), this.qualifier(), name, this.dataType(), this.nullable(), this.id(), this.synthetic());
    }

    public Attribute withNullability(Nullability nullability) {
        return Objects.equals((Object)this.nullable(), (Object)nullability) ? this : this.clone(this.source(), this.qualifier(), this.name(), this.dataType(), nullability, this.id(), this.synthetic());
    }

    public Attribute withId(NameId id) {
        return this.clone(this.source(), this.qualifier(), this.name(), this.dataType(), this.nullable(), id, this.synthetic());
    }

    public Attribute withDataType(DataType type) {
        return Objects.equals((Object)this.dataType(), (Object)type) ? this : this.clone(this.source(), this.qualifier(), this.name(), type, this.nullable(), this.id(), this.synthetic());
    }

    protected abstract Attribute clone(Source var1, String var2, String var3, DataType var4, Nullability var5, NameId var6, boolean var7);

    @Override
    public Attribute toAttribute() {
        return this;
    }

    @Override
    public int semanticHash() {
        return this.id().hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean semanticEquals(Expression other) {
        if (!(other instanceof Attribute)) return false;
        Attribute otherAttr = (Attribute)other;
        if (!this.id().equals(otherAttr.id())) return false;
        return true;
    }

    @Override
    protected Expression canonicalize() {
        return this.clone(Source.EMPTY, this.qualifier(), this.name(), this.dataType(), this.nullability, this.id(), this.synthetic());
    }

    @Override
    protected int innerHashCode(boolean ignoreIds) {
        return Objects.hash(new Object[]{super.innerHashCode(ignoreIds), this.qualifier, this.nullability});
    }

    @Override
    protected boolean innerEquals(Object o, boolean ignoreIds) {
        Attribute other = (Attribute)o;
        return super.innerEquals(other, ignoreIds) && Objects.equals(this.qualifier, other.qualifier) && Objects.equals((Object)this.nullability, (Object)other.nullability);
    }

    @Override
    public String toString() {
        return this.qualifiedName() + "{" + this.label() + (this.synthetic() ? SYNTHETIC_ATTRIBUTE_NAME_SEPARATOR : "") + "}#" + String.valueOf(this.id());
    }

    @Override
    public String nodeString() {
        return this.toString();
    }

    protected abstract String label();

    public static boolean dataTypeEquals(List<Attribute> left, List<Attribute> right) {
        if (left.size() != right.size()) {
            return false;
        }
        for (int i = 0; i < left.size(); ++i) {
            if (left.get(i).dataType() == right.get(i).dataType()) continue;
            return false;
        }
        return true;
    }

    public abstract boolean isDimension();

    public abstract boolean isMetric();

    protected void checkAndSerializeQualifier(PlanStreamOutput out, TransportVersion version) throws IOException {
        if (version.supports(ESQL_QUALIFIERS_IN_ATTRIBUTES)) {
            out.writeOptionalCachedString(this.qualifier());
        } else if (this.qualifier() != null) {
            throw new IllegalArgumentException("Trying to serialize an Attribute with a qualifier to an old node");
        }
    }

    protected static String readQualifier(PlanStreamInput in, TransportVersion version) throws IOException {
        if (version.supports(ESQL_QUALIFIERS_IN_ATTRIBUTES)) {
            return in.readOptionalCachedString();
        }
        return null;
    }

    public record IdIgnoringWrapper(Attribute inner) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Attribute otherAttribute = ((IdIgnoringWrapper)o).inner();
            return this.inner().equals(otherAttribute, true);
        }

        @Override
        public int hashCode() {
            return this.inner().hashCode(true);
        }
    }
}

