/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.action;

import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.datastreams.PromoteDataStreamAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportPromoteDataStreamAction
extends AcknowledgedTransportMasterNodeAction<PromoteDataStreamAction.Request> {
    private static final Logger logger = LogManager.getLogger(TransportPromoteDataStreamAction.class);
    private final SystemIndices systemIndices;
    private final ProjectResolver projectResolver;

    @Inject
    public TransportPromoteDataStreamAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, SystemIndices systemIndices, ProjectResolver projectResolver) {
        super("indices:admin/data_stream/promote", transportService, clusterService, threadPool, actionFilters, PromoteDataStreamAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.systemIndices = systemIndices;
        this.projectResolver = projectResolver;
    }

    protected void masterOperation(Task task, final PromoteDataStreamAction.Request request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) throws Exception {
        this.systemIndices.validateDataStreamAccess(request.getName(), this.threadPool.getThreadContext());
        final ProjectId projectId = this.projectResolver.getProjectId();
        this.submitUnbatchedTask("promote-data-stream [" + request.getName() + "]", new ClusterStateUpdateTask(this, Priority.HIGH, request.masterNodeTimeout()){

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            public ClusterState execute(ClusterState currentState) {
                ProjectMetadata currentProject = currentState.metadata().getProject(projectId);
                ProjectMetadata updatedProject = TransportPromoteDataStreamAction.promoteDataStream(currentProject, request);
                return ClusterState.builder((ClusterState)currentState).putProjectMetadata(updatedProject).build();
            }

            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                listener.onResponse((Object)AcknowledgedResponse.TRUE);
            }
        });
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    static ProjectMetadata promoteDataStream(ProjectMetadata project, PromoteDataStreamAction.Request request) {
        DataStream dataStream = (DataStream)project.dataStreams().get(request.getName());
        if (dataStream == null) {
            throw new ResourceNotFoundException("data stream [" + request.getName() + "] does not exist", new Object[0]);
        }
        TransportPromoteDataStreamAction.warnIfTemplateMissingForDatastream(dataStream, project);
        DataStream promotedDataStream = dataStream.promoteDataStream();
        return ProjectMetadata.builder((ProjectMetadata)project).put(promotedDataStream).build();
    }

    private static void warnIfTemplateMissingForDatastream(DataStream dataStream, ProjectMetadata project) {
        String datastreamName = dataStream.getName();
        boolean matchingIndex = project.templatesV2().values().stream().filter(cit -> cit.getDataStreamTemplate() != null).flatMap(cit -> cit.indexPatterns().stream()).anyMatch(pattern -> Regex.simpleMatch((String)pattern, (String)datastreamName));
        if (!matchingIndex) {
            String warningMessage = Strings.format((String)"Data stream [%s] does not have a matching index template. This will cause rollover to fail until a matching index template is created", (Object[])new Object[]{datastreamName});
            logger.warn(() -> warningMessage);
            HeaderWarning.addWarning((String)warningMessage, (Object[])new Object[0]);
        }
    }

    protected ClusterBlockException checkBlock(PromoteDataStreamAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

