/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.multiproject.action;

import java.io.IOException;
import java.util.HashSet;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class PutProjectAction
extends ActionType<AcknowledgedResponse> {
    public static final PutProjectAction INSTANCE = new PutProjectAction();
    public static final String NAME = "cluster:admin/projects/put";

    public PutProjectAction() {
        super(NAME);
    }

    public String name() {
        return NAME;
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private static final Pattern VALID_PROJECT_ID_PATTERN = Pattern.compile("[-_a-zA-Z0-9]+");
        private final ProjectId projectId;

        public Request(TimeValue masterNodeTimeout, TimeValue ackTimeout, ProjectId projectId) {
            super(masterNodeTimeout, ackTimeout);
            this.projectId = projectId;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.projectId = ProjectId.readFrom((StreamInput)in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.projectId.writeTo(out);
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.projectId == null || this.projectId.id() == null || this.projectId.id().isEmpty()) {
                validationException = ValidateActions.addValidationError((String)"project id is missing", validationException);
            } else if (!VALID_PROJECT_ID_PATTERN.matcher(this.projectId.id()).matches()) {
                validationException = ValidateActions.addValidationError((String)("project id may only contain alpha numeric characters (received [" + String.valueOf(this.projectId) + "])"), (ActionRequestValidationException)validationException);
            }
            return validationException;
        }
    }

    static class PutProjectExecutor
    implements ClusterStateTaskExecutor<PutProjectTask> {
        PutProjectExecutor() {
        }

        public ClusterState execute(ClusterStateTaskExecutor.BatchExecutionContext<PutProjectTask> batchExecutionContext) throws Exception {
            ClusterState initialState = batchExecutionContext.initialState();
            HashSet knownProjectIds = new HashSet(initialState.metadata().projects().keySet());
            ClusterState.Builder stateBuilder = ClusterState.builder((ClusterState)initialState);
            for (ClusterStateTaskExecutor.TaskContext taskContext : batchExecutionContext.taskContexts()) {
                try {
                    Request request = ((PutProjectTask)taskContext.getTask()).request();
                    if (knownProjectIds.contains(request.projectId)) {
                        throw new ResourceAlreadyExistsException("project [{}] already exists", new Object[]{request.projectId});
                    }
                    stateBuilder.putProjectMetadata(ProjectMetadata.builder((ProjectId)request.projectId));
                    knownProjectIds.add(request.projectId);
                    taskContext.success(() -> ((PutProjectTask)taskContext.getTask()).listener.onResponse((Object)AcknowledgedResponse.TRUE));
                }
                catch (Exception e) {
                    taskContext.onFailure(e);
                }
            }
            return stateBuilder.build();
        }
    }

    record PutProjectTask(Request request, ActionListener<AcknowledgedResponse> listener) implements ClusterStateTaskListener
    {
        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }
    }

    public static class TransportPutProjectAction
    extends TransportMasterNodeAction<Request, AcknowledgedResponse> {
        private final MasterServiceTaskQueue<PutProjectTask> putProjectTaskQueue;

        @Inject
        public TransportPutProjectAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters) {
            super(INSTANCE.name(), false, transportService, clusterService, threadPool, actionFilters, Request::new, AcknowledgedResponse::readFrom, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
            this.putProjectTaskQueue = clusterService.createTaskQueue("put-project", Priority.NORMAL, (ClusterStateTaskExecutor)new PutProjectExecutor());
        }

        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        }

        protected void masterOperation(Task task, Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
            this.putProjectTaskQueue.submitTask("put-project " + String.valueOf(request.projectId), (ClusterStateTaskListener)new PutProjectTask(request, listener), request.masterNodeTimeout());
        }
    }
}

