/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.index.mapper.DocumentParsingException;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public class TDigestParser {
    private static final ParseField COUNTS_FIELD = new ParseField("counts", new String[0]);
    private static final ParseField CENTROIDS_FIELD = new ParseField("centroids", new String[0]);
    private static final ParseField SUM_FIELD = new ParseField("sum", new String[0]);
    private static final ParseField MAX_FIELD = new ParseField("max", new String[0]);
    private static final ParseField MIN_FIELD = new ParseField("min", new String[0]);

    public static ParsedTDigest parse(String mappedFieldName, XContentParser parser) throws IOException {
        ArrayList<Double> centroids = null;
        ArrayList<Long> counts = null;
        Double sum = null;
        Double min = null;
        Double max = null;
        XContentParser.Token token = parser.currentToken();
        while (token != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)token, (XContentParser)parser);
            String fieldName = parser.currentName();
            if (fieldName.equals(CENTROIDS_FIELD.getPreferredName())) {
                centroids = TDigestParser.getCentroids(mappedFieldName, parser);
            } else if (fieldName.equals(COUNTS_FIELD.getPreferredName())) {
                counts = TDigestParser.getCounts(mappedFieldName, parser);
            } else if (fieldName.equals(SUM_FIELD.getPreferredName())) {
                token = parser.nextToken();
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_NUMBER, (XContentParser.Token)token, (XContentParser)parser);
                sum = parser.doubleValue();
            } else if (fieldName.equals(MIN_FIELD.getPreferredName())) {
                token = parser.nextToken();
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_NUMBER, (XContentParser.Token)token, (XContentParser)parser);
                min = parser.doubleValue();
            } else if (fieldName.equals(MAX_FIELD.getPreferredName())) {
                token = parser.nextToken();
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_NUMBER, (XContentParser.Token)token, (XContentParser)parser);
                max = parser.doubleValue();
            } else {
                throw new DocumentParsingException(parser.getTokenLocation(), "error parsing field [" + mappedFieldName + "], with unknown parameter [" + fieldName + "]");
            }
            token = parser.nextToken();
        }
        if (centroids == null) {
            throw new DocumentParsingException(parser.getTokenLocation(), "error parsing field [" + mappedFieldName + "], expected field called [" + CENTROIDS_FIELD.getPreferredName() + "]");
        }
        if (counts == null) {
            throw new DocumentParsingException(parser.getTokenLocation(), "error parsing field [" + mappedFieldName + "], expected field called [" + COUNTS_FIELD.getPreferredName() + "]");
        }
        if (centroids.size() != counts.size()) {
            throw new DocumentParsingException(parser.getTokenLocation(), "error parsing field [" + mappedFieldName + "], expected same length from [" + CENTROIDS_FIELD.getPreferredName() + "] and [" + COUNTS_FIELD.getPreferredName() + "] but got [" + centroids.size() + " != " + counts.size() + "]");
        }
        if (centroids.isEmpty()) {
            sum = 0.0;
            min = null;
            max = null;
        }
        return new ParsedTDigest(centroids, (List<Long>)counts, sum, min, max);
    }

    private static ArrayList<Long> getCounts(String mappedFieldName, XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)token, (XContentParser)parser);
        ArrayList<Long> counts = new ArrayList<Long>();
        token = parser.nextToken();
        while (token != XContentParser.Token.END_ARRAY) {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_NUMBER, (XContentParser.Token)token, (XContentParser)parser);
            long count = parser.longValue();
            if (count < 0L) {
                throw new DocumentParsingException(parser.getTokenLocation(), "error parsing field [" + mappedFieldName + "], [" + String.valueOf(COUNTS_FIELD) + "] elements must be >= 0 but got " + count);
            }
            counts.add(count);
            token = parser.nextToken();
        }
        return counts;
    }

    private static ArrayList<Double> getCentroids(String mappedFieldName, XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)token, (XContentParser)parser);
        ArrayList<Double> centroids = new ArrayList<Double>();
        token = parser.nextToken();
        double previousVal = -1.7976931348623157E308;
        while (token != XContentParser.Token.END_ARRAY) {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_NUMBER, (XContentParser.Token)token, (XContentParser)parser);
            double val = parser.doubleValue();
            if (val < previousVal) {
                throw new DocumentParsingException(parser.getTokenLocation(), "error parsing field [" + mappedFieldName + "], [" + String.valueOf(CENTROIDS_FIELD) + "] centroids must be in increasing order, got [" + val + "] but previous value was [" + previousVal + "]");
            }
            centroids.add(val);
            previousVal = val;
            token = parser.nextToken();
        }
        return centroids;
    }

    public record ParsedTDigest(List<Double> centroids, List<Long> counts, Double sum, Double min, Double max) {
        private final Double sum;
        private final Double min;
        private final Double max;

        public Double max() {
            if (this.max != null) {
                return this.max;
            }
            if (this.centroids != null && !this.centroids.isEmpty()) {
                return this.centroids.get(this.centroids.size() - 1);
            }
            return Double.NaN;
        }

        public Double min() {
            if (this.min != null) {
                return this.min;
            }
            if (this.centroids != null && !this.centroids.isEmpty()) {
                return this.centroids.get(0);
            }
            return Double.NaN;
        }

        public Double sum() {
            if (this.sum != null) {
                return this.sum;
            }
            if (this.centroids != null && !this.centroids.isEmpty()) {
                double observedSum = 0.0;
                for (int i = 0; i < this.centroids.size(); ++i) {
                    observedSum += this.centroids.get(i) * (double)this.counts.get(i).longValue();
                }
                return observedSum;
            }
            return Double.NaN;
        }

        public Long count() {
            if (this.counts != null && !this.counts.isEmpty()) {
                long observedCount = 0L;
                for (Long count : this.counts) {
                    observedCount += count.longValue();
                }
                return observedCount;
            }
            return 0L;
        }
    }
}

