/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.geogrid;

import java.util.function.LongConsumer;
import org.apache.lucene.search.LongValues;
import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.geometry.utils.Geohash;
import org.elasticsearch.index.fielddata.GeoPointValues;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.SortedNumericLongValues;
import org.elasticsearch.search.aggregations.bucket.geogrid.CellIdSource;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoHashBoundedPredicate;
import org.elasticsearch.search.aggregations.support.ValuesSource;

public class GeoHashCellIdSource
extends CellIdSource {
    public GeoHashCellIdSource(ValuesSource.GeoPoint valuesSource, int precision, GeoBoundingBox geoBoundingBox, LongConsumer circuitBreakerConsumer) {
        super(valuesSource, precision, geoBoundingBox, circuitBreakerConsumer);
    }

    @Override
    protected LongValues unboundedCellSingleValue(GeoPointValues values) {
        return new CellIdSource.CellSingleValue(this, values, this.precision()){

            @Override
            protected boolean advance(GeoPoint target) {
                this.value = Geohash.longEncode((double)target.getLon(), (double)target.getLat(), (int)this.precision);
                return true;
            }
        };
    }

    @Override
    protected LongValues boundedCellSingleValue(GeoPointValues values, GeoBoundingBox boundingBox) {
        final GeoHashBoundedPredicate predicate = new GeoHashBoundedPredicate(this.precision(), boundingBox);
        return new CellIdSource.CellSingleValue(values, this.precision()){

            @Override
            protected boolean advance(GeoPoint target) {
                String hash = Geohash.stringEncode((double)target.getLon(), (double)target.getLat(), (int)this.precision);
                if (GeoHashCellIdSource.this.pointInBounds(target.getLon(), target.getLat()) || predicate.validHash(hash)) {
                    this.value = Geohash.longEncode((String)hash);
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    protected SortedNumericLongValues unboundedCellMultiValues(MultiGeoPointValues values) {
        return new CellIdSource.CellMultiValues(this, values, this.precision(), this.circuitBreakerConsumer){

            @Override
            protected int advanceValue(GeoPoint target, int valuesIdx) {
                this.values[valuesIdx] = Geohash.longEncode((double)target.getLon(), (double)target.getLat(), (int)this.precision);
                return valuesIdx + 1;
            }
        };
    }

    @Override
    protected SortedNumericLongValues boundedCellMultiValues(MultiGeoPointValues values, GeoBoundingBox boundingBox) {
        final GeoHashBoundedPredicate predicate = new GeoHashBoundedPredicate(this.precision(), boundingBox);
        return new CellIdSource.CellMultiValues(values, this.precision(), this.circuitBreakerConsumer){

            @Override
            protected int advanceValue(GeoPoint target, int valuesIdx) {
                String hash = Geohash.stringEncode((double)target.getLon(), (double)target.getLat(), (int)this.precision);
                if (GeoHashCellIdSource.this.pointInBounds(target.getLon(), target.getLat()) || predicate.validHash(hash)) {
                    this.values[valuesIdx] = Geohash.longEncode((String)hash);
                    return valuesIdx + 1;
                }
                return valuesIdx;
            }
        };
    }
}

