/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.cat;

import java.util.List;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequestParameters;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Table;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.indices.breaker.CircuitBreakerStats;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestResponseListener;
import org.elasticsearch.rest.action.cat.AbstractCatAction;
import org.elasticsearch.rest.action.cat.RestTable;

@ServerlessScope(value=Scope.INTERNAL)
public class RestCatCircuitBreakerAction
extends AbstractCatAction {
    private static final Set<String> RESPONSE_PARAMS = Sets.addToCopy(AbstractCatAction.RESPONSE_PARAMS, "circuit_breaker_patterns");

    @Override
    public String getName() {
        return "cat_circuitbreaker_action";
    }

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_cat/circuit_breaker"), new RestHandler.Route(RestRequest.Method.GET, "/_cat/circuit_breaker/{circuit_breaker_patterns}"));
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/circuit_breaker\n");
        sb.append("/_cat/circuit_breaker/{circuit_breaker_patterns}\n");
    }

    @Override
    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest request, NodeClient client) {
        NodesStatsRequest nodesStatsRequest = new NodesStatsRequest();
        nodesStatsRequest.clear().addMetric(NodesStatsRequestParameters.Metric.BREAKER);
        return channel -> client.admin().cluster().nodesStats(nodesStatsRequest, (ActionListener<NodesStatsResponse>)new RestResponseListener<NodesStatsResponse>(channel){

            @Override
            public RestResponse buildResponse(NodesStatsResponse nodesStatsResponse) throws Exception {
                RestResponse response = RestTable.buildResponse(RestCatCircuitBreakerAction.this.buildTable(request, nodesStatsResponse), this.channel);
                if (!nodesStatsResponse.failures().isEmpty()) {
                    response.addHeader("Warning", "Partial success, missing info from " + nodesStatsResponse.failures().size() + " nodes.");
                }
                return response;
            }
        });
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeaders();
        table.addCell("node_id", "default:true;alias:id;desc:persistent node id");
        table.addCell("node_name", "default:false;alias:nn;desc:node name");
        table.addCell("breaker", "default:true;alias:br;desc:breaker name");
        table.addCell("limit", "default:true;alias:l;desc:limit size");
        table.addCell("limit_bytes", "default:false;alias:lb;desc:limit size in bytes");
        table.addCell("estimated", "default:true;alias:e;desc:estimated size");
        table.addCell("estimated_bytes", "default:false;alias:eb;desc:estimated size in bytes");
        table.addCell("tripped", "default:true;alias:t;desc:tripped count");
        table.addCell("overhead", "default:false;alias:o;desc:overhead");
        table.endHeaders();
        return table;
    }

    private Table buildTable(RestRequest request, NodesStatsResponse nodesStatsResponse) {
        Table table = this.getTableWithHeader(request);
        String[] circuitBreakers = request.paramAsStringArray("circuit_breaker_patterns", new String[]{"*"});
        for (NodeStats nodeStats : nodesStatsResponse.getNodes()) {
            if (nodeStats.getBreaker() == null) continue;
            for (CircuitBreakerStats circuitBreakerStats : nodeStats.getBreaker().getAllStats()) {
                if (!Regex.simpleMatch(circuitBreakers, circuitBreakerStats.getName())) continue;
                table.startRow();
                table.addCell(nodeStats.getNode().getId());
                table.addCell(nodeStats.getNode().getName());
                table.addCell(circuitBreakerStats.getName());
                table.addCell(ByteSizeValue.ofBytes(circuitBreakerStats.getLimit()));
                table.addCell(circuitBreakerStats.getLimit());
                table.addCell(ByteSizeValue.ofBytes(circuitBreakerStats.getEstimated()));
                table.addCell(circuitBreakerStats.getEstimated());
                table.addCell(circuitBreakerStats.getTrippedCount());
                table.addCell(circuitBreakerStats.getOverhead());
                table.endRow();
            }
        }
        for (FailedNodeException errors : nodesStatsResponse.failures()) {
            table.startRow();
            table.addCell(errors.nodeId());
            table.addCell("N/A");
            table.addCell(errors.getMessage());
            table.addCell("N/A");
            table.addCell("N/A");
            table.addCell("N/A");
            table.addCell("N/A");
            table.addCell("N/A");
            table.addCell("N/A");
            table.endRow();
        }
        return table;
    }
}

