/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.inference;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;

public record InferenceString(String value, DataType dataType) {
    private static final EnumSet<DataType> IMAGE_TYPES = EnumSet.of(DataType.IMAGE_BASE64);

    public InferenceString(String value, DataType dataType) {
        this.value = Objects.requireNonNull(value);
        this.dataType = Objects.requireNonNull(dataType);
    }

    public boolean isImage() {
        return IMAGE_TYPES.contains((Object)this.dataType);
    }

    public boolean isText() {
        return DataType.TEXT.equals((Object)this.dataType);
    }

    public static List<String> toStringList(List<InferenceString> inferenceStrings) {
        return inferenceStrings.stream().map(i -> {
            assert (i.isText()) : "Non-text input passed to InferenceString.toStringList";
            return i.value();
        }).toList();
    }

    public static enum DataType {
        TEXT,
        IMAGE_BASE64;

    }
}

