/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.tsdb;

import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.elasticsearch.common.util.ByteUtils;
import org.elasticsearch.index.codec.ForUtil;

public final class DocValuesForUtil {
    private static final int BITS_IN_FOUR_BYTES = 32;
    private static final int BITS_IN_FIVE_BYTES = 40;
    private static final int BITS_IN_SIX_BYTES = 48;
    private static final int BITS_IN_SEVEN_BYTES = 56;
    private final int blockSize;
    private final byte[] encoded;

    public DocValuesForUtil(int numericBlockSize) {
        assert (numericBlockSize >= 128 && (numericBlockSize & 0x7F) == 0) : "expected to get a block size that a multiple of 128, got " + numericBlockSize;
        this.blockSize = numericBlockSize;
        this.encoded = new byte[numericBlockSize * 8];
    }

    public static int roundBits(int bitsPerValue) {
        if (bitsPerValue > 24 && bitsPerValue <= 32) {
            return 32;
        }
        if (bitsPerValue > 32 && bitsPerValue <= 40) {
            return 40;
        }
        if (bitsPerValue > 40 && bitsPerValue <= 48) {
            return 48;
        }
        if (bitsPerValue > 48 && bitsPerValue <= 56) {
            return 56;
        }
        if (bitsPerValue > 56) {
            return 64;
        }
        return bitsPerValue;
    }

    public void encode(long[] in, int bitsPerValue, DataOutput out) throws IOException {
        if (bitsPerValue <= 24) {
            ForUtil.encode(in, bitsPerValue, out);
        } else if (bitsPerValue <= 32) {
            for (int k = 0; k < this.blockSize >> 7; ++k) {
                DocValuesForUtil.collapse32(in, k * 128);
                for (int i = 0; i < 64; ++i) {
                    out.writeLong(in[k * 128 + i]);
                }
            }
        } else if (bitsPerValue == 40 || bitsPerValue == 48 || bitsPerValue == 56) {
            this.encodeFiveSixOrSevenBytesPerValue(in, bitsPerValue, out);
        } else {
            assert (bitsPerValue > 56) : "bitsPerValue must be greater than 56 but was [" + bitsPerValue + "]";
            for (long l : in) {
                out.writeLong(l);
            }
        }
    }

    private void encodeFiveSixOrSevenBytesPerValue(long[] in, int bitsPerValue, DataOutput out) throws IOException {
        int bytesPerValue = bitsPerValue / 8;
        for (int i = 0; i < in.length; ++i) {
            ByteUtils.writeLongLE(in[i], this.encoded, i * bytesPerValue);
        }
        out.writeBytes(this.encoded, bytesPerValue * in.length);
    }

    public void decode(int bitsPerValue, DataInput in, long[] out) throws IOException {
        if (bitsPerValue <= 24) {
            ForUtil.decode(bitsPerValue, in, out);
        } else if (bitsPerValue <= 32) {
            for (int k = 0; k < this.blockSize >> 7; ++k) {
                in.readLongs(out, k * 128, 64);
                DocValuesForUtil.expand32(out, k * 128);
            }
        } else if (bitsPerValue == 40 || bitsPerValue == 48 || bitsPerValue == 56) {
            this.decodeFiveSixOrSevenBytesPerValue(bitsPerValue, in, out);
        } else {
            assert (bitsPerValue > 56) : "bitsPerValue must be greater than 56 but was [" + bitsPerValue + "]";
            in.readLongs(out, 0, this.blockSize);
        }
    }

    private void decodeFiveSixOrSevenBytesPerValue(int bitsPerValue, DataInput in, long[] out) throws IOException {
        int bytesPerValue = bitsPerValue / 8;
        long mask = (1L << bitsPerValue) - 1L;
        byte[] buffer = new byte[bytesPerValue * this.blockSize + 8 - bytesPerValue];
        in.readBytes(buffer, 0, bytesPerValue * this.blockSize);
        for (int i = 0; i < this.blockSize; ++i) {
            out[i] = ByteUtils.readLongLE(buffer, i * bytesPerValue) & mask;
        }
    }

    private static void collapse32(long[] arr, int offset) {
        for (int i = 0; i < 64; ++i) {
            arr[i + offset] = arr[i + offset] << 32 | arr[64 + i + offset];
        }
    }

    private static void expand32(long[] arr, int offset) {
        for (int i = 0; i < 64; ++i) {
            long l = arr[i + offset];
            arr[i + offset] = l >>> 32;
            arr[64 + i + offset] = l & 0xFFFFFFFFL;
        }
    }
}

