/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.sampling;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.ingest.SamplingService;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.AbstractTransportRequest;
import org.elasticsearch.xcontent.ToXContent;

public class GetSampleAction
extends ActionType<Response> {
    public static final GetSampleAction INSTANCE = new GetSampleAction();
    public static final String NAME = "indices:admin/sample";

    private GetSampleAction() {
        super(NAME);
    }

    public static class NodeResponse
    extends BaseNodeResponse {
        private final List<SamplingService.RawDocument> sample;

        protected NodeResponse(StreamInput in) throws IOException {
            super(in);
            this.sample = in.readCollectionAsList(SamplingService.RawDocument::new);
        }

        protected NodeResponse(DiscoveryNode node, List<SamplingService.RawDocument> sample) {
            super(node);
            this.sample = sample;
        }

        public List<SamplingService.RawDocument> getSample() {
            return this.sample;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeCollection(this.sample);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeResponse other = (NodeResponse)o;
            return this.getNode().equals(other.getNode()) && this.sample.equals(other.sample);
        }

        public int hashCode() {
            return Objects.hash(this.getNode(), this.sample);
        }
    }

    public static class Response
    extends BaseNodesResponse<NodeResponse>
    implements Writeable,
    ChunkedToXContent {
        final int maxSize;

        public Response(StreamInput in) throws IOException {
            super(in);
            this.maxSize = in.readInt();
        }

        public Response(ClusterName clusterName, List<NodeResponse> nodes, List<FailedNodeException> failures, int maxSize) {
            super(clusterName, nodes, failures);
            this.maxSize = maxSize;
        }

        public List<SamplingService.RawDocument> getSample() {
            return this.getNodes().stream().map(n -> n.sample).filter(Objects::nonNull).flatMap(Collection::stream).limit(this.maxSize).toList();
        }

        @Override
        protected List<NodeResponse> readNodesFrom(StreamInput in) throws IOException {
            return in.readCollectionAsList(NodeResponse::new);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeInt(this.maxSize);
        }

        @Override
        protected void writeNodesTo(StreamOutput out, List<NodeResponse> nodes) throws IOException {
            out.writeCollection(nodes);
        }

        @Override
        public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
            return Iterators.concat(ChunkedToXContentHelper.chunk((builder, p) -> builder.startObject().startArray("sample")), Iterators.flatMap(this.getSample().iterator(), rawDocument -> Iterators.single((builder, params1) -> {
                builder.startObject();
                builder.field("index", rawDocument.indexName());
                Map<String, Object> sourceAsMap = XContentHelper.convertToMap(rawDocument.contentType().xContent(), rawDocument.source(), 0, rawDocument.source().length, false);
                builder.field("source", sourceAsMap);
                builder.endObject();
                return builder;
            })), ChunkedToXContentHelper.chunk((builder, p) -> builder.endArray().endObject()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response other = (Response)o;
            return Objects.equals(this.getNodes(), other.getNodes()) && this.maxSize == other.maxSize;
        }

        public int hashCode() {
            return Objects.hash(this.getNodes(), this.maxSize);
        }
    }

    public static class NodeRequest
    extends AbstractTransportRequest
    implements IndicesRequest {
        private final String index;

        public NodeRequest(String index) {
            this.index = index;
        }

        public NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.index = in.readString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.index);
        }

        @Override
        public boolean includeDataStreams() {
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeRequest other = (NodeRequest)o;
            return Objects.equals(this.index, other.index);
        }

        public int hashCode() {
            return Objects.hash(this.index);
        }

        @Override
        public String[] indices() {
            return new String[]{this.index};
        }

        @Override
        public IndicesOptions indicesOptions() {
            return IndicesOptions.STRICT_SINGLE_INDEX_NO_EXPAND_FORBID_CLOSED_ALLOW_SELECTORS;
        }
    }

    public static class Request
    extends BaseNodesRequest
    implements IndicesRequest.Replaceable {
        private String indexName;

        public Request(String indexName) {
            super((String[])null);
            this.indexName = indexName;
        }

        @Override
        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, "get samples", parentTaskId, headers);
        }

        @Override
        public boolean includeDataStreams() {
            return true;
        }

        @Override
        public ActionRequestValidationException validate() {
            if (this.indexName.contains("*")) {
                return (ActionRequestValidationException)new ActionRequestValidationException().addValidationError("Wildcards are not supported, but found [" + this.indexName + "]");
            }
            return null;
        }

        @Override
        public IndicesRequest indices(String ... indices) {
            assert (indices.length == 1) : "GetSampleAction only supports a single index name";
            this.indexName = indices[0];
            return this;
        }

        @Override
        public String[] indices() {
            return new String[]{this.indexName};
        }

        @Override
        public IndicesOptions indicesOptions() {
            return IndicesOptions.STRICT_SINGLE_INDEX_NO_EXPAND_FORBID_CLOSED_ALLOW_SELECTORS;
        }
    }
}

