/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;

public record ResolvedIndexExpression(String original, LocalExpressions localExpressions, Set<String> remoteExpressions) implements Writeable
{
    private static final Logger logger = LogManager.getLogger(ResolvedIndexExpression.class);

    public ResolvedIndexExpression(StreamInput in) throws IOException {
        this(in.readString(), new LocalExpressions(in), in.readCollectionAsImmutableSet(StreamInput::readString));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.original);
        this.localExpressions.writeTo(out);
        out.writeStringCollection(this.remoteExpressions);
    }

    public static final class LocalExpressions
    implements Writeable {
        private final Set<String> indices;
        private final LocalIndexResolutionResult localIndexResolutionResult;
        @Nullable
        private ElasticsearchException exception;
        public static final LocalExpressions NONE = new LocalExpressions(Set.of(), LocalIndexResolutionResult.NONE, null);

        public LocalExpressions(Set<String> indices, LocalIndexResolutionResult localIndexResolutionResult, @Nullable ElasticsearchException exception) {
            assert (localIndexResolutionResult != LocalIndexResolutionResult.SUCCESS || exception == null) : "If the local resolution result is SUCCESS, exception must be null";
            this.indices = indices;
            this.localIndexResolutionResult = localIndexResolutionResult;
            this.exception = exception;
        }

        public Set<String> indices() {
            return this.indices;
        }

        public LocalIndexResolutionResult localIndexResolutionResult() {
            return this.localIndexResolutionResult;
        }

        @Nullable
        public ElasticsearchException exception() {
            return this.exception;
        }

        public void setExceptionIfUnset(ElasticsearchException exception) {
            assert (this.localIndexResolutionResult != LocalIndexResolutionResult.SUCCESS) : "If the local resolution result is SUCCESS, exception must be null";
            Objects.requireNonNull(exception);
            if (this.exception == null) {
                this.exception = exception;
            } else if (!Objects.equals(this.exception.getMessage(), exception.getMessage())) {
                String message = "Exception is already set: " + exception.getMessage();
                logger.debug(message);
                assert (false) : message;
            }
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            LocalExpressions that = (LocalExpressions)obj;
            return Objects.equals(this.indices, that.indices) && Objects.equals((Object)this.localIndexResolutionResult, (Object)that.localIndexResolutionResult) && Objects.equals(this.exception, that.exception);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.indices, this.localIndexResolutionResult, this.exception});
        }

        public String toString() {
            return "LocalExpressions[indices=" + String.valueOf(this.indices) + ", localIndexResolutionResult=" + String.valueOf((Object)this.localIndexResolutionResult) + ", exception=" + String.valueOf(this.exception) + "]";
        }

        public LocalExpressions(StreamInput in) throws IOException {
            this(in.readCollectionAsImmutableSet(StreamInput::readString), in.readEnum(LocalIndexResolutionResult.class), (ElasticsearchException)ElasticsearchException.readException(in));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringCollection(this.indices);
            out.writeEnum(this.localIndexResolutionResult);
            ElasticsearchException.writeException(this.exception, out);
        }
    }

    public static enum LocalIndexResolutionResult {
        NONE,
        SUCCESS,
        CONCRETE_RESOURCE_NOT_VISIBLE,
        CONCRETE_RESOURCE_UNAUTHORIZED;

    }
}

