/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene.read;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DocVector;
import org.elasticsearch.compute.lucene.read.ComputeBlockLoaderFactory;
import org.elasticsearch.compute.lucene.read.ValuesReader;
import org.elasticsearch.compute.lucene.read.ValuesSourceReaderOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fieldvisitor.StoredFieldLoader;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.BlockLoaderStoredFieldsFromLeafLoader;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.search.fetch.StoredFieldsSpec;

class ValuesFromManyReader
extends ValuesReader {
    private static final Logger log = LogManager.getLogger(ValuesFromManyReader.class);
    private final int[] forwards;
    private final int[] backwards;
    private final BlockLoader.RowStrideReader[] rowStride;
    private BlockLoaderStoredFieldsFromLeafLoader storedFields;

    ValuesFromManyReader(ValuesSourceReaderOperator operator, DocVector docs) {
        super(operator, docs);
        this.forwards = docs.shardSegmentDocMapForwards();
        this.backwards = docs.shardSegmentDocMapBackwards();
        this.rowStride = new BlockLoader.RowStrideReader[operator.fields.length];
        log.debug("initializing {} positions", new Object[]{docs.getPositionCount()});
    }

    @Override
    protected void load(Block[] target, int offset) throws IOException {
        try (Run run = new Run(target);){
            run.run(offset);
        }
    }

    private void fieldsMoved(LeafReaderContext ctx, int shard) throws IOException {
        StoredFieldsSpec storedFieldsSpec = StoredFieldsSpec.NO_REQUIREMENTS;
        for (int f = 0; f < this.operator.fields.length; ++f) {
            ValuesSourceReaderOperator.FieldWork field = this.operator.fields[f];
            this.rowStride[f] = field.rowStride(ctx);
            storedFieldsSpec = storedFieldsSpec.merge(field.loader.rowStrideStoredFieldSpec());
        }
        SourceLoader sourceLoader = null;
        if (storedFieldsSpec.requiresSource()) {
            sourceLoader = this.operator.shardContexts.get(shard).newSourceLoader().apply(storedFieldsSpec.sourcePaths());
            storedFieldsSpec = storedFieldsSpec.merge(new StoredFieldsSpec(true, false, sourceLoader.requiredStoredFields()));
        }
        this.storedFields = new BlockLoaderStoredFieldsFromLeafLoader(StoredFieldLoader.fromSpec((StoredFieldsSpec)storedFieldsSpec).getLoader(ctx, null), sourceLoader != null ? sourceLoader.leaf(ctx.reader(), null) : null);
        if (!storedFieldsSpec.equals((Object)StoredFieldsSpec.NO_REQUIREMENTS)) {
            this.operator.trackStoredFields(storedFieldsSpec, false);
        }
    }

    class Run
    implements Releasable {
        private final Block[] target;
        private final List<Map<Integer, BlockBuilderAndLoader>> buildersAndLoaders;
        private final Block.Builder[] fieldTypeBuilders;

        Run(Block[] target) {
            this.target = target;
            this.buildersAndLoaders = new ArrayList<Map<Integer, BlockBuilderAndLoader>>(target.length);
            this.fieldTypeBuilders = new Block.Builder[target.length];
        }

        void run(int offset) throws IOException {
            assert (offset == 0);
            for (int f = 0; f < ValuesFromManyReader.this.operator.fields.length; ++f) {
                this.fieldTypeBuilders[f] = ValuesFromManyReader.this.operator.fields[f].info.type().newBlockBuilder(ValuesFromManyReader.this.docs.getPositionCount(), ValuesFromManyReader.this.operator.blockFactory);
                this.buildersAndLoaders.add(new HashMap());
            }
            try (ComputeBlockLoaderFactory loaderBlockFactory = new ComputeBlockLoaderFactory(ValuesFromManyReader.this.operator.blockFactory);){
                int p = ValuesFromManyReader.this.forwards[offset];
                int shard = ValuesFromManyReader.this.docs.shards().getInt(p);
                int segment = ValuesFromManyReader.this.docs.segments().getInt(p);
                int firstDoc = ValuesFromManyReader.this.docs.docs().getInt(p);
                ValuesFromManyReader.this.operator.positionFieldWork(shard, segment, firstDoc);
                LeafReaderContext ctx = ValuesFromManyReader.this.operator.ctx(shard, segment);
                ValuesFromManyReader.this.fieldsMoved(ctx, shard);
                this.verifyBuilders(loaderBlockFactory, shard);
                this.read(firstDoc, shard);
                long estimated = this.estimatedRamBytesUsed();
                long dangerZoneBytes = Long.MAX_VALUE;
                for (int i = offset + 1; i < ValuesFromManyReader.this.forwards.length && estimated < dangerZoneBytes; ++i) {
                    p = ValuesFromManyReader.this.forwards[i];
                    shard = ValuesFromManyReader.this.docs.shards().getInt(p);
                    boolean changedSegment = ValuesFromManyReader.this.operator.positionFieldWorkDocGuaranteedAscending(shard, segment = ValuesFromManyReader.this.docs.segments().getInt(p));
                    if (changedSegment) {
                        ctx = ValuesFromManyReader.this.operator.ctx(shard, segment);
                        ValuesFromManyReader.this.fieldsMoved(ctx, shard);
                    }
                    this.verifyBuilders(loaderBlockFactory, shard);
                    this.read(ValuesFromManyReader.this.docs.docs().getInt(p), shard);
                    estimated = this.estimatedRamBytesUsed();
                    log.trace("{}: bytes loaded {}/{}", new Object[]{p, estimated, dangerZoneBytes});
                }
                this.buildBlocks();
                if (log.isDebugEnabled()) {
                    long actual = 0L;
                    for (Block b : this.target) {
                        actual += b.ramBytesUsed();
                    }
                    log.debug("loaded {} positions total estimated/actual {}/{} bytes", new Object[]{p, estimated, actual});
                }
            }
        }

        private void buildBlocks() {
            for (int f = 0; f < this.target.length; ++f) {
                for (Map.Entry<Integer, BlockBuilderAndLoader> entry : this.buildersAndLoaders.get(f).entrySet()) {
                    Block.Builder builder = entry.getValue().builder;
                    BlockLoader loader = entry.getValue().loader;
                    Block orig = (Block)loader.convert((BlockLoader.Block)builder.build());
                    try {
                        this.fieldTypeBuilders[f].copyFrom(orig, 0, orig.getPositionCount());
                    }
                    finally {
                        if (orig == null) continue;
                        orig.close();
                    }
                }
                try (Block targetBlock = this.fieldTypeBuilders[f].build();){
                    this.target[f] = targetBlock.filter(ValuesFromManyReader.this.backwards);
                }
                ValuesFromManyReader.this.operator.sanityCheckBlock(ValuesFromManyReader.this.rowStride[f], ValuesFromManyReader.this.backwards.length, this.target[f], f);
            }
            if (this.target[0].getPositionCount() != ValuesFromManyReader.this.docs.getPositionCount()) {
                throw new IllegalStateException("partial pages not yet supported");
            }
        }

        private void verifyBuilders(ComputeBlockLoaderFactory loaderBlockFactory, int shard) {
            for (int f = 0; f < ValuesFromManyReader.this.operator.fields.length; ++f) {
                if (this.buildersAndLoaders.get(f).get(shard) != null) continue;
                this.buildersAndLoaders.get(f).put(shard, new BlockBuilderAndLoader((Block.Builder)ValuesFromManyReader.this.operator.fields[f].loader.builder((BlockLoader.BlockFactory)loaderBlockFactory, ValuesFromManyReader.this.docs.getPositionCount()), ValuesFromManyReader.this.operator.fields[f].loader));
            }
        }

        private void read(int doc, int shard) throws IOException {
            ValuesFromManyReader.this.storedFields.advanceTo(doc);
            for (int f = 0; f < this.buildersAndLoaders.size(); ++f) {
                ValuesFromManyReader.this.rowStride[f].read(doc, (BlockLoader.StoredFields)ValuesFromManyReader.this.storedFields, (BlockLoader.Builder)this.buildersAndLoaders.get((int)f).get((Object)Integer.valueOf((int)shard)).builder);
            }
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable[])this.fieldTypeBuilders);
            for (int f = 0; f < ValuesFromManyReader.this.operator.fields.length; ++f) {
                Releasables.closeExpectNoException((Releasable)Releasables.wrap(this.buildersAndLoaders.get(f).values()));
            }
        }

        private long estimatedRamBytesUsed() {
            return this.buildersAndLoaders.stream().flatMap(e -> e.values().stream()).mapToLong(bl -> bl.builder.estimatedBytes()).sum();
        }
    }

    private record BlockBuilderAndLoader(Block.Builder builder, BlockLoader loader) implements Releasable
    {
        public void close() {
            this.builder.close();
        }
    }
}

