/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.ExponentialHistogramStates;
import org.elasticsearch.compute.aggregation.HistogramMergeExponentialHistogramAggregator;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.ExponentialHistogramBlock;
import org.elasticsearch.compute.data.ExponentialHistogramScratch;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.exponentialhistogram.ExponentialHistogram;

public final class HistogramMergeExponentialHistogramAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("value", ElementType.EXPONENTIAL_HISTOGRAM));
    private final DriverContext driverContext;
    private final ExponentialHistogramStates.SingleState state;
    private final List<Integer> channels;

    public HistogramMergeExponentialHistogramAggregatorFunction(DriverContext driverContext, List<Integer> channels, ExponentialHistogramStates.SingleState state) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
    }

    public static HistogramMergeExponentialHistogramAggregatorFunction create(DriverContext driverContext, List<Integer> channels) {
        return new HistogramMergeExponentialHistogramAggregatorFunction(driverContext, channels, HistogramMergeExponentialHistogramAggregator.initSingle(driverContext));
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page, BooleanVector mask) {
        if (!mask.allFalse()) {
            if (mask.allTrue()) {
                this.addRawInputNotMasked(page);
            } else {
                this.addRawInputMasked(page, mask);
            }
        }
    }

    private void addRawInputMasked(Page page, BooleanVector mask) {
        ExponentialHistogramBlock valueBlock = (ExponentialHistogramBlock)page.getBlock(this.channels.get(0));
        this.addRawBlock(valueBlock, mask);
    }

    private void addRawInputNotMasked(Page page) {
        ExponentialHistogramBlock valueBlock = (ExponentialHistogramBlock)page.getBlock(this.channels.get(0));
        this.addRawBlock(valueBlock);
    }

    private void addRawBlock(ExponentialHistogramBlock valueBlock) {
        ExponentialHistogramScratch valueScratch = new ExponentialHistogramScratch();
        for (int p = 0; p < valueBlock.getPositionCount(); ++p) {
            int valueValueCount = valueBlock.getValueCount(p);
            if (valueValueCount == 0) continue;
            int valueStart = valueBlock.getFirstValueIndex(p);
            int valueEnd = valueStart + valueValueCount;
            for (int valueOffset = valueStart; valueOffset < valueEnd; ++valueOffset) {
                ExponentialHistogram valueValue = valueBlock.getExponentialHistogram(valueOffset, valueScratch);
                HistogramMergeExponentialHistogramAggregator.combine(this.state, valueValue);
            }
        }
    }

    private void addRawBlock(ExponentialHistogramBlock valueBlock, BooleanVector mask) {
        ExponentialHistogramScratch valueScratch = new ExponentialHistogramScratch();
        for (int p = 0; p < valueBlock.getPositionCount(); ++p) {
            int valueValueCount;
            if (!mask.getBoolean(p) || (valueValueCount = valueBlock.getValueCount(p)) == 0) continue;
            int valueStart = valueBlock.getFirstValueIndex(p);
            int valueEnd = valueStart + valueValueCount;
            for (int valueOffset = valueStart; valueOffset < valueEnd; ++valueOffset) {
                ExponentialHistogram valueValue = valueBlock.getExponentialHistogram(valueOffset, valueScratch);
                HistogramMergeExponentialHistogramAggregator.combine(this.state, valueValue);
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + HistogramMergeExponentialHistogramAggregatorFunction.intermediateStateDesc().size());
        Object valueUncast = page.getBlock(this.channels.get(0));
        if (valueUncast.areAllValuesNull()) {
            return;
        }
        ExponentialHistogramBlock value = (ExponentialHistogramBlock)valueUncast;
        assert (value.getPositionCount() == 1);
        ExponentialHistogramScratch valueScratch = new ExponentialHistogramScratch();
        HistogramMergeExponentialHistogramAggregator.combineIntermediate(this.state, value.getExponentialHistogram(value.getFirstValueIndex(0), valueScratch));
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        blocks[offset] = HistogramMergeExponentialHistogramAggregator.evaluateFinal(this.state, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

