/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.literal.interval;

import java.time.Duration;
import java.time.Period;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.ql.ParsingException;
import org.elasticsearch.xpack.ql.QlIllegalArgumentException;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Foldables;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.util.Check;
import org.elasticsearch.xpack.ql.util.StringUtils;
import org.elasticsearch.xpack.sql.expression.literal.interval.Interval;
import org.elasticsearch.xpack.sql.type.SqlDataTypes;

public final class Intervals {
    static final Map<DataType, Parser> PARSERS = new LinkedHashMap<DataType, Parser>();

    private Intervals() {
    }

    public static long inMillis(Literal literal) {
        Object fold = Foldables.valueOf((Expression)literal);
        Check.isTrue((boolean)(fold instanceof Interval), (String)"Expected interval, received [{}]", (Object[])new Object[]{fold});
        Object interval = ((Interval)fold).interval();
        long millis = 0L;
        if (interval instanceof Period) {
            Period p = (Period)interval;
            millis = p.toTotalMonths() * 30L * 24L * 60L * 60L * 1000L;
        } else {
            Duration d = (Duration)interval;
            millis = d.toMillis();
        }
        return millis;
    }

    public static TemporalAmount of(Source source, long duration, TimeUnit unit) {
        try {
            return switch (unit.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Period.ZERO.plusYears(duration);
                case 1 -> Period.ZERO.plusMonths(duration);
                case 2 -> Duration.ZERO.plusDays(duration);
                case 3 -> Duration.ZERO.plusHours(duration);
                case 4 -> Duration.ZERO.plusMinutes(duration);
                case 5 -> Duration.ZERO.plusSeconds(duration);
                case 6 -> Duration.ZERO.plusMillis(duration);
            };
        }
        catch (ArithmeticException ae) {
            throw new ParsingException(source, "Value [{}] cannot be used as it is too large to convert into [{}]s", new Object[]{duration, unit});
        }
    }

    public static DataType intervalType(Source source, TimeUnit leading, TimeUnit trailing) {
        if (trailing == null) {
            return switch (leading.ordinal()) {
                case 0 -> SqlDataTypes.INTERVAL_YEAR;
                case 1 -> SqlDataTypes.INTERVAL_MONTH;
                case 2 -> SqlDataTypes.INTERVAL_DAY;
                case 3 -> SqlDataTypes.INTERVAL_HOUR;
                case 4 -> SqlDataTypes.INTERVAL_MINUTE;
                case 5 -> SqlDataTypes.INTERVAL_SECOND;
                default -> throw new ParsingException(source, "Cannot determine datatype for [{}]", new Object[]{leading});
            };
        }
        if (leading == TimeUnit.YEAR && trailing == TimeUnit.MONTH) {
            return SqlDataTypes.INTERVAL_YEAR_TO_MONTH;
        }
        if (leading == TimeUnit.DAY && trailing == TimeUnit.HOUR) {
            return SqlDataTypes.INTERVAL_DAY_TO_HOUR;
        }
        if (leading == TimeUnit.DAY && trailing == TimeUnit.MINUTE) {
            return SqlDataTypes.INTERVAL_DAY_TO_MINUTE;
        }
        if (leading == TimeUnit.DAY && trailing == TimeUnit.SECOND) {
            return SqlDataTypes.INTERVAL_DAY_TO_SECOND;
        }
        if (leading == TimeUnit.HOUR && trailing == TimeUnit.MINUTE) {
            return SqlDataTypes.INTERVAL_HOUR_TO_MINUTE;
        }
        if (leading == TimeUnit.HOUR && trailing == TimeUnit.SECOND) {
            return SqlDataTypes.INTERVAL_HOUR_TO_SECOND;
        }
        if (leading == TimeUnit.MINUTE && trailing == TimeUnit.SECOND) {
            return SqlDataTypes.INTERVAL_MINUTE_TO_SECOND;
        }
        throw new ParsingException(source, "Cannot determine datatype for combination [{}] [{}]", new Object[]{leading, trailing});
    }

    public static DataType compatibleInterval(DataType left, DataType right) {
        if (left == right) {
            return left;
        }
        if (SqlDataTypes.isYearMonthInterval(left) && SqlDataTypes.isYearMonthInterval(right)) {
            return SqlDataTypes.INTERVAL_YEAR_TO_MONTH;
        }
        if (SqlDataTypes.isDayTimeInterval(left) && SqlDataTypes.isDayTimeInterval(right)) {
            int indexOf;
            int PREFIX = "INTERVAL_".length();
            String lName = left.typeName().toUpperCase(Locale.ROOT).substring(PREFIX);
            String rName = right.typeName().toUpperCase(Locale.ROOT).substring(PREFIX);
            char leading = lName.charAt(0);
            if (rName.charAt(0) < leading) {
                leading = rName.charAt(0);
            }
            if (lName.length() > 6) {
                indexOf = lName.indexOf("_TO_");
                lName = lName.substring(indexOf + 4);
            }
            if (rName.length() > 6) {
                indexOf = rName.indexOf("_TO_");
                rName = rName.substring(indexOf + 4);
            }
            char trailing = lName.charAt(0);
            if (rName.charAt(0) > trailing) {
                trailing = rName.charAt(0);
            }
            return SqlDataTypes.fromTypeName("INTERVAL_" + Intervals.intervalUnit(leading) + "_TO_" + Intervals.intervalUnit(trailing));
        }
        return null;
    }

    private static String intervalUnit(char unitChar) {
        return switch (unitChar) {
            case 'D' -> "DAY";
            case 'H' -> "HOUR";
            case 'M' -> "MINUTE";
            case 'S' -> "SECOND";
            default -> throw new QlIllegalArgumentException("Unknown unit {}", new Object[]{Character.valueOf(unitChar)});
        };
    }

    public static TemporalAmount negate(TemporalAmount interval) {
        return interval instanceof Period ? ((Period)interval).negated() : ((Duration)interval).negated();
    }

    public static TemporalAmount parseInterval(Source source, String value, DataType intervalType) {
        return PARSERS.get(intervalType).parse(source, value);
    }

    static {
        int MAX_MONTH = 11;
        int MAX_HOUR = 23;
        int MAX_MINUTE = 59;
        int MAX_SECOND = 59;
        int MAX_MILLI = 999;
        char DOT = '.';
        char SPACE = ' ';
        char MINUS = '-';
        char COLON = ':';
        PARSERS.put(SqlDataTypes.INTERVAL_YEAR, new ParserBuilder(SqlDataTypes.INTERVAL_YEAR).unit(TimeUnit.YEAR).build());
        PARSERS.put(SqlDataTypes.INTERVAL_MONTH, new ParserBuilder(SqlDataTypes.INTERVAL_MONTH).unit(TimeUnit.MONTH).build());
        PARSERS.put(SqlDataTypes.INTERVAL_DAY, new ParserBuilder(SqlDataTypes.INTERVAL_DAY).unit(TimeUnit.DAY).build());
        PARSERS.put(SqlDataTypes.INTERVAL_HOUR, new ParserBuilder(SqlDataTypes.INTERVAL_HOUR).unit(TimeUnit.HOUR).build());
        PARSERS.put(SqlDataTypes.INTERVAL_MINUTE, new ParserBuilder(SqlDataTypes.INTERVAL_MINUTE).unit(TimeUnit.MINUTE).build());
        PARSERS.put(SqlDataTypes.INTERVAL_SECOND, new ParserBuilder(SqlDataTypes.INTERVAL_SECOND).unit(TimeUnit.SECOND).optional().separator(DOT).unit(TimeUnit.MILLISECOND, MAX_MILLI).build());
        PARSERS.put(SqlDataTypes.INTERVAL_YEAR_TO_MONTH, new ParserBuilder(SqlDataTypes.INTERVAL_YEAR_TO_MONTH).unit(TimeUnit.YEAR).separator(MINUS).unit(TimeUnit.MONTH, MAX_MONTH).build());
        PARSERS.put(SqlDataTypes.INTERVAL_DAY_TO_HOUR, new ParserBuilder(SqlDataTypes.INTERVAL_DAY_TO_HOUR).unit(TimeUnit.DAY).separator(SPACE).unit(TimeUnit.HOUR, MAX_HOUR).build());
        PARSERS.put(SqlDataTypes.INTERVAL_DAY_TO_MINUTE, new ParserBuilder(SqlDataTypes.INTERVAL_DAY_TO_MINUTE).unit(TimeUnit.DAY).separator(SPACE).unit(TimeUnit.HOUR, MAX_HOUR).separator(COLON).unit(TimeUnit.MINUTE, MAX_MINUTE).build());
        PARSERS.put(SqlDataTypes.INTERVAL_DAY_TO_SECOND, new ParserBuilder(SqlDataTypes.INTERVAL_DAY_TO_SECOND).unit(TimeUnit.DAY).separator(SPACE).unit(TimeUnit.HOUR, MAX_HOUR).separator(COLON).unit(TimeUnit.MINUTE, MAX_MINUTE).separator(COLON).unit(TimeUnit.SECOND, MAX_SECOND).optional().separator(DOT).unit(TimeUnit.MILLISECOND, MAX_MILLI).build());
        PARSERS.put(SqlDataTypes.INTERVAL_HOUR_TO_MINUTE, new ParserBuilder(SqlDataTypes.INTERVAL_HOUR_TO_MINUTE).unit(TimeUnit.HOUR).separator(COLON).unit(TimeUnit.MINUTE, MAX_MINUTE).build());
        PARSERS.put(SqlDataTypes.INTERVAL_HOUR_TO_SECOND, new ParserBuilder(SqlDataTypes.INTERVAL_HOUR_TO_SECOND).unit(TimeUnit.HOUR).separator(COLON).unit(TimeUnit.MINUTE, MAX_MINUTE).separator(COLON).unit(TimeUnit.SECOND, MAX_SECOND).optional().separator(DOT).unit(TimeUnit.MILLISECOND, MAX_MILLI).build());
        PARSERS.put(SqlDataTypes.INTERVAL_MINUTE_TO_SECOND, new ParserBuilder(SqlDataTypes.INTERVAL_MINUTE_TO_SECOND).unit(TimeUnit.MINUTE).separator(COLON).unit(TimeUnit.SECOND, MAX_SECOND).optional().separator(DOT).unit(TimeUnit.MILLISECOND, MAX_MILLI).build());
    }

    public static enum TimeUnit {
        YEAR,
        MONTH,
        DAY,
        HOUR,
        MINUTE,
        SECOND,
        MILLISECOND;

    }

    private static class Parser {
        private static final char PLUS = '+';
        private static final char MINUS = '-';
        private final List<TimeUnit> units;
        private final List<Token> tokens;
        private final String name;

        Parser(List<TimeUnit> units, List<Token> tokens, String name) {
            this.units = units;
            this.tokens = tokens;
            this.name = name;
        }

        TemporalAmount parse(Source source, String string) {
            int unitIndex = 0;
            int startToken = 0;
            int endToken = 0;
            long[] values = new long[this.units.size()];
            boolean negate = false;
            char maybeSign = string.charAt(0);
            if ('+' == maybeSign) {
                startToken = 1;
            } else if ('-' == maybeSign) {
                startToken = 1;
                negate = true;
            }
            for (Token token : this.tokens) {
                if (startToken >= string.length()) {
                    if (token.optional) break;
                    throw new ParsingException(source, this.invalidIntervalMessage(string) + ": incorrect format, expecting {}", new Object[]{Strings.collectionToDelimitedString(this.tokens, (String)"")});
                }
                if (token.ch != '\u0000') {
                    char found = string.charAt(startToken);
                    if (found != token.ch) {
                        throw new ParsingException(source, this.invalidIntervalMessage(string) + ": expected [{}] (at [{}]) but found [{}]", new Object[]{Character.valueOf(token.ch), startToken, Character.valueOf(found)});
                    }
                    ++startToken;
                    continue;
                }
                for (endToken = startToken; endToken < string.length() && Character.isDigit(string.charAt(endToken)); ++endToken) {
                }
                if (endToken == startToken) {
                    throw new ParsingException(source, this.invalidIntervalMessage(string) + ": expected digit (at [{}]) but found [{}]", new Object[]{endToken, Character.valueOf(string.charAt(endToken))});
                }
                String number = string.substring(startToken, endToken);
                try {
                    long v = StringUtils.parseLong((String)number);
                    if (token.maxValue > 0 && v > (long)token.maxValue) {
                        throw new ParsingException(source, this.invalidIntervalMessage(string) + ": [{}] unit has illegal value [{}], expected a positive number up to [{}]", new Object[]{this.units.get(unitIndex).name(), v, token.maxValue});
                    }
                    if (v < 0L) {
                        throw new ParsingException(source, this.invalidIntervalMessage(string) + ": negative value [{}] not allowed (negate the entire interval instead)", new Object[]{v});
                    }
                    if (this.units.get(unitIndex) == TimeUnit.MILLISECOND && number.length() < 3) {
                        v *= number.length() < 2 ? 100L : 10L;
                    }
                    values[unitIndex++] = v;
                }
                catch (QlIllegalArgumentException siae) {
                    throw new ParsingException(source, this.invalidIntervalMessage(string), new Object[]{siae.getMessage()});
                }
                startToken = endToken;
            }
            if (endToken <= string.length() - 1) {
                throw new ParsingException(source, this.invalidIntervalMessage(string) + ": unexpected trailing characters found [{}]", new Object[]{string.substring(endToken)});
            }
            TemporalAmount interval = this.units.get(0) == TimeUnit.YEAR || this.units.get(0) == TimeUnit.MONTH ? Period.ZERO : Duration.ZERO;
            for (int i = 0; i < values.length; ++i) {
                TemporalAmount ta = Intervals.of(source, values[i], this.units.get(i));
                interval = ta instanceof Period ? ((Period)ta).plus(interval) : ((Duration)ta).plus((Duration)interval);
            }
            if (negate) {
                interval = Intervals.negate(interval);
            }
            return interval;
        }

        private String invalidIntervalMessage(String interval) {
            return "Invalid [" + this.name + "] value [" + interval + "]";
        }

        public String toString() {
            return this.name;
        }
    }

    private static class ParserBuilder {
        private final List<TimeUnit> units = new ArrayList<TimeUnit>(10);
        private final List<Token> tokens = new ArrayList<Token>(6);
        private final String name;
        private boolean optional = false;

        ParserBuilder(DataType dataType) {
            this.name = dataType.typeName().replace('_', ' ').toUpperCase(Locale.ROOT);
        }

        ParserBuilder unit(TimeUnit unit) {
            this.unit(unit, 0);
            return this;
        }

        ParserBuilder unit(TimeUnit unit, int maxValue) {
            this.units.add(unit);
            this.tokens.add(new Token('\u0000', maxValue, this.optional));
            return this;
        }

        ParserBuilder separator(char ch) {
            this.tokens.add(new Token(ch, 0, this.optional));
            return this;
        }

        ParserBuilder optional() {
            this.optional = true;
            return this;
        }

        Parser build() {
            return new Parser(this.units, this.tokens, this.name);
        }
    }

    private static class Token {
        private final char ch;
        private final int maxValue;
        private final boolean optional;

        Token(char ch, int maxValue, boolean optional) {
            this.ch = ch;
            this.maxValue = maxValue;
            this.optional = optional;
        }

        public String toString() {
            return this.ch > '\u0000' ? String.valueOf(this.ch) : "[numeric]";
        }
    }
}

