/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.plan.logical;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.eql.plan.logical.KeyedFilter;
import org.elasticsearch.xpack.ql.capabilities.Resolvables;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.util.Check;
import org.elasticsearch.xpack.ql.util.CollectionUtils;

public abstract class AbstractJoin
extends LogicalPlan {
    protected final List<KeyedFilter> queries;

    public AbstractJoin(Source source, List<KeyedFilter> queries, KeyedFilter ... query) {
        super(source, CollectionUtils.combine(queries, (Object[])query));
        this.queries = queries;
    }

    static List<KeyedFilter> asKeyed(List<LogicalPlan> list) {
        ArrayList<KeyedFilter> keyed = new ArrayList<KeyedFilter>(list.size());
        for (LogicalPlan logicalPlan : list) {
            Check.isTrueInternal((boolean)KeyedFilter.class.isInstance(logicalPlan), (String)"Expected a KeyedFilter but received [{}]", (Object[])new Object[]{logicalPlan});
            keyed.add((KeyedFilter)logicalPlan);
        }
        return keyed;
    }

    static KeyedFilter asKeyed(LogicalPlan plan) {
        Check.isTrueInternal((boolean)KeyedFilter.class.isInstance(plan), (String)"Expected a KeyedFilter but received [{}]", (Object[])new Object[]{plan});
        return (KeyedFilter)plan;
    }

    public List<Attribute> output() {
        ArrayList<Attribute> out = new ArrayList<Attribute>();
        for (KeyedFilter query : this.queries) {
            out.addAll(query.output());
        }
        return out;
    }

    public boolean expressionsResolved() {
        return Resolvables.resolved(this.queries);
    }

    public List<KeyedFilter> queries() {
        return this.queries;
    }

    public int hashCode() {
        return Objects.hash(this.queries);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AbstractJoin other = (AbstractJoin)((Object)obj);
        return Objects.equals(this.queries, other.queries);
    }
}

