/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elastic;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.core.inference.chunking.ChunkingSettingsBuilder;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.elastic.completion.ElasticInferenceServiceCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.elastic.densetextembeddings.ElasticInferenceServiceDenseTextEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.elastic.rerank.ElasticInferenceServiceRerankServiceSettings;
import org.elasticsearch.xpack.inference.services.elastic.sparseembeddings.ElasticInferenceServiceSparseEmbeddingsServiceSettings;

public class InternalPreconfiguredEndpoints {
    public static final String DEFAULT_CHAT_COMPLETION_MODEL_ID_V1 = "rainbow-sprinkles";
    public static final String DEFAULT_CHAT_COMPLETION_ENDPOINT_ID_V1 = ".rainbow-sprinkles-elastic";
    public static final String GP_LLM_V2_MODEL_ID = "gp-llm-v2";
    public static final String GP_LLM_V2_CHAT_COMPLETION_ENDPOINT_ID = ".gp-llm-v2-chat_completion";
    public static final String DEFAULT_ELSER_2_MODEL_ID = "elser_model_2";
    public static final String DEFAULT_ELSER_ENDPOINT_ID_V2 = ".elser-2-elastic";
    public static final Integer DENSE_TEXT_EMBEDDINGS_DIMENSIONS = 1024;
    public static final String DEFAULT_MULTILINGUAL_EMBED_MODEL_ID = "jina-embeddings-v3";
    public static final String DEFAULT_MULTILINGUAL_EMBED_ENDPOINT_ID = ".jina-embeddings-v3";
    public static final String DEFAULT_RERANK_MODEL_ID_V1 = "elastic-rerank-v1";
    public static final String DEFAULT_RERANK_ENDPOINT_ID_V1 = ".elastic-rerank-v1";
    private static final ElasticInferenceServiceCompletionServiceSettings COMPLETION_SERVICE_SETTINGS = new ElasticInferenceServiceCompletionServiceSettings("rainbow-sprinkles");
    private static final ElasticInferenceServiceCompletionServiceSettings GP_LLM_V2_COMPLETION_SERVICE_SETTINGS = new ElasticInferenceServiceCompletionServiceSettings("gp-llm-v2");
    private static final ElasticInferenceServiceSparseEmbeddingsServiceSettings SPARSE_EMBEDDINGS_SERVICE_SETTINGS = new ElasticInferenceServiceSparseEmbeddingsServiceSettings("elser_model_2", null);
    private static final ElasticInferenceServiceDenseTextEmbeddingsServiceSettings DENSE_TEXT_EMBEDDINGS_SERVICE_SETTINGS = new ElasticInferenceServiceDenseTextEmbeddingsServiceSettings("jina-embeddings-v3", InternalPreconfiguredEndpoints.defaultDenseTextEmbeddingsSimilarity(), DENSE_TEXT_EMBEDDINGS_DIMENSIONS, null);
    private static final ElasticInferenceServiceRerankServiceSettings RERANK_SERVICE_SETTINGS = new ElasticInferenceServiceRerankServiceSettings("elastic-rerank-v1");
    private static final Map<String, List<MinimalModel>> MODEL_NAME_TO_MINIMAL_MODELS = Map.of("rainbow-sprinkles", List.of(new MinimalModel(new ModelConfigurations(".rainbow-sprinkles-elastic", TaskType.CHAT_COMPLETION, "elastic", (ServiceSettings)COMPLETION_SERVICE_SETTINGS, (ChunkingSettings)ChunkingSettingsBuilder.DEFAULT_SETTINGS), COMPLETION_SERVICE_SETTINGS)), "gp-llm-v2", List.of(new MinimalModel(new ModelConfigurations(".gp-llm-v2-chat_completion", TaskType.CHAT_COMPLETION, "elastic", (ServiceSettings)GP_LLM_V2_COMPLETION_SERVICE_SETTINGS, (ChunkingSettings)ChunkingSettingsBuilder.DEFAULT_SETTINGS), GP_LLM_V2_COMPLETION_SERVICE_SETTINGS)), "elser_model_2", List.of(new MinimalModel(new ModelConfigurations(".elser-2-elastic", TaskType.SPARSE_EMBEDDING, "elastic", (ServiceSettings)SPARSE_EMBEDDINGS_SERVICE_SETTINGS, (ChunkingSettings)ChunkingSettingsBuilder.DEFAULT_SETTINGS), SPARSE_EMBEDDINGS_SERVICE_SETTINGS)), "jina-embeddings-v3", List.of(new MinimalModel(new ModelConfigurations(".jina-embeddings-v3", TaskType.TEXT_EMBEDDING, "elastic", (ServiceSettings)DENSE_TEXT_EMBEDDINGS_SERVICE_SETTINGS, (ChunkingSettings)ChunkingSettingsBuilder.DEFAULT_SETTINGS), DENSE_TEXT_EMBEDDINGS_SERVICE_SETTINGS)), "elastic-rerank-v1", List.of(new MinimalModel(new ModelConfigurations(".elastic-rerank-v1", TaskType.RERANK, "elastic", (ServiceSettings)RERANK_SERVICE_SETTINGS, (ChunkingSettings)ChunkingSettingsBuilder.DEFAULT_SETTINGS), RERANK_SERVICE_SETTINGS)));
    private static final Map<String, MinimalModel> INFERENCE_ID_TO_MINIMAL_MODEL = MODEL_NAME_TO_MINIMAL_MODELS.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream()).collect(Collectors.toMap(m -> m.configurations().getInferenceEntityId(), Function.identity()));
    public static final Set<String> EIS_PRECONFIGURED_ENDPOINT_IDS = Set.copyOf(INFERENCE_ID_TO_MINIMAL_MODEL.keySet());

    public static SimilarityMeasure defaultDenseTextEmbeddingsSimilarity() {
        return SimilarityMeasure.COSINE;
    }

    public static List<MinimalModel> getWithModelName(String modelName) {
        List<MinimalModel> minimalModels = MODEL_NAME_TO_MINIMAL_MODELS.get(modelName);
        if (minimalModels == null) {
            return List.of();
        }
        return minimalModels;
    }

    public static MinimalModel getWithInferenceId(String inferenceId) {
        return INFERENCE_ID_TO_MINIMAL_MODEL.get(inferenceId);
    }

    private InternalPreconfiguredEndpoints() {
    }

    public record MinimalModel(ModelConfigurations configurations, ElasticInferenceServiceRateLimitServiceSettings rateLimitServiceSettings) {
    }
}

