/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.custom;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.custom.CustomRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.custom.CustomServiceEmbeddingType;
import org.elasticsearch.xpack.inference.services.custom.InputTypeTranslator;
import org.elasticsearch.xpack.inference.services.custom.QueryParameters;
import org.elasticsearch.xpack.inference.services.custom.response.CompletionResponseParser;
import org.elasticsearch.xpack.inference.services.custom.response.CustomResponseParser;
import org.elasticsearch.xpack.inference.services.custom.response.DenseEmbeddingResponseParser;
import org.elasticsearch.xpack.inference.services.custom.response.NoopResponseParser;
import org.elasticsearch.xpack.inference.services.custom.response.RerankResponseParser;
import org.elasticsearch.xpack.inference.services.custom.response.SparseEmbeddingResponseParser;
import org.elasticsearch.xpack.inference.services.settings.FilteredXContentObject;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class CustomServiceSettings
extends FilteredXContentObject
implements ServiceSettings,
CustomRateLimitServiceSettings {
    public static final String NAME = "custom_service_settings";
    public static final String URL = "url";
    public static final String BATCH_SIZE = "batch_size";
    public static final String HEADERS = "headers";
    public static final String REQUEST = "request";
    public static final String RESPONSE = "response";
    public static final String JSON_PARSER = "json_parser";
    private static final RateLimitSettings DEFAULT_RATE_LIMIT_SETTINGS = new RateLimitSettings(10000L);
    private static final String RESPONSE_SCOPE = String.join((CharSequence)".", "service_settings", "response");
    private static final int DEFAULT_EMBEDDING_BATCH_SIZE = 10;
    private static final TransportVersion INFERENCE_CUSTOM_SERVICE_ADDED = TransportVersion.fromName((String)"inference_custom_service_added");
    private static final TransportVersion ML_INFERENCE_CUSTOM_SERVICE_REMOVE_ERROR_PARSING = TransportVersion.fromName((String)"ml_inference_custom_service_remove_error_parsing");
    private static final TransportVersion ML_INFERENCE_CUSTOM_SERVICE_EMBEDDING_BATCH_SIZE = TransportVersion.fromName((String)"ml_inference_custom_service_embedding_batch_size");
    private static final TransportVersion ML_INFERENCE_CUSTOM_SERVICE_INPUT_TYPE = TransportVersion.fromName((String)"ml_inference_custom_service_input_type");
    private final TextEmbeddingSettings textEmbeddingSettings;
    private final String url;
    private final Map<String, String> headers;
    private final QueryParameters queryParameters;
    private final String requestContentString;
    private final CustomResponseParser responseJsonParser;
    private final RateLimitSettings rateLimitSettings;
    private final int batchSize;
    private final InputTypeTranslator inputTypeTranslator;

    public static CustomServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context, TaskType taskType) {
        ValidationException validationException = new ValidationException();
        TextEmbeddingSettings textEmbeddingSettings = TextEmbeddingSettings.fromMap(map, taskType, validationException);
        String url = ServiceUtils.extractRequiredString(map, URL, "service_settings", validationException);
        QueryParameters queryParams = QueryParameters.fromMap(map, validationException);
        Map<String, Object> headers = ServiceUtils.extractOptionalMapRemoveNulls(map, HEADERS, validationException);
        Map<String, String> stringHeaders = ServiceUtils.validateMapStringValues(headers, HEADERS, validationException, false);
        String requestContentString = ServiceUtils.extractRequiredString(map, REQUEST, "service_settings", validationException);
        Map<String, Object> responseParserMap = ServiceUtils.extractRequiredMap(map, RESPONSE, "service_settings", validationException);
        Map<String, Object> jsonParserMap = ServiceUtils.extractRequiredMap(Objects.requireNonNullElse(responseParserMap, new HashMap()), JSON_PARSER, RESPONSE_SCOPE, validationException);
        CustomResponseParser responseJsonParser = CustomServiceSettings.extractResponseParser(taskType, jsonParserMap, validationException);
        RateLimitSettings rateLimitSettings = RateLimitSettings.of(map, DEFAULT_RATE_LIMIT_SETTINGS, validationException, "custom", context);
        InputTypeTranslator inputTypeTranslator = InputTypeTranslator.fromMap(map, validationException, "custom");
        Integer batchSize = ServiceUtils.extractOptionalPositiveInteger(map, BATCH_SIZE, "service_settings", validationException);
        if (responseParserMap == null || jsonParserMap == null) {
            throw validationException;
        }
        ServiceUtils.throwIfNotEmptyMap(jsonParserMap, JSON_PARSER, NAME);
        ServiceUtils.throwIfNotEmptyMap(responseParserMap, RESPONSE, NAME);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new CustomServiceSettings(textEmbeddingSettings, url, stringHeaders, queryParams, requestContentString, responseJsonParser, rateLimitSettings, batchSize, inputTypeTranslator);
    }

    public CustomServiceSettings(TextEmbeddingSettings textEmbeddingSettings, String url, @Nullable Map<String, String> headers, @Nullable QueryParameters queryParameters, String requestContentString, CustomResponseParser responseJsonParser, @Nullable RateLimitSettings rateLimitSettings) {
        this(textEmbeddingSettings, url, headers, queryParameters, requestContentString, responseJsonParser, rateLimitSettings, null, InputTypeTranslator.EMPTY_TRANSLATOR);
    }

    public CustomServiceSettings(TextEmbeddingSettings textEmbeddingSettings, String url, @Nullable Map<String, String> headers, @Nullable QueryParameters queryParameters, String requestContentString, CustomResponseParser responseJsonParser, @Nullable RateLimitSettings rateLimitSettings, @Nullable Integer batchSize, InputTypeTranslator inputTypeTranslator) {
        this.textEmbeddingSettings = Objects.requireNonNull(textEmbeddingSettings);
        this.url = Objects.requireNonNull(url);
        this.headers = Collections.unmodifiableMap(Objects.requireNonNullElse(headers, Map.of()));
        this.queryParameters = Objects.requireNonNullElse(queryParameters, QueryParameters.EMPTY);
        this.requestContentString = Objects.requireNonNull(requestContentString);
        this.responseJsonParser = Objects.requireNonNull(responseJsonParser);
        this.rateLimitSettings = Objects.requireNonNullElse(rateLimitSettings, DEFAULT_RATE_LIMIT_SETTINGS);
        this.batchSize = Objects.requireNonNullElse(batchSize, 10);
        this.inputTypeTranslator = Objects.requireNonNull(inputTypeTranslator);
    }

    public CustomServiceSettings(StreamInput in) throws IOException {
        this.textEmbeddingSettings = new TextEmbeddingSettings(in);
        this.url = in.readString();
        this.headers = in.readImmutableMap(StreamInput::readString);
        this.queryParameters = new QueryParameters(in);
        this.requestContentString = in.readString();
        this.responseJsonParser = (CustomResponseParser)in.readNamedWriteable(CustomResponseParser.class);
        this.rateLimitSettings = new RateLimitSettings(in);
        if (!in.getTransportVersion().supports(ML_INFERENCE_CUSTOM_SERVICE_REMOVE_ERROR_PARSING)) {
            in.readString();
            in.readString();
        }
        this.batchSize = in.getTransportVersion().supports(ML_INFERENCE_CUSTOM_SERVICE_EMBEDDING_BATCH_SIZE) ? in.readVInt() : 10;
        this.inputTypeTranslator = in.getTransportVersion().supports(ML_INFERENCE_CUSTOM_SERVICE_INPUT_TYPE) ? new InputTypeTranslator(in) : InputTypeTranslator.EMPTY_TRANSLATOR;
    }

    public String modelId() {
        return null;
    }

    public SimilarityMeasure similarity() {
        return this.textEmbeddingSettings.similarityMeasure;
    }

    public Integer dimensions() {
        return this.textEmbeddingSettings.dimensions;
    }

    public DenseVectorFieldMapper.ElementType elementType() {
        CustomServiceEmbeddingType embeddingType = this.responseJsonParser.getEmbeddingType();
        if (embeddingType != null) {
            return embeddingType.toElementType();
        }
        return null;
    }

    public Integer getMaxInputTokens() {
        return this.textEmbeddingSettings.maxInputTokens;
    }

    TextEmbeddingSettings getTextEmbeddingSettings() {
        return this.textEmbeddingSettings;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public QueryParameters getQueryParameters() {
        return this.queryParameters;
    }

    public String getRequestContentString() {
        return this.requestContentString;
    }

    public CustomResponseParser getResponseJsonParser() {
        return this.responseJsonParser;
    }

    public InputTypeTranslator getInputTypeTranslator() {
        return this.inputTypeTranslator;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitSettings;
    }

    public String getWriteableName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragment(builder, params);
        builder.endObject();
        return builder;
    }

    public XContentBuilder toXContentFragment(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.toXContentFragmentOfExposedFields(builder, params);
    }

    @Override
    public XContentBuilder toXContentFragmentOfExposedFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.textEmbeddingSettings.toXContent(builder, params);
        builder.field(URL, this.url);
        if (!this.headers.isEmpty()) {
            builder.field(HEADERS, this.headers);
        }
        this.queryParameters.toXContent(builder, params);
        builder.field(REQUEST, this.requestContentString);
        builder.startObject(RESPONSE);
        this.responseJsonParser.toXContent(builder, params);
        builder.endObject();
        this.inputTypeTranslator.toXContent(builder, params);
        this.rateLimitSettings.toXContent(builder, params);
        builder.field(BATCH_SIZE, this.batchSize);
        return builder;
    }

    @Override
    public ToXContentObject getFilteredXContentObject() {
        return this;
    }

    public TransportVersion getMinimalSupportedVersion() {
        assert (false) : "should never be called when supportsVersion is used";
        return INFERENCE_CUSTOM_SERVICE_ADDED;
    }

    public boolean supportsVersion(TransportVersion version) {
        return version.supports(INFERENCE_CUSTOM_SERVICE_ADDED);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.textEmbeddingSettings.writeTo(out);
        out.writeString(this.url);
        out.writeMap(this.headers, StreamOutput::writeString, StreamOutput::writeString);
        this.queryParameters.writeTo(out);
        out.writeString(this.requestContentString);
        out.writeNamedWriteable((NamedWriteable)this.responseJsonParser);
        this.rateLimitSettings.writeTo(out);
        if (!out.getTransportVersion().supports(ML_INFERENCE_CUSTOM_SERVICE_REMOVE_ERROR_PARSING)) {
            out.writeString("");
            out.writeString("");
        }
        if (out.getTransportVersion().supports(ML_INFERENCE_CUSTOM_SERVICE_EMBEDDING_BATCH_SIZE)) {
            out.writeVInt(this.batchSize);
        }
        if (out.getTransportVersion().supports(ML_INFERENCE_CUSTOM_SERVICE_INPUT_TYPE)) {
            this.inputTypeTranslator.writeTo(out);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomServiceSettings that = (CustomServiceSettings)o;
        return Objects.equals(this.textEmbeddingSettings, that.textEmbeddingSettings) && Objects.equals(this.url, that.url) && Objects.equals(this.headers, that.headers) && Objects.equals(this.queryParameters, that.queryParameters) && Objects.equals(this.requestContentString, that.requestContentString) && Objects.equals(this.responseJsonParser, that.responseJsonParser) && Objects.equals(this.rateLimitSettings, that.rateLimitSettings) && Objects.equals(this.batchSize, that.batchSize) && Objects.equals(this.inputTypeTranslator, that.inputTypeTranslator);
    }

    public int hashCode() {
        return Objects.hash(this.textEmbeddingSettings, this.url, this.headers, this.queryParameters, this.requestContentString, this.responseJsonParser, this.rateLimitSettings, this.batchSize, this.inputTypeTranslator);
    }

    private static CustomResponseParser extractResponseParser(TaskType taskType, Map<String, Object> responseParserMap, ValidationException validationException) {
        if (responseParserMap == null) {
            return NoopResponseParser.INSTANCE;
        }
        return switch (taskType) {
            case TaskType.TEXT_EMBEDDING -> DenseEmbeddingResponseParser.fromMap(responseParserMap, RESPONSE_SCOPE, validationException);
            case TaskType.SPARSE_EMBEDDING -> SparseEmbeddingResponseParser.fromMap(responseParserMap, RESPONSE_SCOPE, validationException);
            case TaskType.RERANK -> RerankResponseParser.fromMap(responseParserMap, RESPONSE_SCOPE, validationException);
            case TaskType.COMPLETION -> CompletionResponseParser.fromMap(responseParserMap, RESPONSE_SCOPE, validationException);
            default -> throw new IllegalArgumentException(Strings.format((String)"Invalid task type received [%s] while constructing response parser", (Object[])new Object[]{taskType}));
        };
    }

    public static class TextEmbeddingSettings
    implements ToXContentFragment,
    Writeable {
        public static final TextEmbeddingSettings DEFAULT_FLOAT = new TextEmbeddingSettings(null, null, null);
        public static final TextEmbeddingSettings NON_TEXT_EMBEDDING_TASK_TYPE_SETTINGS = new TextEmbeddingSettings(null, null, null);
        private static final TransportVersion ML_INFERENCE_CUSTOM_SERVICE_EMBEDDING_TYPE = TransportVersion.fromName((String)"ml_inference_custom_service_embedding_type");
        private final SimilarityMeasure similarityMeasure;
        private final Integer dimensions;
        private final Integer maxInputTokens;

        public static TextEmbeddingSettings fromMap(Map<String, Object> map, TaskType taskType, ValidationException validationException) {
            if (taskType != TaskType.TEXT_EMBEDDING) {
                return NON_TEXT_EMBEDDING_TASK_TYPE_SETTINGS;
            }
            SimilarityMeasure similarity = ServiceUtils.extractSimilarity(map, "service_settings", validationException);
            Integer dims = ServiceUtils.removeAsType(map, "dimensions", Integer.class);
            Integer maxInputTokens = ServiceUtils.removeAsType(map, "max_input_tokens", Integer.class);
            return new TextEmbeddingSettings(similarity, dims, maxInputTokens);
        }

        public TextEmbeddingSettings(@Nullable SimilarityMeasure similarityMeasure, @Nullable Integer dimensions, @Nullable Integer maxInputTokens) {
            this.similarityMeasure = similarityMeasure;
            this.dimensions = dimensions;
            this.maxInputTokens = maxInputTokens;
        }

        public TextEmbeddingSettings(StreamInput in) throws IOException {
            this.similarityMeasure = (SimilarityMeasure)in.readOptionalEnum(SimilarityMeasure.class);
            this.dimensions = in.readOptionalVInt();
            this.maxInputTokens = in.readOptionalVInt();
            if (!in.getTransportVersion().supports(ML_INFERENCE_CUSTOM_SERVICE_EMBEDDING_TYPE)) {
                in.readOptionalEnum(DenseVectorFieldMapper.ElementType.class);
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalEnum((Enum)this.similarityMeasure);
            out.writeOptionalVInt(this.dimensions);
            out.writeOptionalVInt(this.maxInputTokens);
            if (!out.getTransportVersion().supports(ML_INFERENCE_CUSTOM_SERVICE_EMBEDDING_TYPE)) {
                out.writeOptionalEnum(null);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.similarityMeasure != null) {
                builder.field("similarity", (Enum)this.similarityMeasure);
            }
            if (this.dimensions != null) {
                builder.field("dimensions", this.dimensions);
            }
            if (this.maxInputTokens != null) {
                builder.field("max_input_tokens", this.maxInputTokens);
            }
            return builder;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TextEmbeddingSettings that = (TextEmbeddingSettings)o;
            return this.similarityMeasure == that.similarityMeasure && Objects.equals(this.dimensions, that.dimensions) && Objects.equals(this.maxInputTokens, that.maxInputTokens);
        }

        public int hashCode() {
            return Objects.hash(this.similarityMeasure, this.dimensions, this.maxInputTokens);
        }
    }
}

