/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.azureaistudio.rerank;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.azureaistudio.AzureAiStudioModel;
import org.elasticsearch.xpack.inference.services.azureaistudio.action.AzureAiStudioActionVisitor;
import org.elasticsearch.xpack.inference.services.azureaistudio.rerank.AzureAiStudioRerankRequestTaskSettings;
import org.elasticsearch.xpack.inference.services.azureaistudio.rerank.AzureAiStudioRerankServiceSettings;
import org.elasticsearch.xpack.inference.services.azureaistudio.rerank.AzureAiStudioRerankTaskSettings;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;

public class AzureAiStudioRerankModel
extends AzureAiStudioModel {
    public static AzureAiStudioRerankModel of(AzureAiStudioRerankModel model, Map<String, Object> taskSettings) {
        if (taskSettings == null || taskSettings.isEmpty()) {
            return model;
        }
        AzureAiStudioRerankRequestTaskSettings requestTaskSettings = AzureAiStudioRerankRequestTaskSettings.fromMap(taskSettings);
        AzureAiStudioRerankTaskSettings taskSettingToUse = AzureAiStudioRerankTaskSettings.of(model.getTaskSettings(), requestTaskSettings);
        return new AzureAiStudioRerankModel(model, taskSettingToUse);
    }

    public AzureAiStudioRerankModel(String inferenceEntityId, AzureAiStudioRerankServiceSettings serviceSettings, AzureAiStudioRerankTaskSettings taskSettings, DefaultSecretSettings secrets) {
        super(new ModelConfigurations(inferenceEntityId, TaskType.RERANK, "azureaistudio", (ServiceSettings)serviceSettings, (TaskSettings)taskSettings), new ModelSecrets((SecretSettings)secrets));
    }

    public AzureAiStudioRerankModel(String inferenceEntityId, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, @Nullable Map<String, Object> secrets, ConfigurationParseContext context) {
        this(inferenceEntityId, AzureAiStudioRerankServiceSettings.fromMap(serviceSettings, context), AzureAiStudioRerankTaskSettings.fromMap(taskSettings), DefaultSecretSettings.fromMap(secrets));
    }

    public AzureAiStudioRerankModel(AzureAiStudioRerankModel model, AzureAiStudioRerankTaskSettings taskSettings) {
        super(model, taskSettings, model.getServiceSettings().rateLimitSettings());
    }

    public AzureAiStudioRerankServiceSettings getServiceSettings() {
        return (AzureAiStudioRerankServiceSettings)super.getServiceSettings();
    }

    public AzureAiStudioRerankTaskSettings getTaskSettings() {
        return (AzureAiStudioRerankTaskSettings)super.getTaskSettings();
    }

    @Override
    public DefaultSecretSettings getSecretSettings() {
        return super.getSecretSettings();
    }

    @Override
    protected URI getEndpointUri() throws URISyntaxException {
        return new URI(this.target + "/v1/rerank");
    }

    @Override
    public ExecutableAction accept(AzureAiStudioActionVisitor creator, Map<String, Object> taskSettings) {
        return creator.create(this, taskSettings);
    }
}

