/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.mapper;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.lucene.util.BitSet;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.cluster.metadata.InferenceFieldMetadata;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.BlockSourceReader;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.DocumentParsingException;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.IndexType;
import org.elasticsearch.index.mapper.InferenceFieldMapper;
import org.elasticsearch.index.mapper.InferenceMetadataFieldsMapper;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperMergeContext;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.NestedObjectMapper;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.SimpleMappedFieldType;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.index.mapper.vectors.IndexOptions;
import org.elasticsearch.index.mapper.vectors.SparseVectorFieldMapper;
import org.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.elasticsearch.index.query.NestedQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.inference.MinimalServiceSettings;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.search.fetch.StoredFieldsSpec;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.search.vectors.KnnVectorQueryBuilder;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentLocation;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ml.inference.results.MlDenseEmbeddingResults;
import org.elasticsearch.xpack.core.ml.inference.results.TextExpansionResults;
import org.elasticsearch.xpack.core.ml.search.SparseVectorQueryBuilder;
import org.elasticsearch.xpack.inference.mapper.OffsetSourceField;
import org.elasticsearch.xpack.inference.mapper.OffsetSourceFieldMapper;
import org.elasticsearch.xpack.inference.mapper.SemanticTextField;
import org.elasticsearch.xpack.inference.mapper.SemanticTextIndexOptions;
import org.elasticsearch.xpack.inference.mapper.SemanticTextUtils;
import org.elasticsearch.xpack.inference.registry.ModelRegistry;

public class SemanticTextFieldMapper
extends FieldMapper
implements InferenceFieldMapper {
    private static final Logger logger = LogManager.getLogger(SemanticTextFieldMapper.class);
    public static final NodeFeature SEMANTIC_TEXT_IN_OBJECT_FIELD_FIX = new NodeFeature("semantic_text.in_object_field_fix");
    public static final NodeFeature SEMANTIC_TEXT_SINGLE_FIELD_UPDATE_FIX = new NodeFeature("semantic_text.single_field_update_fix");
    public static final NodeFeature SEMANTIC_TEXT_DELETE_FIX = new NodeFeature("semantic_text.delete_fix");
    public static final NodeFeature SEMANTIC_TEXT_ZERO_SIZE_FIX = new NodeFeature("semantic_text.zero_size_fix");
    public static final NodeFeature SEMANTIC_TEXT_ALWAYS_EMIT_INFERENCE_ID_FIX = new NodeFeature("semantic_text.always_emit_inference_id_fix");
    public static final NodeFeature SEMANTIC_TEXT_HANDLE_EMPTY_INPUT = new NodeFeature("semantic_text.handle_empty_input");
    public static final NodeFeature SEMANTIC_TEXT_SKIP_INFERENCE_FIELDS = new NodeFeature("semantic_text.skip_inference_fields");
    public static final NodeFeature SEMANTIC_TEXT_BIT_VECTOR_SUPPORT = new NodeFeature("semantic_text.bit_vector_support");
    public static final NodeFeature SEMANTIC_TEXT_SUPPORT_CHUNKING_CONFIG = new NodeFeature("semantic_text.support_chunking_config");
    public static final NodeFeature SEMANTIC_TEXT_EXCLUDE_SUB_FIELDS_FROM_FIELD_CAPS = new NodeFeature("semantic_text.exclude_sub_fields_from_field_caps");
    public static final NodeFeature SEMANTIC_TEXT_INDEX_OPTIONS = new NodeFeature("semantic_text.index_options");
    public static final NodeFeature SEMANTIC_TEXT_INDEX_OPTIONS_WITH_DEFAULTS = new NodeFeature("semantic_text.index_options_with_defaults");
    public static final NodeFeature SEMANTIC_TEXT_SPARSE_VECTOR_INDEX_OPTIONS = new NodeFeature("semantic_text.sparse_vector_index_options");
    public static final NodeFeature SEMANTIC_TEXT_UPDATABLE_INFERENCE_ID = new NodeFeature("semantic_text.updatable_inference_id");
    public static final String CONTENT_TYPE = "semantic_text";
    public static final String DEFAULT_FALLBACK_ELSER_INFERENCE_ID = ".elser-2-elasticsearch";
    public static final String DEFAULT_EIS_ELSER_INFERENCE_ID = ".elser-2-elastic";
    public static final String UNSUPPORTED_INDEX_MESSAGE = "[semantic_text] is available on indices created with 8.11 or higher. Please create a new index to use [semantic_text]";
    public static final float DEFAULT_RESCORE_OVERSAMPLE = 3.0f;
    static final String INDEX_OPTIONS_FIELD = "index_options";
    private final ModelRegistry modelRegistry;

    private static String getPreferredElserInferenceId(ModelRegistry modelRegistry) {
        if (modelRegistry != null && modelRegistry.containsPreconfiguredInferenceEndpointId(DEFAULT_EIS_ELSER_INFERENCE_ID)) {
            return DEFAULT_EIS_ELSER_INFERENCE_ID;
        }
        return DEFAULT_FALLBACK_ELSER_INFERENCE_ID;
    }

    public static final FieldMapper.TypeParser parser(Supplier<ModelRegistry> modelRegistry) {
        return new FieldMapper.TypeParser((n, c) -> new Builder((String)n, arg_0 -> ((MappingParserContext)c).bitSetProducer(arg_0), c.getIndexSettings(), (ModelRegistry)modelRegistry.get()), List.of(SemanticTextFieldMapper.validateParserContext(CONTENT_TYPE)));
    }

    public static BiConsumer<String, MappingParserContext> validateParserContext(String type) {
        return (n, c) -> {
            if (!InferenceMetadataFieldsMapper.isEnabled((Settings)c.getIndexSettings().getSettings())) {
                SemanticTextFieldMapper.notInMultiFields((String)type).accept(n, c);
            }
            SemanticTextFieldMapper.notFromDynamicTemplates((String)type).accept(n, c);
        };
    }

    private SemanticTextFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.BuilderParams builderParams, ModelRegistry modelRegistry) {
        super(simpleName, mappedFieldType, builderParams);
        this.ensureMultiFields(builderParams.multiFields().iterator());
        this.modelRegistry = modelRegistry;
    }

    private void ensureMultiFields(Iterator<FieldMapper> mappers) {
        while (mappers.hasNext()) {
            FieldMapper mapper = mappers.next();
            if (!mapper.leafName().equals("inference")) continue;
            throw new IllegalArgumentException("Field [" + mapper.fullPath() + "] is already used by another field [" + this.fullPath() + "] internally. Please choose a different name.");
        }
    }

    public Iterator<Mapper> iterator() {
        ArrayList<Object> mappers = new ArrayList<Object>();
        Iterator m = super.iterator();
        while (m.hasNext()) {
            mappers.add((Mapper)m.next());
        }
        mappers.add(this.fieldType().getInferenceField());
        return mappers.iterator();
    }

    public FieldMapper.Builder getMergeBuilder() {
        return Builder.from(this);
    }

    protected void parseCreateField(DocumentParserContext context) throws IOException {
        XContentParser parser = context.parser();
        XContentLocation xContentLocation = parser.getTokenLocation();
        if (!this.fieldType().useLegacyFormat) {
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                throw new DocumentParsingException(xContentLocation, "[semantic_text] field [" + this.fullPath() + "] does not support object values");
            }
            parser.skipChildren();
            return;
        }
        SemanticTextField field = this.parseSemanticTextField(context);
        if (field != null) {
            this.parseCreateFieldFromContext(context, field, xContentLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SemanticTextField parseSemanticTextField(DocumentParserContext context) throws IOException {
        SemanticTextField semanticTextField;
        XContentParser parser = context.parser();
        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        boolean isWithinLeaf = context.path().isWithinLeafObject();
        try {
            context.path().setWithinLeafObject(true);
            semanticTextField = SemanticTextField.parse(context.parser(), new SemanticTextField.ParserContext(this.fieldType().useLegacyFormat, this.fullPath(), context.parser().contentType()));
        }
        finally {
            context.path().setWithinLeafObject(isWithinLeaf);
        }
        IndexVersion indexCreatedVersion = context.indexSettings().getIndexVersionCreated();
        if (semanticTextField != null && semanticTextField.inference().modelSettings() != null && indexCreatedVersion.before((VersionId)IndexVersions.NEW_SPARSE_VECTOR)) {
            throw new UnsupportedOperationException(UNSUPPORTED_INDEX_MESSAGE);
        }
        return semanticTextField;
    }

    void parseCreateFieldFromContext(DocumentParserContext context, SemanticTextField field, XContentLocation xContentLocation) throws IOException {
        SemanticTextFieldMapper mapper;
        String fullFieldName = this.fieldType().name();
        if (!field.inference().inferenceId().equals(this.fieldType().getInferenceId())) {
            throw new DocumentParsingException(xContentLocation, Strings.format((String)"The configured %s [%s] for field [%s] doesn't match the %s [%s] reported in the document.", (Object[])new Object[]{"inference_id", field.inference().inferenceId(), fullFieldName, "inference_id", this.fieldType().getInferenceId()}));
        }
        if (this.fieldType().getModelSettings() == null && field.inference().modelSettings() != null) {
            mapper = this.addDynamicUpdate(context, field);
        } else {
            FieldMapper.Conflicts conflicts = new FieldMapper.Conflicts(fullFieldName);
            SemanticTextFieldMapper.canMergeModelSettings(this.fieldType().getModelSettings(), field.inference().modelSettings(), conflicts);
            try {
                conflicts.check();
            }
            catch (Exception exception) {
                throw new DocumentParsingException(xContentLocation, "Incompatible model settings for field [" + this.fullPath() + "]. Check that the inference_id is not using different model settings", exception);
            }
            mapper = this;
        }
        if (mapper.fieldType().getModelSettings() == null) {
            for (List list : field.inference().chunks().values()) {
                if (list.isEmpty()) continue;
                throw new DocumentParsingException(xContentLocation, "[model_settings] must be set for field [" + fullFieldName + "] when chunks are provided");
            }
        }
        NestedObjectMapper chunksField = mapper.fieldType().getChunksField();
        FieldMapper fieldMapper = mapper.fieldType().getEmbeddingsField();
        FieldMapper offsetsField = mapper.fieldType().getOffsetsField();
        for (Map.Entry<String, List<SemanticTextField.Chunk>> entry : field.inference().chunks().entrySet()) {
            for (SemanticTextField.Chunk chunk : entry.getValue()) {
                DocumentParserContext nestedContext = context.createNestedContext(chunksField);
                try (XContentParser subParser = XContentHelper.createParserNotCompressed((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)chunk.rawEmbeddings(), (XContentType)context.parser().contentType());){
                    DocumentParserContext subContext = nestedContext.switchParser(subParser);
                    subParser.nextToken();
                    fieldMapper.parse(subContext);
                }
                if (this.fieldType().useLegacyFormat) continue;
                XContentBuilder builder = XContentFactory.contentBuilder((XContentType)context.parser().contentType());
                try {
                    builder.startObject();
                    builder.field("field", entry.getKey());
                    builder.field("start", chunk.startOffset());
                    builder.field("end", chunk.endOffset());
                    builder.endObject();
                    XContentParser subParser = XContentHelper.createParserNotCompressed((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)BytesReference.bytes((XContentBuilder)builder), (XContentType)context.parser().contentType());
                    try {
                        DocumentParserContext subContext = nestedContext.switchParser(subParser);
                        subParser.nextToken();
                        offsetsField.parse(subContext);
                    }
                    finally {
                        if (subParser == null) continue;
                        subParser.close();
                    }
                }
                finally {
                    if (builder == null) continue;
                    builder.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SemanticTextFieldMapper addDynamicUpdate(DocumentParserContext context, SemanticTextField field) {
        Builder builder = (Builder)this.getMergeBuilder();
        context.path().remove();
        builder.setModelSettings(field.inference().modelSettings()).setInferenceId(field.inference().inferenceId());
        if (context.mappingLookup().isMultiField(this.fullPath())) {
            String fieldName = context.path().remove();
            try {
                FieldMapper.Builder parentMapper = ((FieldMapper)context.mappingLookup().getMapper(context.mappingLookup().parentField(this.fullPath()))).getMergeBuilder();
                context.addDynamicMapper((Mapper)parentMapper.addMultiField((FieldMapper.Builder)builder).build(context.createDynamicMapperBuilderContext()));
                SemanticTextFieldMapper semanticTextFieldMapper = builder.build(context.createDynamicMapperBuilderContext());
                return semanticTextFieldMapper;
            }
            finally {
                context.path().add(fieldName);
            }
        }
        SemanticTextFieldMapper mapper = builder.build(context.createDynamicMapperBuilderContext());
        context.addDynamicMapper((Mapper)mapper);
        SemanticTextFieldMapper semanticTextFieldMapper = mapper;
        return semanticTextFieldMapper;
        finally {
            context.path().add(this.leafName());
        }
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public SemanticTextFieldType fieldType() {
        return (SemanticTextFieldType)super.fieldType();
    }

    public InferenceFieldMetadata getMetadata(Set<String> sourcePaths) {
        Object[] copyFields = (String[])sourcePaths.toArray(String[]::new);
        Arrays.sort(copyFields);
        ChunkingSettings fieldTypeChunkingSettings = this.fieldType().getChunkingSettings();
        Map asMap = fieldTypeChunkingSettings != null ? fieldTypeChunkingSettings.asMap() : null;
        return new InferenceFieldMetadata(this.fullPath(), this.fieldType().getInferenceId(), this.fieldType().getSearchInferenceId(), (String[])copyFields, asMap);
    }

    protected void doValidate(MappingLookup mappers) {
        String leafName;
        String fullPath = mappers.isMultiField(this.fullPath()) ? mappers.parentField(this.fullPath()) : this.fullPath();
        int parentPathIndex = fullPath.lastIndexOf(leafName = mappers.getMapper(fullPath).leafName());
        if (parentPathIndex > 0) {
            String parentName = fullPath.substring(0, parentPathIndex - 1);
            ObjectMapper parentMapper = (ObjectMapper)mappers.objectMappers().get(parentName);
            if (parentMapper == null) {
                throw new IllegalStateException("semantic_text field [" + this.fullPath() + "] does not have a parent object mapper");
            }
            if (parentMapper.subobjects() == ObjectMapper.Subobjects.DISABLED) {
                throw new IllegalArgumentException("semantic_text field [" + this.fullPath() + "] cannot be in an object field with subobjects disabled");
            }
        }
    }

    private static ObjectMapper createInferenceField(MapperBuilderContext context, boolean useLegacyFormat, @Nullable MinimalServiceSettings modelSettings, @Nullable SemanticTextIndexOptions indexOptions, Function<Query, BitSetProducer> bitSetProducer, IndexSettings indexSettings) {
        return new ObjectMapper.Builder("inference", Explicit.of((Object)ObjectMapper.Subobjects.ENABLED)).dynamic(ObjectMapper.Dynamic.FALSE).add((Mapper.Builder)SemanticTextFieldMapper.createChunksField(useLegacyFormat, modelSettings, indexOptions, bitSetProducer, indexSettings)).build(context);
    }

    private static NestedObjectMapper.Builder createChunksField(boolean useLegacyFormat, @Nullable MinimalServiceSettings modelSettings, @Nullable SemanticTextIndexOptions indexOptions, Function<Query, BitSetProducer> bitSetProducer, IndexSettings indexSettings) {
        NestedObjectMapper.Builder chunksField = new NestedObjectMapper.Builder("chunks", indexSettings.getIndexVersionCreated(), bitSetProducer, indexSettings);
        chunksField.dynamic(ObjectMapper.Dynamic.FALSE);
        if (modelSettings != null) {
            chunksField.add(SemanticTextFieldMapper.createEmbeddingsField(indexSettings.getIndexVersionCreated(), modelSettings, indexOptions, useLegacyFormat));
        }
        if (useLegacyFormat) {
            KeywordFieldMapper.Builder chunkTextField = new KeywordFieldMapper.Builder("text", indexSettings).indexed(false).docValues(false);
            chunksField.add((Mapper.Builder)chunkTextField);
        } else {
            chunksField.add((Mapper.Builder)new OffsetSourceFieldMapper.Builder("offset"));
        }
        return chunksField;
    }

    private static Mapper.Builder createEmbeddingsField(IndexVersion indexVersionCreated, MinimalServiceSettings modelSettings, SemanticTextIndexOptions indexOptions, boolean useLegacyFormat) {
        return switch (modelSettings.taskType()) {
            case TaskType.SPARSE_EMBEDDING -> {
                SparseVectorFieldMapper.Builder sparseVectorMapperBuilder = new SparseVectorFieldMapper.Builder("embeddings", indexVersionCreated, false).setStored(!useLegacyFormat);
                SemanticTextFieldMapper.configureSparseVectorMapperBuilder(indexVersionCreated, sparseVectorMapperBuilder, indexOptions);
                yield sparseVectorMapperBuilder;
            }
            case TaskType.TEXT_EMBEDDING -> {
                DenseVectorFieldMapper.Builder denseVectorMapperBuilder = new DenseVectorFieldMapper.Builder("embeddings", indexVersionCreated, false, List.of());
                SemanticTextFieldMapper.configureDenseVectorMapperBuilder(indexVersionCreated, denseVectorMapperBuilder, modelSettings, indexOptions);
                yield denseVectorMapperBuilder;
            }
            default -> throw new IllegalArgumentException("Invalid task_type in model_settings [" + modelSettings.taskType().name() + "]");
        };
    }

    private static void configureSparseVectorMapperBuilder(IndexVersion indexVersionCreated, SparseVectorFieldMapper.Builder sparseVectorMapperBuilder, SemanticTextIndexOptions indexOptions) {
        if (indexOptions != null) {
            SparseVectorFieldMapper.SparseVectorIndexOptions sparseVectorIndexOptions = (SparseVectorFieldMapper.SparseVectorIndexOptions)indexOptions.indexOptions();
            sparseVectorMapperBuilder.setIndexOptions(sparseVectorIndexOptions);
        } else {
            SparseVectorFieldMapper.SparseVectorIndexOptions defaultIndexOptions = SparseVectorFieldMapper.SparseVectorIndexOptions.getDefaultIndexOptions((IndexVersion)indexVersionCreated);
            if (defaultIndexOptions != null) {
                sparseVectorMapperBuilder.setIndexOptions(defaultIndexOptions);
            }
        }
    }

    private static void configureDenseVectorMapperBuilder(IndexVersion indexVersionCreated, DenseVectorFieldMapper.Builder denseVectorMapperBuilder, MinimalServiceSettings modelSettings, SemanticTextIndexOptions indexOptions) {
        SimilarityMeasure similarity;
        if (indexVersionCreated.onOrAfter((VersionId)IndexVersions.NEW_SPARSE_VECTOR) && (similarity = modelSettings.similarity()) != null) {
            switch (similarity) {
                case COSINE: {
                    denseVectorMapperBuilder.similarity(DenseVectorFieldMapper.VectorSimilarity.COSINE);
                    break;
                }
                case DOT_PRODUCT: {
                    denseVectorMapperBuilder.similarity(DenseVectorFieldMapper.VectorSimilarity.DOT_PRODUCT);
                    break;
                }
                case L2_NORM: {
                    denseVectorMapperBuilder.similarity(DenseVectorFieldMapper.VectorSimilarity.L2_NORM);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown similarity measure in model_settings [" + similarity.name() + "]");
                }
            }
        }
        denseVectorMapperBuilder.dimensions(modelSettings.dimensions().intValue());
        denseVectorMapperBuilder.elementType(modelSettings.elementType());
        if (indexOptions != null) {
            DenseVectorFieldMapper.DenseVectorIndexOptions denseVectorIndexOptions = (DenseVectorFieldMapper.DenseVectorIndexOptions)indexOptions.indexOptions();
            denseVectorMapperBuilder.indexOptions(denseVectorIndexOptions);
            denseVectorIndexOptions.validate(modelSettings.elementType(), modelSettings.dimensions().intValue(), true);
        } else {
            DenseVectorFieldMapper.DenseVectorIndexOptions defaultIndexOptions = SemanticTextFieldMapper.defaultDenseVectorIndexOptions(indexVersionCreated, modelSettings);
            if (defaultIndexOptions != null) {
                denseVectorMapperBuilder.indexOptions(defaultIndexOptions);
            }
        }
    }

    static DenseVectorFieldMapper.DenseVectorIndexOptions defaultDenseVectorIndexOptions(IndexVersion indexVersionCreated, MinimalServiceSettings modelSettings) {
        if (modelSettings.dimensions() == null) {
            return null;
        }
        if (SemanticTextFieldMapper.indexVersionDefaultsToBbqHnsw(indexVersionCreated)) {
            DenseVectorFieldMapper.DenseVectorIndexOptions defaultBbqHnswIndexOptions = SemanticTextFieldMapper.defaultBbqHnswDenseVectorIndexOptions();
            return defaultBbqHnswIndexOptions.validate(modelSettings.elementType(), modelSettings.dimensions().intValue(), false) ? defaultBbqHnswIndexOptions : null;
        }
        return null;
    }

    static boolean indexVersionDefaultsToBbqHnsw(IndexVersion indexVersion) {
        return indexVersion.onOrAfter((VersionId)IndexVersions.SEMANTIC_TEXT_DEFAULTS_TO_BBQ) || indexVersion.between((VersionId)IndexVersions.SEMANTIC_TEXT_DEFAULTS_TO_BBQ_BACKPORT_8_X, (VersionId)IndexVersions.UPGRADE_TO_LUCENE_10_0_0);
    }

    public static DenseVectorFieldMapper.DenseVectorIndexOptions defaultBbqHnswDenseVectorIndexOptions() {
        int m = 16;
        int efConstruction = 100;
        DenseVectorFieldMapper.RescoreVector rescoreVector = new DenseVectorFieldMapper.RescoreVector(3.0f);
        return new DenseVectorFieldMapper.BBQHnswIndexOptions(m, efConstruction, false, rescoreVector);
    }

    static SemanticTextIndexOptions defaultIndexOptions(IndexVersion indexVersionCreated, MinimalServiceSettings modelSettings) {
        if (modelSettings == null) {
            return null;
        }
        if (modelSettings.taskType() == TaskType.TEXT_EMBEDDING) {
            DenseVectorFieldMapper.DenseVectorIndexOptions denseVectorIndexOptions = SemanticTextFieldMapper.defaultDenseVectorIndexOptions(indexVersionCreated, modelSettings);
            return denseVectorIndexOptions == null ? null : new SemanticTextIndexOptions(SemanticTextIndexOptions.SupportedIndexOptions.DENSE_VECTOR, (IndexOptions)denseVectorIndexOptions);
        }
        if (modelSettings.taskType() == TaskType.SPARSE_EMBEDDING) {
            SparseVectorFieldMapper.SparseVectorIndexOptions sparseVectorIndexOptions = SparseVectorFieldMapper.SparseVectorIndexOptions.getDefaultIndexOptions((IndexVersion)indexVersionCreated);
            return sparseVectorIndexOptions == null ? null : new SemanticTextIndexOptions(SemanticTextIndexOptions.SupportedIndexOptions.SPARSE_VECTOR, (IndexOptions)sparseVectorIndexOptions);
        }
        return null;
    }

    public static boolean canMergeModelSettings(MinimalServiceSettings previous, MinimalServiceSettings current, FieldMapper.Conflicts conflicts) {
        if (previous != null && current != null && previous.canMergeWith(current)) {
            return true;
        }
        if (previous == null || current == null) {
            return true;
        }
        conflicts.addConflict("model_settings", "");
        return false;
    }

    private static SemanticTextIndexOptions parseIndexOptionsFromMap(String fieldName, Object node, IndexVersion indexVersion) {
        if (node == null) {
            return null;
        }
        Map map = XContentMapValues.nodeMapValue((Object)node, (String)INDEX_OPTIONS_FIELD);
        if (map.size() != 1) {
            throw new IllegalArgumentException("Too many index options provided, found [" + String.valueOf(map.keySet()) + "]");
        }
        Map.Entry entry = map.entrySet().iterator().next();
        SemanticTextIndexOptions.SupportedIndexOptions indexOptions = SemanticTextIndexOptions.SupportedIndexOptions.fromValue((String)entry.getKey());
        Map indexOptionsMap = (Map)entry.getValue();
        return new SemanticTextIndexOptions(indexOptions, indexOptions.parseIndexOptions(fieldName, indexOptionsMap, indexVersion));
    }

    public static class SemanticTextFieldType
    extends SimpleMappedFieldType {
        private final String inferenceId;
        private final String searchInferenceId;
        private final MinimalServiceSettings modelSettings;
        private final ChunkingSettings chunkingSettings;
        private final SemanticTextIndexOptions indexOptions;
        private final ObjectMapper inferenceField;
        private final boolean useLegacyFormat;

        public SemanticTextFieldType(String name, String inferenceId, String searchInferenceId, MinimalServiceSettings modelSettings, ChunkingSettings chunkingSettings, SemanticTextIndexOptions indexOptions, ObjectMapper inferenceField, boolean useLegacyFormat, Map<String, String> meta) {
            super(name, IndexType.terms((boolean)true, (boolean)false), false, meta);
            this.inferenceId = inferenceId;
            this.searchInferenceId = searchInferenceId;
            this.modelSettings = modelSettings;
            this.chunkingSettings = chunkingSettings;
            this.indexOptions = indexOptions;
            this.inferenceField = inferenceField;
            this.useLegacyFormat = useLegacyFormat;
        }

        public boolean useLegacyFormat() {
            return this.useLegacyFormat;
        }

        public String typeName() {
            return SemanticTextFieldMapper.CONTENT_TYPE;
        }

        public String familyTypeName() {
            return "text";
        }

        public String getDefaultHighlighter() {
            return "semantic";
        }

        public String getInferenceId() {
            return this.inferenceId;
        }

        public String getSearchInferenceId() {
            return this.searchInferenceId == null ? this.inferenceId : this.searchInferenceId;
        }

        public MinimalServiceSettings getModelSettings() {
            return this.modelSettings;
        }

        public ChunkingSettings getChunkingSettings() {
            return this.chunkingSettings;
        }

        public ObjectMapper getInferenceField() {
            return this.inferenceField;
        }

        public NestedObjectMapper getChunksField() {
            return (NestedObjectMapper)this.inferenceField.getMapper("chunks");
        }

        public FieldMapper getEmbeddingsField() {
            return (FieldMapper)this.getChunksField().getMapper("embeddings");
        }

        public FieldMapper getOffsetsField() {
            return (FieldMapper)this.getChunksField().getMapper("offset");
        }

        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new IllegalArgumentException("semantic_text fields do not support term query");
        }

        public Query existsQuery(SearchExecutionContext context) {
            if (this.modelSettings == null) {
                return new MatchNoDocsQuery();
            }
            return NestedQueryBuilder.toQuery(c -> this.getEmbeddingsField().fieldType().existsQuery(c), (String)SemanticTextField.getChunksFieldName(this.name()), (ScoreMode)ScoreMode.None, (boolean)false, (SearchExecutionContext)context);
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null && !"chunks".equals(format)) {
                throw new IllegalArgumentException("Unknown format [" + format + "] for field [" + this.name() + "], only [chunks] is supported.");
            }
            if (format != null) {
                return this.valueFetcherWithInferenceResults(this.getChunksField().bitsetProducer(), context.searcher(), true);
            }
            if (this.useLegacyFormat) {
                return SourceValueFetcher.toString((String)SemanticTextField.getOriginalTextFieldName(this.name()), (SearchExecutionContext)context, (String)format);
            }
            return SourceValueFetcher.toString((String)this.name(), (SearchExecutionContext)context, null);
        }

        ValueFetcher valueFetcherWithInferenceResults(Function<Query, BitSetProducer> bitSetCache, IndexSearcher searcher, boolean onlyTextChunks) {
            FieldMapper embeddingsField = this.getEmbeddingsField();
            if (embeddingsField == null) {
                return ValueFetcher.EMPTY;
            }
            try {
                SourceLoader.SyntheticFieldLoader embeddingsLoader = embeddingsField.syntheticFieldLoader();
                BitSetProducer bitSetFilter = bitSetCache.apply(this.getChunksField().parentTypeFilter());
                Weight childWeight = searcher.createWeight(this.getChunksField().nestedTypeFilter(), org.apache.lucene.search.ScoreMode.COMPLETE_NO_SCORES, 1.0f);
                return new SemanticTextFieldValueFetcher(bitSetFilter, childWeight, embeddingsLoader, onlyTextChunks);
            }
            catch (IOException exc) {
                throw new UncheckedIOException(exc);
            }
        }

        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            throw new IllegalArgumentException("[semantic_text] fields do not support sorting, scripting or aggregating");
        }

        public boolean fieldHasValue(FieldInfos fieldInfos) {
            return fieldInfos.fieldInfo(SemanticTextField.getEmbeddingsFieldName(this.name())) != null;
        }

        public QueryBuilder semanticQuery(InferenceResults inferenceResults, Integer requestSize, float boost, String queryName) {
            MatchNoneQueryBuilder childQueryBuilder;
            String nestedFieldPath = SemanticTextField.getChunksFieldName(this.name());
            String inferenceResultsFieldName = SemanticTextField.getEmbeddingsFieldName(this.name());
            if (this.modelSettings == null) {
                childQueryBuilder = new MatchNoneQueryBuilder();
            } else {
                childQueryBuilder = switch (this.modelSettings.taskType()) {
                    case TaskType.SPARSE_EMBEDDING -> {
                        if (!(inferenceResults instanceof TextExpansionResults)) {
                            throw new IllegalArgumentException(this.generateQueryInferenceResultsTypeMismatchMessage(inferenceResults, "text_expansion_result"));
                        }
                        TextExpansionResults textExpansionResults = (TextExpansionResults)inferenceResults;
                        yield new SparseVectorQueryBuilder(inferenceResultsFieldName, textExpansionResults.getWeightedTokens(), null, null, null, null);
                    }
                    case TaskType.TEXT_EMBEDDING -> {
                        int dimensions;
                        if (!(inferenceResults instanceof MlDenseEmbeddingResults)) {
                            throw new IllegalArgumentException(this.generateQueryInferenceResultsTypeMismatchMessage(inferenceResults, "text_embedding_result"));
                        }
                        MlDenseEmbeddingResults textEmbeddingResults = (MlDenseEmbeddingResults)inferenceResults;
                        float[] inference = textEmbeddingResults.getInferenceAsFloat();
                        int v1 = dimensions = this.modelSettings.elementType() == DenseVectorFieldMapper.ElementType.BIT ? inference.length * 8 : inference.length;
                        if (dimensions != this.modelSettings.dimensions()) {
                            throw new IllegalArgumentException(this.generateDimensionCountMismatchMessage(dimensions, this.modelSettings.dimensions()));
                        }
                        Integer k = requestSize;
                        if (k != null) {
                            k = Math.max(k, 10);
                        }
                        yield new KnnVectorQueryBuilder(inferenceResultsFieldName, inference, k, null, null, null, null);
                    }
                    default -> throw new IllegalStateException("Field [" + this.name() + "] is configured to use an inference endpoint with an unsupported task type [" + String.valueOf(this.modelSettings.taskType()) + "]");
                };
            }
            return ((NestedQueryBuilder)new NestedQueryBuilder(nestedFieldPath, (QueryBuilder)childQueryBuilder, ScoreMode.Max).boost(boost)).queryName(queryName);
        }

        private String generateQueryInferenceResultsTypeMismatchMessage(InferenceResults inferenceResults, String expectedResultsType) {
            StringBuilder sb = new StringBuilder("Field [" + this.name() + "] expected query inference results to be of type [" + expectedResultsType + "], got [" + inferenceResults.getWriteableName() + "].");
            return this.generateInvalidQueryInferenceResultsMessage(sb);
        }

        private String generateDimensionCountMismatchMessage(int inferenceDimCount, int expectedDimCount) {
            StringBuilder sb = new StringBuilder("Field [" + this.name() + "] expected query inference results with " + expectedDimCount + " dimensions, got " + inferenceDimCount + " dimensions.");
            return this.generateInvalidQueryInferenceResultsMessage(sb);
        }

        private String generateInvalidQueryInferenceResultsMessage(StringBuilder baseMessageBuilder) {
            if (this.searchInferenceId != null && !this.searchInferenceId.equals(this.inferenceId)) {
                baseMessageBuilder.append(" Is the search inference endpoint [" + this.searchInferenceId + "] compatible with the inference endpoint [" + this.inferenceId + "]?");
            } else {
                baseMessageBuilder.append(" Has the configuration for inference endpoint [" + this.inferenceId + "] changed?");
            }
            return baseMessageBuilder.toString();
        }

        public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
            String name = this.useLegacyFormat ? this.name().concat(".text") : this.name();
            SourceValueFetcher fetcher = SourceValueFetcher.toString((Set)blContext.sourcePaths(name), (IndexSettings)blContext.indexSettings());
            return new BlockSourceReader.BytesRefsBlockLoader((ValueFetcher)fetcher, BlockSourceReader.lookupMatchingAll());
        }

        private class SemanticTextFieldValueFetcher
        implements ValueFetcher {
            private final BitSetProducer parentBitSetProducer;
            private final Weight childWeight;
            private final SourceLoader.SyntheticFieldLoader fieldLoader;
            private final boolean onlyTextChunks;
            private BitSet bitSet;
            private Scorer childScorer;
            private SourceLoader.SyntheticFieldLoader.DocValuesLoader dvLoader;
            private OffsetSourceField.OffsetSourceLoader offsetsLoader;

            private SemanticTextFieldValueFetcher(BitSetProducer bitSetProducer, Weight childWeight, SourceLoader.SyntheticFieldLoader fieldLoader, boolean onlyTextChunks) {
                this.parentBitSetProducer = bitSetProducer;
                this.childWeight = childWeight;
                this.fieldLoader = fieldLoader;
                this.onlyTextChunks = onlyTextChunks;
            }

            public void setNextReader(LeafReaderContext context) {
                try {
                    Terms terms;
                    this.bitSet = this.parentBitSetProducer.getBitSet(context);
                    this.childScorer = this.childWeight.scorer(context);
                    if (this.childScorer != null) {
                        this.childScorer.iterator().nextDoc();
                    }
                    if (!this.onlyTextChunks) {
                        this.dvLoader = this.fieldLoader.docValuesLoader(context.reader(), null);
                    }
                    this.offsetsLoader = (terms = context.reader().terms(SemanticTextField.getOffsetsFieldName(SemanticTextFieldType.this.name()))) != null ? OffsetSourceField.loader(terms) : null;
                }
                catch (IOException exc) {
                    throw new UncheckedIOException(exc);
                }
            }

            public List<Object> fetchValues(Source source, int doc, List<Object> ignoredValues) throws IOException {
                if (this.childScorer == null || this.offsetsLoader == null || doc == 0) {
                    return List.of();
                }
                int previousParent = this.bitSet.prevSetBit(doc - 1);
                DocIdSetIterator it = this.childScorer.iterator();
                if (it.docID() < previousParent) {
                    it.advance(previousParent);
                }
                return this.onlyTextChunks ? this.fetchTextChunks(source, doc, it) : this.fetchFullField(source, doc, it);
            }

            private List<Object> fetchTextChunks(Source source, int doc, DocIdSetIterator it) throws IOException {
                HashMap originalValueMap = new HashMap();
                ArrayList<Object> chunks = new ArrayList<Object>();
                this.iterateChildDocs(doc, it, (CheckedConsumer<OffsetSourceFieldMapper.OffsetSource, IOException>)((CheckedConsumer)offset -> {
                    String rawValue = originalValueMap.computeIfAbsent(offset.field(), k -> {
                        Object valueObj = XContentMapValues.extractValue((String)offset.field(), (Map)source.source(), null);
                        List values = SemanticTextUtils.nodeStringValues(offset.field(), valueObj).stream().toList();
                        return Strings.collectionToDelimitedString(values, (String)String.valueOf('\u0000'));
                    });
                    chunks.add(rawValue.substring(offset.start(), offset.end()));
                }));
                return chunks;
            }

            private List<Object> fetchFullField(Source source, int doc, DocIdSetIterator it) throws IOException {
                LinkedHashMap<String, List<SemanticTextField.Chunk>> chunkMap = new LinkedHashMap<String, List<SemanticTextField.Chunk>>();
                this.iterateChildDocs(doc, it, (CheckedConsumer<OffsetSourceFieldMapper.OffsetSource, IOException>)((CheckedConsumer)offset -> {
                    List fullChunks = chunkMap.computeIfAbsent(offset.field(), k -> new ArrayList());
                    fullChunks.add(new SemanticTextField.Chunk(null, offset.start(), offset.end(), this.rawEmbeddings((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)arg_0 -> ((SourceLoader.SyntheticFieldLoader)this.fieldLoader).write(arg_0)), source.sourceContentType())));
                }));
                if (chunkMap.isEmpty()) {
                    return List.of();
                }
                return List.of(new SemanticTextField(SemanticTextFieldType.this.useLegacyFormat, SemanticTextFieldType.this.name(), null, new SemanticTextField.InferenceResult(SemanticTextFieldType.this.inferenceId, SemanticTextFieldType.this.modelSettings, SemanticTextFieldType.this.chunkingSettings, chunkMap), source.sourceContentType()));
            }

            private void iterateChildDocs(int doc, DocIdSetIterator it, CheckedConsumer<OffsetSourceFieldMapper.OffsetSource, IOException> action) throws IOException {
                while (it.docID() < doc) {
                    if (!(this.onlyTextChunks || this.dvLoader != null && this.dvLoader.advanceToDoc(it.docID()))) {
                        throw new IllegalStateException("Cannot fetch values for field [" + SemanticTextFieldType.this.name() + "], missing embeddings for doc [" + doc + "]");
                    }
                    OffsetSourceFieldMapper.OffsetSource offset = this.offsetsLoader.advanceTo(it.docID());
                    if (offset == null) {
                        throw new IllegalStateException("Cannot fetch values for field [" + SemanticTextFieldType.this.name() + "], missing offsets for doc [" + doc + "]");
                    }
                    action.accept((Object)offset);
                    if (it.nextDoc() != Integer.MAX_VALUE) continue;
                    break;
                }
            }

            private BytesReference rawEmbeddings(CheckedConsumer<XContentBuilder, IOException> writer, XContentType xContentType) throws IOException {
                try (XContentBuilder result = XContentFactory.contentBuilder((XContentType)xContentType);){
                    BytesReference bytesReference;
                    block19: {
                        XContentBuilder builder = XContentFactory.contentBuilder((XContentType)xContentType);
                        try {
                            builder.startObject();
                            writer.accept((Object)builder);
                            builder.endObject();
                            try (XContentParser parser = XContentHelper.createParserNotCompressed((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)BytesReference.bytes((XContentBuilder)builder), (XContentType)xContentType);){
                                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                                parser.nextToken();
                                result.copyCurrentStructure(parser);
                            }
                            bytesReference = BytesReference.bytes((XContentBuilder)result);
                            if (builder == null) break block19;
                        }
                        catch (Throwable throwable) {
                            if (builder != null) {
                                try {
                                    builder.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        builder.close();
                    }
                    return bytesReference;
                }
            }

            public StoredFieldsSpec storedFieldsSpec() {
                return StoredFieldsSpec.NO_REQUIREMENTS;
            }
        }
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final ModelRegistry modelRegistry;
        private final boolean useLegacyFormat;
        private final IndexVersion indexVersionCreated;
        private final FieldMapper.Parameter<String> inferenceId;
        private final FieldMapper.Parameter<String> searchInferenceId = FieldMapper.Parameter.stringParam((String)"search_inference_id", (boolean)true, mapper -> ((SemanticTextFieldType)mapper.fieldType()).searchInferenceId, null).acceptsNull().addValidator(v -> {
            if (v != null && Strings.isEmpty((CharSequence)v)) {
                throw new IllegalArgumentException("[search_inference_id] on mapper [" + this.leafName() + "] of type [semantic_text] must not be empty");
            }
        });
        private final FieldMapper.Parameter<MinimalServiceSettings> modelSettings;
        private final FieldMapper.Parameter<SemanticTextIndexOptions> indexOptions;
        private final FieldMapper.Parameter<ChunkingSettings> chunkingSettings = new FieldMapper.Parameter("chunking_settings", true, () -> null, (n, c, o) -> SemanticTextField.parseChunkingSettingsFromMap(o), mapper -> ((SemanticTextFieldType)mapper.fieldType()).chunkingSettings, XContentBuilder::field, Objects::toString).acceptsNull();
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private Function<MapperBuilderContext, ObjectMapper> inferenceFieldBuilder;

        public static Builder from(SemanticTextFieldMapper mapper) {
            Builder builder = new Builder(mapper.leafName(), mapper.fieldType().getChunksField().bitsetProducer(), mapper.fieldType().getChunksField().indexSettings(), mapper.modelRegistry);
            builder.init(mapper);
            return builder;
        }

        public Builder(String name, Function<Query, BitSetProducer> bitSetProducer, IndexSettings indexSettings, ModelRegistry modelRegistry) {
            super(name);
            this.modelRegistry = modelRegistry;
            this.useLegacyFormat = !InferenceMetadataFieldsMapper.isEnabled((Settings)indexSettings.getSettings());
            this.indexVersionCreated = indexSettings.getIndexVersionCreated();
            this.inferenceId = FieldMapper.Parameter.stringParam((String)"inference_id", (boolean)true, mapper -> ((SemanticTextFieldType)mapper.fieldType()).inferenceId, (String)SemanticTextFieldMapper.getPreferredElserInferenceId(modelRegistry)).addValidator(v -> {
                if (Strings.isEmpty((CharSequence)v)) {
                    throw new IllegalArgumentException("[inference_id] on mapper [" + this.leafName() + "] of type [semantic_text] must not be empty");
                }
            }).alwaysSerialize();
            this.modelSettings = new FieldMapper.Parameter("model_settings", true, () -> null, (n, c, o) -> SemanticTextField.parseModelSettingsFromMap(o), mapper -> ((SemanticTextFieldType)mapper.fieldType()).modelSettings, XContentBuilder::field, Objects::toString).acceptsNull().setMergeValidator(SemanticTextFieldMapper::canMergeModelSettings);
            this.indexOptions = new FieldMapper.Parameter(SemanticTextFieldMapper.INDEX_OPTIONS_FIELD, true, () -> null, (n, c, o) -> SemanticTextFieldMapper.parseIndexOptionsFromMap(n, o, c.indexVersionCreated()), mapper -> ((SemanticTextFieldType)mapper.fieldType()).indexOptions, (b, n, v) -> {
                if (v == null) {
                    MinimalServiceSettings resolvedModelSettings = this.modelSettings.get() != null ? (MinimalServiceSettings)this.modelSettings.get() : modelRegistry.getMinimalServiceSettings((String)this.inferenceId.get());
                    b.field(SemanticTextFieldMapper.INDEX_OPTIONS_FIELD, (ToXContent)SemanticTextFieldMapper.defaultIndexOptions(this.indexVersionCreated, resolvedModelSettings));
                } else {
                    b.field(SemanticTextFieldMapper.INDEX_OPTIONS_FIELD, (ToXContent)v);
                }
            }, Objects::toString).acceptsNull();
            this.inferenceFieldBuilder = c -> {
                MinimalServiceSettings resolvedModelSettings = this.modelSettings.get() != null ? (MinimalServiceSettings)this.modelSettings.get() : this.getResolvedModelSettings((MapperBuilderContext)c, false);
                return SemanticTextFieldMapper.createInferenceField(c, this.useLegacyFormat, resolvedModelSettings, (SemanticTextIndexOptions)this.indexOptions.get(), bitSetProducer, indexSettings);
            };
        }

        public Builder setInferenceId(String id) {
            this.inferenceId.setValue((Object)id);
            return this;
        }

        public Builder setModelSettings(MinimalServiceSettings value) {
            this.modelSettings.setValue((Object)value);
            return this;
        }

        public Builder setChunkingSettings(ChunkingSettings value) {
            this.chunkingSettings.setValue((Object)value);
            return this;
        }

        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.inferenceId, this.searchInferenceId, this.modelSettings, this.chunkingSettings, this.indexOptions, this.meta};
        }

        protected void merge(FieldMapper mergeWith, FieldMapper.Conflicts conflicts, MapperMergeContext mapperMergeContext) {
            SemanticTextFieldMapper semanticMergeWith = (SemanticTextFieldMapper)mergeWith;
            boolean isInferenceIdUpdate = !semanticMergeWith.fieldType().inferenceId.equals(this.inferenceId.get());
            boolean hasExplicitModelSettings = this.modelSettings.get() != null;
            MinimalServiceSettings updatedModelSettings = (MinimalServiceSettings)this.modelSettings.get();
            if (isInferenceIdUpdate && hasExplicitModelSettings) {
                this.validateModelsAreCompatibleWhenInferenceIdIsUpdated(semanticMergeWith.fieldType().inferenceId, conflicts);
                updatedModelSettings = this.modelRegistry.getMinimalServiceSettings(semanticMergeWith.fieldType().inferenceId);
            }
            semanticMergeWith = this.copyWithNewModelSettingsIfNotSet(semanticMergeWith, updatedModelSettings, mapperMergeContext);
            if (!isInferenceIdUpdate || hasExplicitModelSettings) {
                this.mergeInferenceField(mapperMergeContext, semanticMergeWith);
            }
            super.merge((FieldMapper)semanticMergeWith, conflicts, mapperMergeContext);
            conflicts.check();
        }

        private void validateModelsAreCompatibleWhenInferenceIdIsUpdated(String newInferenceId, FieldMapper.Conflicts conflicts) {
            MinimalServiceSettings currentModelSettings = (MinimalServiceSettings)this.modelSettings.get();
            MinimalServiceSettings updatedModelSettings = this.modelRegistry.getMinimalServiceSettings(newInferenceId);
            if (currentModelSettings != null && updatedModelSettings == null) {
                throw new IllegalArgumentException("Cannot update [semantic_text] field [" + this.leafName() + "] because inference endpoint [" + newInferenceId + "] does not exist.");
            }
            if (!SemanticTextFieldMapper.canMergeModelSettings(currentModelSettings, updatedModelSettings, conflicts)) {
                throw new IllegalArgumentException("Cannot update [semantic_text] field [" + this.leafName() + "] because inference endpoint [" + (String)this.inferenceId.get() + "] with model settings [" + String.valueOf(currentModelSettings) + "] is not compatible with new inference endpoint [" + newInferenceId + "] with model settings [" + String.valueOf(updatedModelSettings) + "].");
            }
        }

        private void mergeInferenceField(MapperMergeContext mapperMergeContext, SemanticTextFieldMapper semanticMergeWith) {
            try {
                MapperMergeContext context = mapperMergeContext.createChildContext(semanticMergeWith.leafName(), ObjectMapper.Dynamic.FALSE);
                ObjectMapper inferenceField = this.inferenceFieldBuilder.apply(context.getMapperBuilderContext());
                ObjectMapper mergedInferenceField = inferenceField.merge((Mapper)semanticMergeWith.fieldType().getInferenceField(), context);
                this.inferenceFieldBuilder = c -> mergedInferenceField;
            }
            catch (Exception e) {
                String errorMessage = e.getMessage() != null ? e.getMessage().replaceAll(SemanticTextField.getEmbeddingsFieldName(""), "") : "";
                throw new IllegalArgumentException(errorMessage, e);
            }
        }

        private MinimalServiceSettings getResolvedModelSettings(MapperBuilderContext context, boolean logWarning) {
            if (context.getMergeReason() == MapperService.MergeReason.MAPPING_RECOVERY) {
                return null;
            }
            try {
                return this.modelRegistry.getMinimalServiceSettings((String)this.inferenceId.get());
            }
            catch (ResourceNotFoundException exc) {
                if (logWarning) {
                    logger.warn("The field [{}] references an unknown inference ID [{}]. Indexing and querying this field will not work correctly until the corresponding inference endpoint is created.", (Object)this.leafName(), this.inferenceId.get());
                }
                return null;
            }
        }

        public SemanticTextFieldMapper build(MapperBuilderContext context) {
            if (this.useLegacyFormat && !this.copyTo.copyToFields().isEmpty()) {
                throw new IllegalArgumentException("semantic_text field [" + this.leafName() + "] does not support [copy_to]");
            }
            if (this.useLegacyFormat && this.multiFieldsBuilder.hasMultiFields()) {
                throw new IllegalArgumentException("semantic_text field [" + this.leafName() + "] does not support multi-fields");
            }
            MinimalServiceSettings resolvedModelSettings = (MinimalServiceSettings)this.modelSettings.get();
            if (this.modelSettings.get() == null) {
                resolvedModelSettings = this.getResolvedModelSettings(context, true);
            }
            if (this.modelSettings.get() != null) {
                this.validateServiceSettings((MinimalServiceSettings)this.modelSettings.get(), resolvedModelSettings);
            }
            SemanticTextIndexOptions builderIndexOptions = (SemanticTextIndexOptions)this.indexOptions.get();
            if (context.getMergeReason() != MapperService.MergeReason.MAPPING_RECOVERY && builderIndexOptions != null) {
                this.validateIndexOptions(builderIndexOptions, (String)this.inferenceId.getValue(), resolvedModelSettings);
            }
            String fullName = context.buildFullName(this.leafName());
            if (context.isInNestedContext()) {
                throw new IllegalArgumentException("semantic_text field [" + fullName + "] cannot be nested");
            }
            MapperBuilderContext childContext = context.createChildContext(this.leafName(), ObjectMapper.Dynamic.FALSE);
            ObjectMapper inferenceField = this.inferenceFieldBuilder.apply(childContext);
            return new SemanticTextFieldMapper(this.leafName(), (MappedFieldType)new SemanticTextFieldType(fullName, (String)this.inferenceId.getValue(), (String)this.searchInferenceId.getValue(), (MinimalServiceSettings)this.modelSettings.getValue(), (ChunkingSettings)this.chunkingSettings.getValue(), (SemanticTextIndexOptions)this.indexOptions.getValue(), inferenceField, this.useLegacyFormat, (Map)this.meta.getValue()), this.builderParams((Mapper.Builder)this, context), this.modelRegistry);
        }

        private void validateServiceSettings(MinimalServiceSettings settings, MinimalServiceSettings resolved) {
            switch (settings.taskType()) {
                case SPARSE_EMBEDDING: 
                case TEXT_EMBEDDING: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong [task_type], expected " + String.valueOf(TaskType.TEXT_EMBEDDING) + " or " + String.valueOf(TaskType.SPARSE_EMBEDDING) + ", got " + settings.taskType().name());
                }
            }
            if (resolved != null && !settings.canMergeWith(resolved)) {
                throw new IllegalArgumentException("Mismatch between provided and registered inference model settings. Provided: [" + String.valueOf(settings) + "], Expected: [" + String.valueOf(resolved) + "].");
            }
        }

        private void validateIndexOptions(SemanticTextIndexOptions indexOptions, String inferenceId, MinimalServiceSettings modelSettings) {
            if (indexOptions == null) {
                return;
            }
            if (modelSettings == null) {
                throw new IllegalArgumentException("Model settings must be set to validate index options for inference ID [" + inferenceId + "]");
            }
            if (indexOptions.type() == SemanticTextIndexOptions.SupportedIndexOptions.SPARSE_VECTOR) {
                if (modelSettings.taskType() != TaskType.SPARSE_EMBEDDING) {
                    throw new IllegalArgumentException("Invalid task type for index options, required [" + String.valueOf(TaskType.SPARSE_EMBEDDING) + "] but was [" + String.valueOf(modelSettings.taskType()) + "]");
                }
                return;
            }
            if (indexOptions.type() == SemanticTextIndexOptions.SupportedIndexOptions.DENSE_VECTOR) {
                if (modelSettings.taskType() != TaskType.TEXT_EMBEDDING) {
                    throw new IllegalArgumentException("Invalid task type for index options, required [" + String.valueOf(TaskType.TEXT_EMBEDDING) + "] but was [" + String.valueOf(modelSettings.taskType()) + "]");
                }
                int dims = modelSettings.dimensions() != null ? modelSettings.dimensions() : 0;
                DenseVectorFieldMapper.DenseVectorIndexOptions denseVectorIndexOptions = (DenseVectorFieldMapper.DenseVectorIndexOptions)indexOptions.indexOptions();
                denseVectorIndexOptions.validate(modelSettings.elementType(), dims, true);
            }
        }

        private SemanticTextFieldMapper copyWithNewModelSettingsIfNotSet(SemanticTextFieldMapper mapper, @Nullable MinimalServiceSettings modelSettings, MapperMergeContext mapperMergeContext) {
            SemanticTextFieldMapper returnedMapper = mapper;
            if (mapper.fieldType().getModelSettings() == null) {
                Builder builder = Builder.from(mapper);
                builder.setModelSettings(modelSettings);
                returnedMapper = builder.build(mapperMergeContext.getMapperBuilderContext());
            }
            return returnedMapper;
        }
    }
}

