/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.action;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.idp.action.SamlValidateAuthnRequestRequest;
import org.elasticsearch.xpack.idp.action.SamlValidateAuthnRequestResponse;
import org.elasticsearch.xpack.idp.saml.authn.SamlAuthnRequestValidator;
import org.elasticsearch.xpack.idp.saml.idp.SamlIdentityProvider;
import org.elasticsearch.xpack.idp.saml.support.SamlFactory;

public class TransportSamlValidateAuthnRequestAction
extends HandledTransportAction<SamlValidateAuthnRequestRequest, SamlValidateAuthnRequestResponse> {
    private final SamlIdentityProvider identityProvider;
    private final SamlFactory samlFactory;

    @Inject
    public TransportSamlValidateAuthnRequestAction(TransportService transportService, ActionFilters actionFilters, SamlIdentityProvider idp, SamlFactory factory) {
        super("cluster:admin/idp/saml/validate", transportService, actionFilters, SamlValidateAuthnRequestRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.identityProvider = idp;
        this.samlFactory = factory;
    }

    protected void doExecute(Task task, SamlValidateAuthnRequestRequest request, ActionListener<SamlValidateAuthnRequestResponse> listener) {
        SamlAuthnRequestValidator validator = new SamlAuthnRequestValidator(this.samlFactory, this.identityProvider);
        try {
            validator.processQueryString(request.getQueryString(), listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }
}

