/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.elasticsearch.compute.lucene.IndexedByShardId;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.plugin.ComputeSearchContext;

class ComputeSearchContextByShardId
implements IndexedByShardId<ComputeSearchContext>,
Releasable {
    private final ComputeSearchContext[] array;
    private int nextAddIndex;

    ComputeSearchContextByShardId(int size) {
        this.array = new ComputeSearchContext[size];
        this.nextAddIndex = 0;
    }

    public void add(ComputeSearchContext cse) {
        this.array[this.nextAddIndex++] = cse;
    }

    public ComputeSearchContext get(int shardId) {
        ComputeSearchContext result = this.array[shardId];
        if (result == null) {
            throw new IndexOutOfBoundsException("shardId " + shardId + " out of bounds [0, " + this.nextAddIndex + ")");
        }
        return result;
    }

    public Collection<ComputeSearchContext> collection() {
        return Arrays.asList(this.array).subList(0, this.nextAddIndex);
    }

    public <S> IndexedByShardId<S> map(Function<ComputeSearchContext, S> mapper) {
        return new Mapped<ComputeSearchContext, S>(this, this.array.length, 0, mapper);
    }

    public IndexedByShardId<ComputeSearchContext> subRange(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.nextAddIndex || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("Invalid subrange: [" + fromIndex + ", " + toIndex + ") in [0, " + this.nextAddIndex + ")");
        }
        return new SubRanged<ComputeSearchContext>(this.array, fromIndex, toIndex);
    }

    public int length() {
        return this.nextAddIndex;
    }

    public void close() {
        Releasables.close(this.collection());
    }

    private static class Mapped<T, S>
    implements IndexedByShardId<S> {
        private final IndexedByShardId<T> original;
        private final S[] cache;
        private final int offset;
        private final Function<T, S> mapper;

        Mapped(IndexedByShardId<T> original, int size, int offset, Function<T, S> mapper) {
            this.original = original;
            this.mapper = mapper;
            this.cache = new Object[size];
            this.offset = offset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public S get(int shardId) {
            int fixedShardId = shardId - this.offset;
            if (this.cache[fixedShardId] == null) {
                Mapped mapped = this;
                synchronized (mapped) {
                    if (this.cache[fixedShardId] == null) {
                        this.cache[fixedShardId] = this.mapper.apply(this.original.get(shardId));
                    }
                }
            }
            return this.cache[fixedShardId];
        }

        public Collection<? extends S> collection() {
            return IntStream.range(this.offset, this.original.collection().size() + this.offset).mapToObj(this::get).toList();
        }

        public <U> IndexedByShardId<U> map(Function<S, U> anotherMapper) {
            return new Mapped<S, U>(this, this.cache.length, this.offset, anotherMapper);
        }
    }

    private static class SubRanged<T>
    implements IndexedByShardId<T> {
        private final T[] array;
        private final int from;
        private final int to;

        SubRanged(T[] array, int from, int to) {
            this.array = array;
            this.from = from;
            this.to = to;
        }

        public T get(int shardId) {
            if (shardId < this.from || shardId >= this.to) {
                throw new IndexOutOfBoundsException("shardId " + shardId + " out of bounds [" + this.from + ", " + this.to + ")");
            }
            return this.array[shardId];
        }

        public Collection<? extends T> collection() {
            return Arrays.asList(this.array).subList(this.from, this.to);
        }

        public <S> IndexedByShardId<S> map(Function<T, S> mapper) {
            return new Mapped<T, S>(this, this.to - this.from, this.from, mapper);
        }
    }
}

