/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Chunk;

public final class ChunkBytesRefEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ChunkBytesRefEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator str;
    private final EvalOperator.ExpressionEvaluator numChunks;
    private final EvalOperator.ExpressionEvaluator chunkSize;
    private final DriverContext driverContext;
    private Warnings warnings;

    public ChunkBytesRefEvaluator(Source source, EvalOperator.ExpressionEvaluator str, EvalOperator.ExpressionEvaluator numChunks, EvalOperator.ExpressionEvaluator chunkSize, DriverContext driverContext) {
        this.source = source;
        this.str = str;
        this.numChunks = numChunks;
        this.chunkSize = chunkSize;
        this.driverContext = driverContext;
    }

    /*
     * Exception decompiling
     */
    public Block eval(Page page) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.str.baseRamBytesUsed();
        baseRamBytesUsed += this.numChunks.baseRamBytesUsed();
        return baseRamBytesUsed += this.chunkSize.baseRamBytesUsed();
    }

    public BytesRefBlock eval(int positionCount, BytesRefBlock strBlock, IntBlock numChunksBlock, IntBlock chunkSizeBlock) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef strScratch = new BytesRef();
            block17: for (int p = 0; p < positionCount; ++p) {
                switch (strBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block17;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block17;
                    }
                }
                switch (numChunksBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block17;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block17;
                    }
                }
                switch (chunkSizeBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block17;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block17;
                    }
                }
                BytesRef str = strBlock.getBytesRef(strBlock.getFirstValueIndex(p), strScratch);
                int numChunks = numChunksBlock.getInt(numChunksBlock.getFirstValueIndex(p));
                int chunkSize = chunkSizeBlock.getInt(chunkSizeBlock.getFirstValueIndex(p));
                Chunk.process(result, str, numChunks, chunkSize);
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public BytesRefBlock eval(int positionCount, BytesRefVector strVector, IntVector numChunksVector, IntVector chunkSizeVector) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef strScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                BytesRef str = strVector.getBytesRef(p, strScratch);
                int numChunks = numChunksVector.getInt(p);
                int chunkSize = chunkSizeVector.getInt(p);
                Chunk.process(result, str, numChunks, chunkSize);
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public String toString() {
        return "ChunkBytesRefEvaluator[str=" + String.valueOf(this.str) + ", numChunks=" + String.valueOf(this.numChunks) + ", chunkSize=" + String.valueOf(this.chunkSize) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.str, this.numChunks, this.chunkSize});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory str;
        private final EvalOperator.ExpressionEvaluator.Factory numChunks;
        private final EvalOperator.ExpressionEvaluator.Factory chunkSize;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory str, EvalOperator.ExpressionEvaluator.Factory numChunks, EvalOperator.ExpressionEvaluator.Factory chunkSize) {
            this.source = source;
            this.str = str;
            this.numChunks = numChunks;
            this.chunkSize = chunkSize;
        }

        public ChunkBytesRefEvaluator get(DriverContext context) {
            return new ChunkBytesRefEvaluator(this.source, this.str.get(context), this.numChunks.get(context), this.chunkSize.get(context), context);
        }

        public String toString() {
            return "ChunkBytesRefEvaluator[str=" + String.valueOf(this.str) + ", numChunks=" + String.valueOf(this.numChunks) + ", chunkSize=" + String.valueOf(this.chunkSize) + "]";
        }
    }
}

