/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.SurrogateExpression;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Avg;
import org.elasticsearch.xpack.esql.expression.function.aggregate.CountOverTime;
import org.elasticsearch.xpack.esql.expression.function.aggregate.SumOverTime;
import org.elasticsearch.xpack.esql.expression.function.aggregate.SummationMode;
import org.elasticsearch.xpack.esql.expression.function.aggregate.TimeSeriesAggregateFunction;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Div;

public class AvgOverTime
extends TimeSeriesAggregateFunction
implements OptionalArgument,
SurrogateExpression {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "AvgOverTime", AvgOverTime::new);

    @FunctionInfo(returnType={"double"}, description="Calculates the average over time of a numeric field.", type=FunctionType.TIME_SERIES_AGGREGATE, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW, version="9.2.0")}, preview=true, examples={@Example(file="k8s-timeseries", tag="avg_over_time")})
    public AvgOverTime(Source source, @Param(name="number", type={"aggregate_metric_double", "double", "integer", "long"}, description="Expression that outputs values to average.") Expression field, @Param(name="window", type={"time_duration"}, description="the time window over which to compute the average", optional=true) Expression window) {
        this(source, field, (Expression)Literal.TRUE, (Expression)Objects.requireNonNullElse(window, NO_WINDOW));
    }

    public AvgOverTime(Source source, Expression field, Expression filter, Expression window) {
        super(source, field, filter, window, Collections.emptyList());
    }

    private AvgOverTime(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return this.perTimeSeriesAggregation().resolveType();
    }

    public String getWriteableName() {
        return AvgOverTime.ENTRY.name;
    }

    public DataType dataType() {
        return this.perTimeSeriesAggregation().dataType();
    }

    protected NodeInfo<AvgOverTime> info() {
        return NodeInfo.create((Node)this, AvgOverTime::new, (Object)this.field(), (Object)this.filter(), (Object)this.window());
    }

    public AvgOverTime replaceChildren(List<Expression> newChildren) {
        return new AvgOverTime(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2));
    }

    @Override
    public AvgOverTime withFilter(Expression filter) {
        return new AvgOverTime(this.source(), this.field(), filter, this.window());
    }

    @Override
    public Expression surrogate() {
        Source s = this.source();
        Expression f = this.field();
        return new Div(s, (Expression)new SumOverTime(s, f, this.filter(), this.window()), (Expression)new CountOverTime(s, f, this.filter(), this.window()), this.dataType());
    }

    @Override
    public AggregateFunction perTimeSeriesAggregation() {
        return new Avg(this.source(), this.field(), this.filter(), this.window(), (Expression)SummationMode.LOSSY_LITERAL);
    }
}

