/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers.schema.id;

import io.confluent.kafka.serializers.schema.id.SchemaId;
import io.confluent.kafka.serializers.schema.id.SchemaIdSerializer;
import java.io.ByteArrayOutputStream;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Headers;

public class PrefixSchemaIdSerializer
implements SchemaIdSerializer {
    @Override
    public byte[] serialize(String topic, boolean isKey, Headers headers, byte[] payload, SchemaId schemaId) throws SerializationException {
        byte[] byArray;
        if (schemaId.getId() == null) {
            throw new SerializationException("Schema ID is null");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(schemaId.idToBytes());
            baos.write(payload);
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new SerializationException("Error serializing schema ID", (Throwable)e);
            }
        }
        baos.close();
        return byArray;
    }
}

