/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.util.Collection;
import java.util.Collections;
import org.apache.qpid.proton.codec.AbstractPrimitiveType;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.FixedSizePrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.TypeEncoding;

public class ShortType
extends AbstractPrimitiveType<Short> {
    private ShortEncoding _shortEncoding;

    ShortType(EncoderImpl encoder, DecoderImpl decoder) {
        this._shortEncoding = new ShortEncoding(encoder, decoder);
        encoder.register(Short.class, this);
        decoder.register(this);
    }

    @Override
    public Class<Short> getTypeClass() {
        return Short.class;
    }

    public ShortEncoding getEncoding(Short val) {
        return this._shortEncoding;
    }

    @Override
    public void write(short s) {
        this._shortEncoding.write(s);
    }

    @Override
    public ShortEncoding getCanonicalEncoding() {
        return this._shortEncoding;
    }

    @Override
    public Collection<ShortEncoding> getAllEncodings() {
        return Collections.singleton(this._shortEncoding);
    }

    public class ShortEncoding
    extends FixedSizePrimitiveTypeEncoding<Short> {
        public ShortEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        protected int getFixedSize() {
            return 2;
        }

        @Override
        public byte getEncodingCode() {
            return 97;
        }

        @Override
        public ShortType getType() {
            return ShortType.this;
        }

        @Override
        public void writeValue(Short val) {
            this.getEncoder().writeRaw(val);
        }

        @Override
        public void writeValue(short val) {
            this.getEncoder().writeRaw(val);
        }

        public void write(short s) {
            this.writeConstructor();
            this.getEncoder().writeRaw(s);
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<Short> encoding) {
            return this.getType() == encoding.getType();
        }

        @Override
        public Short readValue() {
            return this.readPrimitiveValue();
        }

        public short readPrimitiveValue() {
            return this.getDecoder().readRawShort();
        }

        @Override
        public boolean encodesJavaPrimitive() {
            return true;
        }
    }
}

